/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.conn;

import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpConnection;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.ClientConnectionOperator;
import org.apache.http.conn.ConnectionPoolTimeoutException;
import org.apache.http.conn.HostConfiguration;
import org.apache.http.conn.HttpRoute;
import org.apache.http.conn.ManagedClientConnection;
import org.apache.http.conn.OperatedClientConnection;
import org.apache.http.conn.SchemeRegistry;
import org.apache.http.conn.params.HttpConnectionManagerParams;
import org.apache.http.impl.conn.AbstractPoolEntry;
import org.apache.http.impl.conn.AbstractPooledConnAdapter;
import org.apache.http.impl.conn.DefaultClientConnectionOperator;
import org.apache.http.impl.conn.IdleConnectionHandler;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;

public class ThreadSafeClientConnManager
implements ClientConnectionManager {
    private static final Log LOG = LogFactory.getLog((Class)ThreadSafeClientConnManager.class);
    private static final Map REFERENCE_TO_CONNECTION_SOURCE = new HashMap();
    private static final ReferenceQueue REFERENCE_QUEUE = new ReferenceQueue();
    private static ReferenceQueueThread REFERENCE_QUEUE_THREAD;
    private static WeakHashMap ALL_CONNECTION_MANAGERS;
    protected SchemeRegistry schemeRegistry;
    private HttpParams params = new BasicHttpParams();
    private ConnectionPool connectionPool;
    private ClientConnectionOperator connOperator;
    private volatile boolean isShutDown;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThreadSafeClientConnManager(HttpParams params, SchemeRegistry schreg) {
        if (params == null) {
            throw new IllegalArgumentException("Parameters must not be null.");
        }
        this.params = params;
        this.schemeRegistry = schreg;
        this.connectionPool = new ConnectionPool();
        this.connOperator = this.createConnectionOperator(schreg);
        this.isShutDown = false;
        WeakHashMap weakHashMap = ALL_CONNECTION_MANAGERS;
        synchronized (weakHashMap) {
            ALL_CONNECTION_MANAGERS.put(this, null);
        }
    }

    public SchemeRegistry getSchemeRegistry() {
        return this.schemeRegistry;
    }

    public ManagedClientConnection getConnection(HttpRoute route) {
        while (true) {
            try {
                return this.getConnection(route, 0L);
            }
            catch (ConnectionPoolTimeoutException e) {
                LOG.debug((Object)"Unexpected exception while waiting for connection", (Throwable)e);
                continue;
            }
            break;
        }
    }

    public ManagedClientConnection getConnection(HttpRoute route, long timeout) throws ConnectionPoolTimeoutException {
        if (route == null) {
            throw new IllegalArgumentException("Route may not be null.");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("ThreadSafeClientConnManager.getConnection: " + route + ", timeout = " + timeout));
        }
        TrackingPoolEntry entry = this.doGetConnection(route.toHostConfig(), timeout);
        return new HttpConnectionAdapter(entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TrackingPoolEntry doGetConnection(HostConfiguration route, long timeout) throws ConnectionPoolTimeoutException {
        TrackingPoolEntry entry = null;
        int maxHostConnections = HttpConnectionManagerParams.getMaxConnectionsPerHost(this.params, route);
        int maxTotalConnections = HttpConnectionManagerParams.getMaxTotalConnections(this.params);
        ConnectionPool connectionPool = this.connectionPool;
        synchronized (connectionPool) {
            HostConnectionPool hostPool = this.connectionPool.getHostPool(route);
            WaitingThread waitingThread = null;
            boolean useTimeout = timeout > 0L;
            long timeToWait = timeout;
            long startWait = 0L;
            long endWait = 0L;
            while (entry == null) {
                block20: {
                    if (this.isShutDown) {
                        throw new IllegalStateException("Connection manager has been shut down.");
                    }
                    if (hostPool.freeConnections.size() > 0) {
                        entry = this.connectionPool.getFreeConnection(route);
                        continue;
                    }
                    if (hostPool.numConnections < maxHostConnections && this.connectionPool.numConnections < maxTotalConnections) {
                        entry = this.createPoolEntry(route);
                        continue;
                    }
                    if (hostPool.numConnections < maxHostConnections && this.connectionPool.freeConnections.size() > 0) {
                        this.connectionPool.deleteLeastUsedConnection();
                        entry = this.createPoolEntry(route);
                        continue;
                    }
                    try {
                        if (useTimeout && timeToWait <= 0L) {
                            throw new ConnectionPoolTimeoutException("Timeout waiting for connection");
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Unable to get a connection, waiting..., hostConfig=" + route));
                        }
                        if (waitingThread == null) {
                            waitingThread = new WaitingThread();
                            waitingThread.hostConnectionPool = hostPool;
                            waitingThread.thread = Thread.currentThread();
                        } else {
                            waitingThread.interruptedByConnectionPool = false;
                        }
                        if (useTimeout) {
                            startWait = System.currentTimeMillis();
                        }
                        hostPool.waitingThreads.addLast(waitingThread);
                        this.connectionPool.waitingThreads.addLast(waitingThread);
                        this.connectionPool.wait(timeToWait);
                        if (waitingThread.interruptedByConnectionPool) break block20;
                        hostPool.waitingThreads.remove(waitingThread);
                    }
                    catch (InterruptedException e) {
                        block21: {
                            try {
                                if (!waitingThread.interruptedByConnectionPool) {
                                    LOG.debug((Object)"Interrupted while waiting for connection", (Throwable)e);
                                    throw new IllegalThreadStateException("Interrupted while waiting in ThreadSafeClientConnManager");
                                }
                                if (waitingThread.interruptedByConnectionPool) break block21;
                                hostPool.waitingThreads.remove(waitingThread);
                            }
                            catch (Throwable throwable) {
                                if (!waitingThread.interruptedByConnectionPool) {
                                    hostPool.waitingThreads.remove(waitingThread);
                                    this.connectionPool.waitingThreads.remove(waitingThread);
                                }
                                if (useTimeout) {
                                    endWait = System.currentTimeMillis();
                                    timeToWait -= endWait - startWait;
                                }
                                throw throwable;
                            }
                            this.connectionPool.waitingThreads.remove(waitingThread);
                        }
                        if (!useTimeout) continue;
                        endWait = System.currentTimeMillis();
                        timeToWait -= endWait - startWait;
                        continue;
                    }
                    this.connectionPool.waitingThreads.remove(waitingThread);
                }
                if (!useTimeout) continue;
                endWait = System.currentTimeMillis();
                timeToWait -= endWait - startWait;
            }
        }
        return entry;
    }

    private TrackingPoolEntry createPoolEntry(HostConfiguration route) {
        OperatedClientConnection occ = this.connOperator.createConnection();
        return this.connectionPool.createEntry(route, occ);
    }

    protected ClientConnectionOperator createConnectionOperator(SchemeRegistry schreg) {
        return new DefaultClientConnectionOperator(schreg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseConnection(ManagedClientConnection conn) {
        if (!(conn instanceof HttpConnectionAdapter)) {
            throw new IllegalArgumentException("Connection class mismatch, connection not obtained from this manager.");
        }
        HttpConnectionAdapter hca = (HttpConnectionAdapter)conn;
        if (hca.poolEntry != null && hca.connManager != this) {
            throw new IllegalArgumentException("Connection not obtained from this manager.");
        }
        try {
            if (hca.isOpen() && !hca.isMarkedReusable()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Released connection open but not marked reusable.");
                }
                hca.shutdown();
            }
        }
        catch (IOException iox) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Exception shutting down released connection.", (Throwable)iox);
            }
        }
        finally {
            TrackingPoolEntry entry = (TrackingPoolEntry)hca.poolEntry;
            hca.detach();
            this.releasePoolEntry(entry);
        }
    }

    private void releasePoolEntry(TrackingPoolEntry entry) {
        if (entry == null) {
            return;
        }
        this.connectionPool.freeConnection(entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdownAll() {
        Map map = REFERENCE_TO_CONNECTION_SOURCE;
        synchronized (map) {
            WeakHashMap weakHashMap = ALL_CONNECTION_MANAGERS;
            synchronized (weakHashMap) {
                ThreadSafeClientConnManager[] connManagers = ALL_CONNECTION_MANAGERS.keySet().toArray(new ThreadSafeClientConnManager[ALL_CONNECTION_MANAGERS.size()]);
                for (int i = 0; i < connManagers.length; ++i) {
                    if (connManagers[i] == null) continue;
                    connManagers[i].shutdown();
                }
            }
            if (REFERENCE_QUEUE_THREAD != null) {
                REFERENCE_QUEUE_THREAD.shutdown();
                REFERENCE_QUEUE_THREAD = null;
            }
            REFERENCE_TO_CONNECTION_SOURCE.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void storeReferenceToConnection(TrackingPoolEntry connection, HostConfiguration hostConfiguration, ConnectionPool connectionPool) {
        ConnectionSource source = new ConnectionSource();
        source.connectionPool = connectionPool;
        source.hostConfiguration = hostConfiguration;
        Map map = REFERENCE_TO_CONNECTION_SOURCE;
        synchronized (map) {
            if (REFERENCE_QUEUE_THREAD == null) {
                REFERENCE_QUEUE_THREAD = new ReferenceQueueThread();
                REFERENCE_QUEUE_THREAD.start();
            }
            REFERENCE_TO_CONNECTION_SOURCE.put(connection.reference, source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeReferenceToConnection(TrackingPoolEntry entry) {
        Map map = REFERENCE_TO_CONNECTION_SOURCE;
        synchronized (map) {
            REFERENCE_TO_CONNECTION_SOURCE.remove(entry.reference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void shutdownCheckedOutConnections(ConnectionPool connectionPool) {
        ArrayList connectionsToClose = new ArrayList();
        Map map = REFERENCE_TO_CONNECTION_SOURCE;
        synchronized (map) {
            Iterator referenceIter = REFERENCE_TO_CONNECTION_SOURCE.keySet().iterator();
            while (referenceIter.hasNext()) {
                Reference ref = (Reference)referenceIter.next();
                ConnectionSource source = (ConnectionSource)REFERENCE_TO_CONNECTION_SOURCE.get(ref);
                if (source.connectionPool != connectionPool) continue;
                referenceIter.remove();
                Object entry = ref.get();
                if (entry == null) continue;
                connectionsToClose.add(entry);
            }
        }
        Iterator i = connectionsToClose.iterator();
        while (i.hasNext()) {
            TrackingPoolEntry entry = (TrackingPoolEntry)i.next();
            ThreadSafeClientConnManager.closeConnection(entry.connection);
            entry.manager.releasePoolEntry(entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void shutdown() {
        ConnectionPool connectionPool = this.connectionPool;
        synchronized (connectionPool) {
            if (!this.isShutDown) {
                this.isShutDown = true;
                this.connectionPool.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getConnectionsInPool(HostConfiguration hostConfiguration) {
        ConnectionPool connectionPool = this.connectionPool;
        synchronized (connectionPool) {
            HostConnectionPool hostPool = this.connectionPool.getHostPool(hostConfiguration);
            return hostPool.numConnections;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getConnectionsInPool() {
        ConnectionPool connectionPool = this.connectionPool;
        synchronized (connectionPool) {
            return this.connectionPool.numConnections;
        }
    }

    private void deleteClosedConnections() {
        this.connectionPool.deleteClosedConnections();
    }

    public void closeIdleConnections(long idleTimeout) {
        this.connectionPool.closeIdleConnections(idleTimeout);
        this.deleteClosedConnections();
    }

    public HttpParams getParams() {
        return this.params;
    }

    public void setParams(HttpParams params) {
        if (params == null) {
            throw new IllegalArgumentException("Parameters may not be null");
        }
        this.params = params;
    }

    private static void closeConnection(OperatedClientConnection conn) {
        try {
            conn.close();
        }
        catch (IOException ex) {
            LOG.debug((Object)"I/O error closing connection", (Throwable)ex);
        }
    }

    static {
        ALL_CONNECTION_MANAGERS = new WeakHashMap();
    }

    private class HttpConnectionAdapter
    extends AbstractPooledConnAdapter {
        protected HttpConnectionAdapter(TrackingPoolEntry entry) {
            super((ClientConnectionManager)ThreadSafeClientConnManager.this, entry);
            this.markedReusable = true;
        }
    }

    private class TrackingPoolEntry
    extends AbstractPoolEntry {
        private HostConfiguration plannedRoute;
        private ThreadSafeClientConnManager manager;
        private WeakReference reference;

        private TrackingPoolEntry(OperatedClientConnection occ) {
            super(occ);
            this.manager = ThreadSafeClientConnManager.this;
            this.reference = new WeakReference<TrackingPoolEntry>(this, REFERENCE_QUEUE);
        }

        protected ClientConnectionOperator getOperator() {
            return ThreadSafeClientConnManager.this.connOperator;
        }
    }

    private static class ReferenceQueueThread
    extends Thread {
        private volatile boolean isShutDown = false;

        public ReferenceQueueThread() {
            this.setDaemon(true);
            this.setName("ThreadSafeClientConnManager cleanup");
        }

        public void shutdown() {
            this.isShutDown = true;
            this.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleReference(Reference ref) {
            ConnectionSource source = null;
            Map map = REFERENCE_TO_CONNECTION_SOURCE;
            synchronized (map) {
                source = (ConnectionSource)REFERENCE_TO_CONNECTION_SOURCE.remove(ref);
            }
            if (source != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Connection reclaimed by garbage collector, hostConfig=" + source.hostConfiguration));
                }
                source.connectionPool.handleLostConnection(source.hostConfiguration);
            }
        }

        public void run() {
            while (!this.isShutDown) {
                try {
                    Reference ref = REFERENCE_QUEUE.remove();
                    if (ref == null) continue;
                    this.handleReference(ref);
                }
                catch (InterruptedException e) {
                    LOG.debug((Object)"ReferenceQueueThread interrupted", (Throwable)e);
                }
            }
        }
    }

    private static class WaitingThread {
        public Thread thread;
        public HostConnectionPool hostConnectionPool;
        public boolean interruptedByConnectionPool = false;

        private WaitingThread() {
        }
    }

    private static class HostConnectionPool {
        public HostConfiguration hostConfiguration;
        public LinkedList freeConnections = new LinkedList();
        public LinkedList waitingThreads = new LinkedList();
        public int numConnections = 0;

        private HostConnectionPool() {
        }
    }

    private static class ConnectionSource {
        public ConnectionPool connectionPool;
        public HostConfiguration hostConfiguration;

        private ConnectionSource() {
        }
    }

    private class ConnectionPool {
        private LinkedList freeConnections = new LinkedList();
        private LinkedList waitingThreads = new LinkedList();
        private final Map mapHosts = new HashMap();
        private IdleConnectionHandler idleConnectionHandler = new IdleConnectionHandler();
        private int numConnections = 0;

        private ConnectionPool() {
        }

        public synchronized void shutdown() {
            Iterator iter = this.freeConnections.iterator();
            while (iter.hasNext()) {
                TrackingPoolEntry entry = (TrackingPoolEntry)iter.next();
                iter.remove();
                ThreadSafeClientConnManager.closeConnection(entry.connection);
            }
            ThreadSafeClientConnManager.shutdownCheckedOutConnections(this);
            iter = this.waitingThreads.iterator();
            while (iter.hasNext()) {
                WaitingThread waiter = (WaitingThread)iter.next();
                iter.remove();
                waiter.interruptedByConnectionPool = true;
                waiter.thread.interrupt();
            }
            this.mapHosts.clear();
            this.idleConnectionHandler.removeAll();
        }

        protected synchronized TrackingPoolEntry createEntry(HostConfiguration route, OperatedClientConnection conn) {
            HostConnectionPool hostPool = this.getHostPool(route);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Allocating new connection, hostConfiguration=" + route));
            }
            TrackingPoolEntry entry = new TrackingPoolEntry(conn);
            entry.plannedRoute = route;
            ++this.numConnections;
            ++hostPool.numConnections;
            ThreadSafeClientConnManager.storeReferenceToConnection(entry, route, this);
            return entry;
        }

        public synchronized void handleLostConnection(HostConfiguration config) {
            HostConnectionPool hostPool = this.getHostPool(config);
            --hostPool.numConnections;
            if (hostPool.numConnections < 1) {
                this.mapHosts.remove(config);
            }
            --this.numConnections;
            this.notifyWaitingThread(config);
        }

        public synchronized HostConnectionPool getHostPool(HostConfiguration route) {
            HostConnectionPool listConnections = (HostConnectionPool)this.mapHosts.get(route);
            if (listConnections == null) {
                listConnections = new HostConnectionPool();
                listConnections.hostConfiguration = route;
                this.mapHosts.put(route, listConnections);
            }
            return listConnections;
        }

        public synchronized TrackingPoolEntry getFreeConnection(HostConfiguration hostConfiguration) {
            TrackingPoolEntry entry = null;
            HostConnectionPool hostPool = this.getHostPool(hostConfiguration);
            if (hostPool.freeConnections.size() > 0) {
                entry = (TrackingPoolEntry)hostPool.freeConnections.removeLast();
                this.freeConnections.remove(entry);
                ThreadSafeClientConnManager.storeReferenceToConnection(entry, hostConfiguration, this);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Getting free connection, hostConfig=" + hostConfiguration));
                }
                this.idleConnectionHandler.remove((HttpConnection)entry.connection);
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("There were no free connections to get, hostConfig=" + hostConfiguration));
            }
            return entry;
        }

        public synchronized void deleteClosedConnections() {
            Iterator iter = this.freeConnections.iterator();
            while (iter.hasNext()) {
                TrackingPoolEntry entry = (TrackingPoolEntry)iter.next();
                if (entry.connection.isOpen()) continue;
                iter.remove();
                this.deleteConnection(entry);
            }
        }

        public synchronized void closeIdleConnections(long idleTimeout) {
            this.idleConnectionHandler.closeIdleConnections(idleTimeout);
        }

        private synchronized void deleteConnection(TrackingPoolEntry entry) {
            HostConfiguration route = entry.plannedRoute;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Reclaiming connection, hostConfig=" + route));
            }
            ThreadSafeClientConnManager.closeConnection(entry.connection);
            HostConnectionPool hostPool = this.getHostPool(route);
            hostPool.freeConnections.remove(entry);
            --hostPool.numConnections;
            --this.numConnections;
            if (hostPool.numConnections < 1) {
                this.mapHosts.remove(route);
            }
            this.idleConnectionHandler.remove((HttpConnection)entry.connection);
        }

        public synchronized void deleteLeastUsedConnection() {
            TrackingPoolEntry entry = (TrackingPoolEntry)this.freeConnections.removeFirst();
            if (entry != null) {
                this.deleteConnection(entry);
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Attempted to reclaim an unused connection but there were none.");
            }
        }

        public synchronized void notifyWaitingThread(HostConfiguration configuration) {
            this.notifyWaitingThread(this.getHostPool(configuration));
        }

        public synchronized void notifyWaitingThread(HostConnectionPool hostPool) {
            WaitingThread waitingThread = null;
            if (hostPool.waitingThreads.size() > 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Notifying thread waiting on host pool, hostConfig=" + hostPool.hostConfiguration));
                }
                waitingThread = (WaitingThread)hostPool.waitingThreads.removeFirst();
                this.waitingThreads.remove(waitingThread);
            } else if (this.waitingThreads.size() > 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"No-one waiting on host pool, notifying next waiting thread.");
                }
                waitingThread = (WaitingThread)this.waitingThreads.removeFirst();
                waitingThread.hostConnectionPool.waitingThreads.remove(waitingThread);
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Notifying no-one, there are no waiting threads");
            }
            if (waitingThread != null) {
                waitingThread.interruptedByConnectionPool = true;
                waitingThread.thread.interrupt();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void freeConnection(TrackingPoolEntry entry) {
            HostConfiguration route = entry.plannedRoute;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Freeing connection, hostConfig=" + route));
            }
            ConnectionPool connectionPool = this;
            synchronized (connectionPool) {
                if (ThreadSafeClientConnManager.this.isShutDown) {
                    ThreadSafeClientConnManager.closeConnection(entry.connection);
                    return;
                }
                HostConnectionPool hostPool = this.getHostPool(route);
                hostPool.freeConnections.add(entry);
                if (hostPool.numConnections == 0) {
                    LOG.error((Object)("Host connection pool not found, hostConfig=" + route));
                    hostPool.numConnections = 1;
                }
                this.freeConnections.add(entry);
                ThreadSafeClientConnManager.removeReferenceToConnection(entry);
                if (this.numConnections == 0) {
                    LOG.error((Object)("Host connection pool not found, hostConfig=" + route));
                    this.numConnections = 1;
                }
                this.idleConnectionHandler.add((HttpConnection)entry.connection);
                this.notifyWaitingThread(hostPool);
            }
        }
    }
}

