/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.methods;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.client.methods.HttpRequestBase;

public class HttpOptions
extends HttpRequestBase {
    public static final String METHOD_NAME = "OPTIONS";

    public HttpOptions() {
    }

    public HttpOptions(URI uri) {
        this.setURI(uri);
    }

    public HttpOptions(String uri) throws URISyntaxException {
        this.setURI(new URI(uri));
    }

    public String getMethod() {
        return METHOD_NAME;
    }

    public Set getAllowedMethods(HttpResponse response) throws ParseException {
        if (response == null) {
            throw new IllegalArgumentException("HTTP response may not be null");
        }
        Header header = response.getFirstHeader("Allow");
        if (header == null) {
            return Collections.EMPTY_SET;
        }
        HeaderElement[] elements = header.getElements();
        HashSet<String> methods = new HashSet<String>(elements.length);
        for (int i = 0; i < elements.length; ++i) {
            methods.add(elements[i].getName());
        }
        return methods;
    }
}

