/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.client.CircularRedirectException;
import org.apache.http.client.RedirectHandler;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;

public class DefaultRedirectHandler
implements RedirectHandler {
    private static final Log LOG = LogFactory.getLog((Class)DefaultRedirectHandler.class);
    private static final String REDIRECT_LOCATIONS = "http.protocol.redirect-locations";

    public boolean isRedirectRequested(HttpResponse response, HttpContext context) {
        if (response == null) {
            throw new IllegalArgumentException("HTTP response may not be null");
        }
        int statusCode = response.getStatusLine().getStatusCode();
        switch (statusCode) {
            case 301: 
            case 302: 
            case 303: 
            case 307: {
                return true;
            }
        }
        return false;
    }

    public URI getLocationURI(HttpResponse response, HttpContext context) throws ProtocolException {
        URI uri;
        if (response == null) {
            throw new IllegalArgumentException("HTTP response may not be null");
        }
        Header locationHeader = response.getFirstHeader("location");
        if (locationHeader == null) {
            throw new ProtocolException("Received redirect response " + response.getStatusLine() + " but no location header");
        }
        String location = locationHeader.getValue();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Redirect requested to location '" + location + "'"));
        }
        try {
            uri = new URI(location);
        }
        catch (URISyntaxException ex) {
            throw new ProtocolException("Invalid redirect URI: " + location, (Throwable)ex);
        }
        HttpParams params = response.getParams();
        if (!uri.isAbsolute()) {
            if (params.isParameterTrue("http.protocol.reject-relative-redirect")) {
                throw new ProtocolException("Relative redirect location '" + uri + "' not allowed");
            }
            HttpHost target = (HttpHost)context.getAttribute("http.target_host");
            if (target == null) {
                throw new IllegalStateException("Target host not available in the HTTP context");
            }
            HttpRequest request = (HttpRequest)context.getAttribute("http.request");
            try {
                URI requestURI = new URI(request.getRequestLine().getUri());
                URI absoluteRequestURI = new URI(target.getSchemeName(), null, target.getHostName(), target.getPort(), requestURI.getPath(), requestURI.getQuery(), requestURI.getFragment());
                uri = absoluteRequestURI.resolve(uri);
            }
            catch (URISyntaxException ex) {
                throw new ProtocolException(ex.getMessage(), (Throwable)ex);
            }
        }
        if (params.isParameterFalse("http.protocol.allow-circular-redirects")) {
            URI redirectURI;
            HashSet<URI> redirectLocations = (HashSet<URI>)context.getAttribute(REDIRECT_LOCATIONS);
            if (redirectLocations == null) {
                redirectLocations = new HashSet<URI>();
                context.setAttribute(REDIRECT_LOCATIONS, redirectLocations);
            }
            if (uri.getQuery() != null || uri.getFragment() != null) {
                try {
                    redirectURI = new URI(uri.getScheme(), null, uri.getHost(), uri.getPort(), uri.getPath(), null, null);
                }
                catch (URISyntaxException ex) {
                    throw new ProtocolException(ex.getMessage(), (Throwable)ex);
                }
            } else {
                redirectURI = uri;
            }
            if (redirectLocations.contains(redirectURI)) {
                throw new CircularRedirectException("Circular redirect to '" + redirectURI + "'");
            }
            redirectLocations.add(redirectURI);
        }
        return uri;
    }
}

