/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.conn;

import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.HttpRoute;
import org.apache.http.conn.HttpRoutePlanner;
import org.apache.http.conn.Scheme;
import org.apache.http.protocol.HttpContext;

public class DefaultHttpRoutePlanner
implements HttpRoutePlanner {
    private ClientConnectionManager connectionManager;

    public DefaultHttpRoutePlanner(ClientConnectionManager aConnManager) {
        this.setConnectionManager(aConnManager);
    }

    public void setConnectionManager(ClientConnectionManager aConnManager) {
        this.connectionManager = aConnManager;
    }

    public HttpRoute determineRoute(HttpHost target, HttpRequest request, HttpContext context) throws HttpException {
        if (target == null) {
            throw new IllegalStateException("Target host must not be null.");
        }
        if (request == null) {
            throw new IllegalStateException("Request must not be null.");
        }
        HttpHost proxy = (HttpHost)request.getParams().getParameter("http.default-proxy");
        Scheme schm = this.connectionManager.getSchemeRegistry().getScheme(target.getSchemeName());
        boolean secure = schm.isLayered();
        HttpRoute route = null;
        route = proxy == null ? new HttpRoute(target, null, secure) : new HttpRoute(target, null, proxy, secure);
        return route;
    }
}

