/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.protocol;

import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.auth.AuthSchemeProvider;
import org.apache.http.auth.AuthState;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.protocol.ClientContext;
import org.apache.http.config.Lookup;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.routing.RouteInfo;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.CookieSpec;
import org.apache.http.cookie.CookieSpecProvider;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpCoreContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public class HttpClientContext
extends HttpCoreContext
implements ClientContext {
    public static HttpClientContext adapt(HttpContext context) {
        if (context instanceof HttpClientContext) {
            return (HttpClientContext)context;
        }
        return new HttpClientContext(context);
    }

    public static HttpClientContext create() {
        return new HttpClientContext((HttpContext)new BasicHttpContext());
    }

    public HttpClientContext(HttpContext context) {
        super(context);
    }

    public HttpClientContext() {
    }

    public RouteInfo getHttpRoute() {
        return (RouteInfo)this.getAttribute("http.route", HttpRoute.class);
    }

    public CookieStore getCookieStore() {
        return (CookieStore)this.getAttribute("http.cookie-store", CookieStore.class);
    }

    public void setCookieStore(CookieStore cookieStore) {
        this.setAttribute("http.cookie-store", cookieStore);
    }

    public CookieSpec getCookieSpec() {
        return (CookieSpec)this.getAttribute("http.cookie-spec", CookieSpec.class);
    }

    public CookieOrigin getCookieOrigin() {
        return (CookieOrigin)this.getAttribute("http.cookie-origin", CookieOrigin.class);
    }

    protected <T> Lookup<T> getLookup(String name, Class<T> clazz) {
        return (Lookup)this.getAttribute(name, Lookup.class);
    }

    public Lookup<CookieSpecProvider> getCookieSpecRegistry() {
        return this.getLookup("http.cookiespec-registry", CookieSpecProvider.class);
    }

    public void setCookieSpecRegistry(Lookup<CookieSpecProvider> lookup) {
        this.setAttribute("http.cookiespec-registry", lookup);
    }

    public Lookup<AuthSchemeProvider> getAuthSchemeRegistry() {
        return this.getLookup("http.authscheme-registry", AuthSchemeProvider.class);
    }

    public void setAuthSchemeRegistry(Lookup<AuthSchemeProvider> lookup) {
        this.setAttribute("http.authscheme-registry", lookup);
    }

    public Lookup<ConnectionSocketFactory> getSocketFactoryRegistry() {
        return this.getLookup("http.socket-factory-registry", ConnectionSocketFactory.class);
    }

    public void setSocketFactoryRegistry(Lookup<ConnectionSocketFactory> lookup) {
        this.setAttribute("http.socket-factory-registry", lookup);
    }

    public CredentialsProvider getCredentialsProvider() {
        return (CredentialsProvider)this.getAttribute("http.auth.credentials-provider", CredentialsProvider.class);
    }

    public void setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.setAttribute("http.auth.credentials-provider", credentialsProvider);
    }

    public AuthCache getAuthCache() {
        return (AuthCache)this.getAttribute("http.auth.auth-cache", AuthCache.class);
    }

    public void setAuthCache(AuthCache authCache) {
        this.setAttribute("http.auth.auth-cache", authCache);
    }

    public AuthState getTargetAuthState() {
        return (AuthState)this.getAttribute("http.auth.target-scope", AuthState.class);
    }

    public AuthState getProxyAuthState() {
        return (AuthState)this.getAttribute("http.auth.proxy-scope", AuthState.class);
    }

    public <T> T getUserToken(Class<T> clazz) {
        return (T)this.getAttribute("http.user-token", clazz);
    }

    public Object getUserToken() {
        return this.getAttribute("http.user-token");
    }

    public void setUserToken(Object obj) {
        this.setAttribute("http.user-token", obj);
    }

    public RequestConfig getRequestConfig() {
        RequestConfig config = (RequestConfig)this.getAttribute("http.request-config", RequestConfig.class);
        return config != null ? config : RequestConfig.DEFAULT;
    }

    public void setRequestConfig(RequestConfig config) {
        this.setAttribute("http.request-config", config);
    }
}

