/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.cache;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.cache.LRULinkedHashMap;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.common.Chunk;
import org.apache.iotdb.tsfile.utils.RamUsageEstimator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChunkCache {
    private static final Logger logger = LoggerFactory.getLogger(ChunkCache.class);
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private static final long MEMORY_THRESHOLD_IN_CHUNK_CACHE = config.getAllocateMemoryForChunkCache();
    private static final boolean CACHE_ENABLE = config.isMetaDataCacheEnable();
    private final LRULinkedHashMap<ChunkMetadata, Chunk> lruCache;
    private final AtomicLong cacheHitNum = new AtomicLong();
    private final AtomicLong cacheRequestNum = new AtomicLong();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    private ChunkCache() {
        if (CACHE_ENABLE) {
            logger.info("ChunkCache size = " + MEMORY_THRESHOLD_IN_CHUNK_CACHE);
        }
        this.lruCache = new LRULinkedHashMap<ChunkMetadata, Chunk>(MEMORY_THRESHOLD_IN_CHUNK_CACHE){

            @Override
            protected long calEntrySize(ChunkMetadata key, Chunk value) {
                long currentSize;
                if (this.count < 10) {
                    currentSize = (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF + RamUsageEstimator.sizeOf((Object)value);
                    this.averageSize = (this.averageSize * (long)this.count + currentSize) / (long)(++this.count);
                } else if (this.count < 100000) {
                    ++this.count;
                    currentSize = this.averageSize;
                } else {
                    this.averageSize = (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF + RamUsageEstimator.sizeOf((Object)value);
                    this.count = 1;
                    currentSize = this.averageSize;
                }
                return currentSize;
            }
        };
    }

    public static ChunkCache getInstance() {
        return ChunkCacheHolder.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Chunk get(ChunkMetadata chunkMetaData, TsFileSequenceReader reader) throws IOException {
        Chunk chunk;
        if (!CACHE_ENABLE) {
            Chunk chunk2 = reader.readMemChunk(chunkMetaData);
            return new Chunk(chunk2.getHeader(), chunk2.getData().duplicate(), chunk2.getDeletedAt());
        }
        this.cacheRequestNum.incrementAndGet();
        this.lock.readLock().lock();
        try {
            chunk = this.lruCache.get(chunkMetaData);
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (chunk != null) {
            this.cacheHitNum.incrementAndGet();
            this.printCacheLog(true);
        } else {
            this.printCacheLog(false);
            try {
                chunk = reader.readMemChunk(chunkMetaData);
            }
            catch (IOException e) {
                logger.error("something wrong happened while reading {}", (Object)reader.getFileName());
                throw e;
            }
            this.lock.writeLock().lock();
            try {
                this.lruCache.put(chunkMetaData, chunk);
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        return new Chunk(chunk.getHeader(), chunk.getData().duplicate(), chunk.getDeletedAt());
    }

    private void printCacheLog(boolean isHit) {
        if (!logger.isDebugEnabled()) {
            return;
        }
        logger.debug("[ChunkMetaData cache {}hit] The number of requests for cache is {}, hit rate is {}.", new Object[]{isHit ? "" : "didn't ", this.cacheRequestNum.get(), (double)this.cacheHitNum.get() * 1.0 / (double)this.cacheRequestNum.get()});
    }

    public double calculateChunkHitRatio() {
        if (this.cacheRequestNum.get() != 0L) {
            return (double)this.cacheHitNum.get() * 1.0 / (double)this.cacheRequestNum.get();
        }
        return 0.0;
    }

    public long getUsedMemory() {
        return this.lruCache.getUsedMemory();
    }

    public long getMaxMemory() {
        return this.lruCache.getMaxMemory();
    }

    public double getUsedMemoryProportion() {
        return this.lruCache.getUsedMemoryProportion();
    }

    public long getAverageSize() {
        return this.lruCache.getAverageSize();
    }

    public void clear() {
        this.lock.writeLock().lock();
        if (this.lruCache != null) {
            this.lruCache.clear();
        }
        this.lock.writeLock().unlock();
    }

    public void remove(ChunkMetadata chunkMetaData) {
        this.lock.writeLock().lock();
        if (chunkMetaData != null) {
            this.lruCache.remove(chunkMetaData);
        }
        this.lock.writeLock().unlock();
    }

    public boolean isEmpty() {
        return this.lruCache.isEmpty();
    }

    private static class ChunkCacheHolder {
        private static final ChunkCache INSTANCE = new ChunkCache();

        private ChunkCacheHolder() {
        }
    }
}

