/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.flush;

import org.apache.iotdb.db.engine.storagegroup.StorageGroupProcessor;
import org.apache.iotdb.db.engine.storagegroup.TsFileProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface TsFileFlushPolicy {
    public void apply(StorageGroupProcessor var1, TsFileProcessor var2, boolean var3);

    public static class DirectFlushPolicy
    implements TsFileFlushPolicy {
        private static final Logger logger = LoggerFactory.getLogger(DirectFlushPolicy.class);

        @Override
        public void apply(StorageGroupProcessor storageGroupProcessor, TsFileProcessor tsFileProcessor, boolean isSeq) {
            if (tsFileProcessor.shouldClose()) {
                storageGroupProcessor.asyncCloseOneTsFileProcessor(isSeq, tsFileProcessor);
                logger.info("Async close tsfile: {}", (Object)tsFileProcessor.getTsFileResource().getFile().getAbsolutePath());
            } else {
                tsFileProcessor.asyncFlush();
                logger.info("Async flush a memtable to tsfile: {}", (Object)tsFileProcessor.getTsFileResource().getFile().getAbsolutePath());
            }
        }
    }
}

