/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.merge.task;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.merge.recover.LogAnalyzer;
import org.apache.iotdb.db.engine.merge.recover.MergeLogger;
import org.apache.iotdb.db.engine.merge.task.MergeCallback;
import org.apache.iotdb.db.engine.merge.task.MergeFileTask;
import org.apache.iotdb.db.engine.merge.task.MergeMultiChunkTask;
import org.apache.iotdb.db.engine.merge.task.MergeTask;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.utils.MergeUtils;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.write.writer.RestorableTsFileIOWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecoverMergeTask
extends MergeTask {
    private static final Logger logger = LoggerFactory.getLogger(RecoverMergeTask.class);
    private LogAnalyzer analyzer;

    public RecoverMergeTask(List<TsFileResource> seqFiles, List<TsFileResource> unseqFiles, String storageGroupSysDir, MergeCallback callback, String taskName, boolean fullMerge, String storageGroupName) {
        super(seqFiles, unseqFiles, storageGroupSysDir, callback, taskName, fullMerge, storageGroupName);
    }

    public void recoverMerge(boolean continueMerge) throws IOException, MetadataException {
        File logFile = new File(this.storageGroupSysDir, "merge.log");
        if (!logFile.exists()) {
            logger.info("{} no merge.log, merge recovery ends", (Object)this.taskName);
            return;
        }
        long startTime = System.currentTimeMillis();
        this.analyzer = new LogAnalyzer(this.resource, this.taskName, logFile, this.storageGroupName);
        LogAnalyzer.Status status = this.analyzer.analyze();
        if (logger.isInfoEnabled()) {
            logger.info("{} merge recovery status determined: {} after {}ms", new Object[]{this.taskName, status, System.currentTimeMillis() - startTime});
        }
        switch (status) {
            case NONE: {
                logFile.delete();
                break;
            }
            case MERGE_START: {
                this.resumeAfterFilesLogged(continueMerge);
                break;
            }
            case ALL_TS_MERGED: {
                this.resumeAfterAllTsMerged(continueMerge);
                break;
            }
            case MERGE_END: {
                this.cleanUp(continueMerge);
                break;
            }
            default: {
                throw new UnsupportedOperationException(this.taskName + " found unrecognized status " + (Object)((Object)status));
            }
        }
        if (logger.isInfoEnabled()) {
            logger.info("{} merge recovery ends after {}ms", (Object)this.taskName, (Object)(System.currentTimeMillis() - startTime));
        }
    }

    private void resumeAfterFilesLogged(boolean continueMerge) throws IOException {
        if (continueMerge) {
            this.resumeMergeProgress();
            this.calculateConcurrentSeriesNum();
            if (this.concurrentMergeSeriesNum == 0) {
                throw new IOException("Merge cannot be resumed under current memory budget, please increase the budget or disable continueMergeAfterReboot");
            }
            MergeMultiChunkTask mergeChunkTask = new MergeMultiChunkTask(this.mergeContext, this.taskName, this.mergeLogger, this.resource, this.fullMerge, this.analyzer.getUnmergedPaths(), this.concurrentMergeSeriesNum);
            this.analyzer.setUnmergedPaths(null);
            mergeChunkTask.mergeSeries();
            MergeFileTask mergeFileTask = new MergeFileTask(this.taskName, this.mergeContext, this.mergeLogger, this.resource, this.resource.getSeqFiles());
            mergeFileTask.mergeFiles();
        }
        this.cleanUp(continueMerge);
    }

    private void resumeAfterAllTsMerged(boolean continueMerge) throws IOException {
        if (continueMerge) {
            this.resumeMergeProgress();
            MergeFileTask mergeFileTask = new MergeFileTask(this.taskName, this.mergeContext, this.mergeLogger, this.resource, this.analyzer.getUnmergedFiles());
            this.analyzer.setUnmergedFiles(null);
            mergeFileTask.mergeFiles();
        } else {
            this.truncateFiles();
        }
        this.cleanUp(continueMerge);
    }

    private void resumeMergeProgress() throws IOException {
        this.mergeLogger = new MergeLogger(this.storageGroupSysDir);
        this.truncateFiles();
        this.recoverChunkCounts();
    }

    private void calculateConcurrentSeriesNum() throws IOException {
        long singleSeriesUnseqCost = 0L;
        long maxUnseqCost = 0L;
        for (TsFileResource unseqFile : this.resource.getUnseqFiles()) {
            long[] chunkNums = MergeUtils.findTotalAndLargestSeriesChunkNum(unseqFile, this.resource.getFileReader(unseqFile));
            long totalChunkNum = chunkNums[0];
            long maxChunkNum = chunkNums[1];
            singleSeriesUnseqCost += unseqFile.getFileSize() * maxChunkNum / totalChunkNum;
            maxUnseqCost += unseqFile.getFileSize();
        }
        long singleSeriesSeqReadCost = 0L;
        long maxSeqReadCost = 0L;
        long seqWriteCost = 0L;
        for (TsFileResource seqFile : this.resource.getSeqFiles()) {
            long[] chunkNums = MergeUtils.findTotalAndLargestSeriesChunkNum(seqFile, this.resource.getFileReader(seqFile));
            long totalChunkNum = chunkNums[0];
            long maxChunkNum = chunkNums[1];
            long fileMetaSize = MergeUtils.getFileMetaSize(seqFile, this.resource.getFileReader(seqFile));
            long newSingleSeriesSeqReadCost = fileMetaSize * maxChunkNum / totalChunkNum;
            singleSeriesSeqReadCost = newSingleSeriesSeqReadCost > singleSeriesSeqReadCost ? newSingleSeriesSeqReadCost : singleSeriesSeqReadCost;
            maxSeqReadCost = fileMetaSize > maxSeqReadCost ? fileMetaSize : maxSeqReadCost;
            seqWriteCost += fileMetaSize;
        }
        long memBudget = IoTDBDescriptor.getInstance().getConfig().getMergeMemoryBudget();
        int lb = 0;
        int ub = 1024;
        int mid = (lb + ub) / 2;
        while (mid != lb) {
            long seqReadCos;
            long unseqCost = singleSeriesUnseqCost * (long)mid < maxUnseqCost ? singleSeriesUnseqCost * (long)mid : maxUnseqCost;
            long totalCost = unseqCost + (seqReadCos = singleSeriesSeqReadCost * (long)mid < maxSeqReadCost ? singleSeriesSeqReadCost * (long)mid : maxSeqReadCost) + seqWriteCost;
            if (totalCost <= memBudget) {
                lb = mid;
            } else {
                ub = mid;
            }
            mid = (lb + ub) / 2;
        }
        this.concurrentMergeSeriesNum = lb;
    }

    private void recoverChunkCounts() throws IOException {
        logger.info("{} recovering chunk counts", (Object)this.taskName);
        int fileCnt = 1;
        for (TsFileResource tsFileResource : this.resource.getSeqFiles()) {
            logger.info("{} recovering {}  {}/{}", new Object[]{this.taskName, tsFileResource.getFile().getName(), fileCnt, this.resource.getSeqFiles().size()});
            RestorableTsFileIOWriter mergeFileWriter = this.resource.getMergeFileWriter(tsFileResource);
            mergeFileWriter.makeMetadataVisible();
            this.mergeContext.getUnmergedChunkStartTimes().put(tsFileResource, new HashMap());
            List<Path> pathsToRecover = this.analyzer.getMergedPaths();
            int cnt = 0;
            double progress = 0.0;
            for (Path path : pathsToRecover) {
                double newProgress;
                this.recoverChunkCounts(path, tsFileResource, mergeFileWriter);
                if (!logger.isInfoEnabled() || !((newProgress = 100.0 * (double)(cnt = (int)((double)cnt + 1.0)) / (double)pathsToRecover.size()) - progress >= 1.0)) continue;
                progress = newProgress;
                logger.info("{} {}% series count of {} are recovered", new Object[]{this.taskName, progress, tsFileResource.getFile().getName()});
            }
            ++fileCnt;
        }
        this.analyzer.setMergedPaths(null);
    }

    private void recoverChunkCounts(Path path, TsFileResource tsFileResource, RestorableTsFileIOWriter mergeFileWriter) throws IOException {
        this.mergeContext.getUnmergedChunkStartTimes().get(tsFileResource).put(path, new ArrayList());
        List<ChunkMetadata> seqFileChunks = this.resource.queryChunkMetadata(path, tsFileResource);
        List mergeFileChunks = mergeFileWriter.getVisibleMetadataList(path.getDevice(), path.getMeasurement(), null);
        this.mergeContext.getMergedChunkCnt().compute(tsFileResource, (k, v) -> v == null ? mergeFileChunks.size() : v + mergeFileChunks.size());
        int seqChunkIndex = 0;
        int mergeChunkIndex = 0;
        int unmergedCnt = 0;
        while (seqChunkIndex < seqFileChunks.size() && mergeChunkIndex < mergeFileChunks.size()) {
            ChunkMetadata seqChunk = seqFileChunks.get(seqChunkIndex);
            ChunkMetadata mergedChunk = (ChunkMetadata)mergeFileChunks.get(mergeChunkIndex);
            if (seqChunk.getStartTime() < mergedChunk.getStartTime()) {
                ++unmergedCnt;
                ++seqChunkIndex;
                this.mergeContext.getUnmergedChunkStartTimes().get(tsFileResource).get(path).add(seqChunk.getStartTime());
                continue;
            }
            if (mergedChunk.getStartTime() <= seqChunk.getStartTime() && seqChunk.getStartTime() <= mergedChunk.getEndTime()) {
                ++seqChunkIndex;
                continue;
            }
            ++mergeChunkIndex;
        }
        int finalUnmergedCnt = unmergedCnt;
        this.mergeContext.getUnmergedChunkCnt().compute(tsFileResource, (k, v) -> v == null ? finalUnmergedCnt : v + finalUnmergedCnt);
    }

    private void truncateFiles() throws IOException {
        logger.info("{} truncating {} files", (Object)this.taskName, (Object)this.analyzer.getFileLastPositions().size());
        for (Map.Entry<File, Long> entry : this.analyzer.getFileLastPositions().entrySet()) {
            File file = entry.getKey();
            Long lastPosition = entry.getValue();
            if (!file.exists() || file.length() == lastPosition.longValue()) continue;
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                FileChannel channel = fileInputStream.getChannel();
                channel.truncate(lastPosition);
                channel.close();
            }
        }
        this.analyzer.setFileLastPositions(null);
    }
}

