/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.modification;

import java.util.Objects;
import org.apache.iotdb.tsfile.read.common.Path;

public abstract class Modification {
    protected Type type;
    protected Path path;
    protected long versionNum;

    Modification(Type type, Path path, long versionNum) {
        this.type = type;
        this.path = path;
        this.versionNum = versionNum;
    }

    public String getPathString() {
        return this.path.getFullPath();
    }

    public Path getPath() {
        return this.path;
    }

    public String getDevice() {
        return this.path.getDevice();
    }

    public String getMeasurement() {
        return this.path.getMeasurement();
    }

    public void setPath(Path path) {
        this.path = path;
    }

    public long getVersionNum() {
        return this.versionNum;
    }

    public void setVersionNum(long versionNum) {
        this.versionNum = versionNum;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Modification)) {
            return false;
        }
        Modification mod = (Modification)obj;
        return mod.type.equals((Object)this.type) && mod.path.equals((Object)this.path) && mod.versionNum == this.versionNum;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.path, this.versionNum});
    }

    public static enum Type {
        DELETION;

    }
}

