/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.upgrade;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.concurrent.WrappedRunnable;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.engine.upgrade.UpgradeCheckStatus;
import org.apache.iotdb.db.engine.upgrade.UpgradeLog;
import org.apache.iotdb.db.service.UpgradeSevice;
import org.apache.iotdb.db.tools.upgrade.TsFileOnlineUpgradeTool;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTask
extends WrappedRunnable {
    private TsFileResource upgradeResource;
    private static final Logger logger = LoggerFactory.getLogger(UpgradeTask.class);
    private static final String COMMA_SEPERATOR = ",";

    public UpgradeTask(TsFileResource upgradeResource) {
        this.upgradeResource = upgradeResource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runMayThrow() {
        try {
            List<TsFileResource> upgradedResources = this.generateUpgradedFiles();
            this.upgradeResource.getWriteQueryLock().writeLock().lock();
            String oldTsfilePath = this.upgradeResource.getFile().getAbsolutePath();
            String oldModificationFilePath = oldTsfilePath + ".mods";
            try {
                Files.delete(FSFactoryProducer.getFSFactory().getFile(oldTsfilePath).toPath());
                Files.delete(FSFactoryProducer.getFSFactory().getFile(oldTsfilePath + ".resource").toPath());
                File modificationFile = FSFactoryProducer.getFSFactory().getFile(oldModificationFilePath);
                for (TsFileResource upgradedResource : upgradedResources) {
                    File upgradedFile = upgradedResource.getFile();
                    long partition = upgradedResource.getTimePartition();
                    String storageGroupPath = upgradedFile.getParentFile().getParentFile().getParent();
                    File partitionDir = FSFactoryProducer.getFSFactory().getFile(storageGroupPath, partition + "");
                    if (!partitionDir.exists()) {
                        partitionDir.mkdir();
                    }
                    FSFactoryProducer.getFSFactory().moveFile(upgradedFile, FSFactoryProducer.getFSFactory().getFile(partitionDir, upgradedFile.getName()));
                    upgradedResource.setFile(FSFactoryProducer.getFSFactory().getFile(partitionDir, upgradedFile.getName()));
                    if (modificationFile.exists()) {
                        Files.copy(modificationFile.toPath(), FSFactoryProducer.getFSFactory().getFile(partitionDir, upgradedFile.getName() + ".mods").toPath(), new CopyOption[0]);
                    }
                    upgradedResource.serialize();
                    if (!upgradedFile.getParentFile().isDirectory() || upgradedFile.getParentFile().listFiles().length != 0) continue;
                    Files.delete(upgradedFile.getParentFile().toPath());
                }
                if (modificationFile.exists()) {
                    Files.delete(modificationFile.toPath());
                }
                if (this.upgradeResource.getFile().getParentFile().isDirectory() && this.upgradeResource.getFile().getParentFile().listFiles().length == 0) {
                    Files.delete(this.upgradeResource.getFile().getParentFile().toPath());
                }
                this.upgradeResource.setUpgradedResources(upgradedResources);
                UpgradeLog.writeUpgradeLogFile(oldTsfilePath + COMMA_SEPERATOR + (Object)((Object)UpgradeCheckStatus.UPGRADE_SUCCESS));
                this.upgradeResource.getUpgradeTsFileResourceCallBack().call(this.upgradeResource);
            }
            finally {
                this.upgradeResource.getWriteQueryLock().writeLock().unlock();
            }
            UpgradeSevice.setCntUpgradeFileNum(UpgradeSevice.getCntUpgradeFileNum() - 1);
            logger.info("Upgrade completes, file path:{} , the remaining upgraded file num: {}", (Object)oldTsfilePath, (Object)UpgradeSevice.getCntUpgradeFileNum());
        }
        catch (Exception e) {
            logger.error("meet error when upgrade file:{}", (Object)this.upgradeResource.getFile().getAbsolutePath(), (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<TsFileResource> generateUpgradedFiles() throws WriteProcessException {
        this.upgradeResource.getWriteQueryLock().readLock().lock();
        String oldTsfilePath = this.upgradeResource.getFile().getAbsolutePath();
        ArrayList<TsFileResource> upgradedResources = new ArrayList<TsFileResource>();
        UpgradeLog.writeUpgradeLogFile(oldTsfilePath + COMMA_SEPERATOR + (Object)((Object)UpgradeCheckStatus.BEGIN_UPGRADE_FILE));
        try {
            TsFileOnlineUpgradeTool.upgradeOneTsfile(oldTsfilePath, upgradedResources);
            UpgradeLog.writeUpgradeLogFile(oldTsfilePath + COMMA_SEPERATOR + (Object)((Object)UpgradeCheckStatus.AFTER_UPGRADE_FILE));
        }
        catch (IOException e) {
            logger.error("generate upgrade file failed, the file to be upgraded:{}", (Object)oldTsfilePath, (Object)e);
        }
        finally {
            this.upgradeResource.getWriteQueryLock().readLock().unlock();
        }
        return upgradedResources;
    }
}

