/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.version;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.db.engine.fileSystem.SystemFileFactory;
import org.apache.iotdb.db.engine.version.VersionController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleFileVersionController
implements VersionController {
    private static final Logger logger = LoggerFactory.getLogger(SimpleFileVersionController.class);
    public static final String FILE_PREFIX = "Version-";
    public static final String UPGRADE_DIR = "upgrade";
    private static long saveInterval = 100L;
    private long timePartitionId;
    private long prevVersion;
    private long currVersion;
    private String directoryPath;

    public SimpleFileVersionController(String directoryPath, long timePartitionId) throws IOException {
        this.directoryPath = directoryPath + File.separator + timePartitionId;
        this.timePartitionId = timePartitionId;
        this.restore();
    }

    public SimpleFileVersionController(String directoryPath) throws IOException {
        this.directoryPath = directoryPath + File.separator + UPGRADE_DIR;
        this.restore();
    }

    public static long getSaveInterval() {
        return saveInterval;
    }

    public static void setSaveInterval(long saveInterval) {
        SimpleFileVersionController.saveInterval = saveInterval;
    }

    public long getTimePartitionId() {
        return this.timePartitionId;
    }

    public void setTimePartitionId(long timePartitionId) {
        this.timePartitionId = timePartitionId;
    }

    @Override
    public synchronized long nextVersion() {
        ++this.currVersion;
        try {
            this.checkPersist();
        }
        catch (IOException e) {
            logger.error("Error occurred when getting next version.", (Throwable)e);
        }
        return this.currVersion;
    }

    @Override
    public long currVersion() {
        return this.currVersion;
    }

    private void checkPersist() throws IOException {
        if (this.currVersion - this.prevVersion >= saveInterval) {
            this.persist();
        }
    }

    private void persist() throws IOException {
        File oldFile = SystemFileFactory.INSTANCE.getFile(this.directoryPath, FILE_PREFIX + this.prevVersion);
        File newFile = SystemFileFactory.INSTANCE.getFile(this.directoryPath, FILE_PREFIX + this.currVersion);
        FileUtils.moveFile((File)oldFile, (File)newFile);
        logger.info("Version file updated, previous: {}, current: {}", (Object)oldFile.getAbsolutePath(), (Object)newFile.getAbsolutePath());
        this.prevVersion = this.currVersion;
    }

    private void restore() throws IOException {
        File[] versionFiles;
        File directory = SystemFileFactory.INSTANCE.getFile(this.directoryPath);
        if (!directory.exists()) {
            directory.mkdirs();
        }
        if ((versionFiles = directory.listFiles((dir, name) -> name.startsWith(FILE_PREFIX))) != null && versionFiles.length > 0) {
            int i;
            long maxVersion = 0L;
            int maxVersionIndex = 0;
            for (i = 0; i < versionFiles.length; ++i) {
                long fileVersion = Long.parseLong(versionFiles[i].getName().split("-")[1]);
                if (fileVersion <= maxVersion) continue;
                maxVersion = fileVersion;
                maxVersionIndex = i;
            }
            this.prevVersion = maxVersion;
            for (i = 0; i < versionFiles.length; ++i) {
                if (i == maxVersionIndex) continue;
                versionFiles[i].delete();
            }
        } else {
            File versionFile = SystemFileFactory.INSTANCE.getFile(directory, "Version-0");
            this.prevVersion = 0L;
            new FileOutputStream(versionFile).close();
        }
        this.currVersion = this.prevVersion + saveInterval;
        this.persist();
    }
}

