/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;
import org.apache.iotdb.db.engine.fileSystem.SystemFileFactory;
import org.apache.iotdb.db.qp.physical.sys.CreateTimeSeriesPlan;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MLogWriter {
    private static final Logger logger = LoggerFactory.getLogger(MLogWriter.class);
    private BufferedWriter writer;

    public MLogWriter(String schemaDir, String logFileName) throws IOException {
        File metadataDir = SystemFileFactory.INSTANCE.getFile(schemaDir);
        if (!metadataDir.exists()) {
            if (metadataDir.mkdirs()) {
                logger.info("create schema folder {}.", (Object)metadataDir);
            } else {
                logger.info("create schema folder {} failed.", (Object)metadataDir);
            }
        }
        File logFile = SystemFileFactory.INSTANCE.getFile(schemaDir + File.separator + logFileName);
        FileWriter fileWriter = new FileWriter(logFile, true);
        this.writer = new BufferedWriter(fileWriter);
    }

    public void close() throws IOException {
        this.writer.close();
    }

    public void createTimeseries(CreateTimeSeriesPlan plan, long offset) throws IOException {
        this.writer.write(String.format("%s,%s,%s,%s,%s", "0", plan.getPath().getFullPath(), plan.getDataType().serialize(), plan.getEncoding().serialize(), plan.getCompressor().serialize()));
        this.writer.write(",");
        if (plan.getProps() != null) {
            boolean first = true;
            for (Map.Entry<String, String> entry : plan.getProps().entrySet()) {
                if (first) {
                    this.writer.write(String.format("%s=%s", entry.getKey(), entry.getValue()));
                    first = false;
                    continue;
                }
                this.writer.write(String.format("&%s=%s", entry.getKey(), entry.getValue()));
            }
        }
        this.writer.write(",");
        if (plan.getAlias() != null) {
            this.writer.write(plan.getAlias());
        }
        this.writer.write(",");
        if (offset >= 0L) {
            this.writer.write(String.valueOf(offset));
        }
        this.writer.newLine();
        this.writer.flush();
    }

    public void deleteTimeseries(String path) throws IOException {
        this.writer.write("1," + path);
        this.writer.newLine();
        this.writer.flush();
    }

    public void setStorageGroup(String storageGroup) throws IOException {
        this.writer.write("2," + storageGroup);
        this.writer.newLine();
        this.writer.flush();
    }

    public void deleteStorageGroup(String storageGroup) throws IOException {
        this.writer.write("11," + storageGroup);
        this.writer.newLine();
        this.writer.flush();
    }

    public void setTTL(String storageGroup, long ttl) throws IOException {
        this.writer.write(String.format("%s,%s,%s", "10", storageGroup, ttl));
        this.writer.newLine();
        this.writer.flush();
    }

    public void changeOffset(String path, long offset) throws IOException {
        this.writer.write(String.format("%s,%s,%s", "12", path, offset));
        this.writer.newLine();
        this.writer.flush();
    }

    public void changeAlias(String path, String alias) throws IOException {
        this.writer.write(String.format("%s,%s,%s", "13", path, alias));
        this.writer.newLine();
        this.writer.flush();
    }

    public static void upgradeMLog(String schemaDir, String logFileName) throws IOException {
        File logFile = SystemFileFactory.INSTANCE.getFile(schemaDir + File.separator + logFileName);
        File tmpLogFile = SystemFileFactory.INSTANCE.getFile(logFile.getAbsolutePath() + ".tmp");
        if (!logFile.exists() && !tmpLogFile.exists()) {
            return;
        }
        if (!logFile.exists() && tmpLogFile.exists()) {
            FSFactoryProducer.getFSFactory().moveFile(tmpLogFile, logFile);
            return;
        }
        if (tmpLogFile.exists() && !tmpLogFile.delete()) {
            throw new IOException("Deleting " + tmpLogFile + "failed.");
        }
        try (BufferedReader reader = new BufferedReader(new FileReader(logFile));
             BufferedWriter writer = new BufferedWriter(new FileWriter(tmpLogFile, true));){
            String line;
            while ((line = reader.readLine()) != null) {
                StringBuilder buf = new StringBuilder();
                buf.append(line);
                if (line.startsWith("0")) {
                    buf.append(",,,");
                }
                writer.write(buf.toString());
                writer.newLine();
                writer.flush();
            }
        }
    }
}

