/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mnode;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.iotdb.db.exception.metadata.DeleteFailedException;
import org.apache.iotdb.db.metadata.mnode.LeafMNode;
import org.apache.iotdb.db.metadata.mnode.MNode;

public class InternalMNode
extends MNode {
    private static final long serialVersionUID = 7999036474525817732L;
    private Map<String, MNode> children;
    private Map<String, MNode> aliasChildren;
    protected ReadWriteLock lock = new ReentrantReadWriteLock();

    public InternalMNode(MNode parent, String name) {
        super(parent, name);
        this.children = new LinkedHashMap<String, MNode>();
        this.aliasChildren = new LinkedHashMap<String, MNode>();
    }

    @Override
    public boolean hasChild(String name) {
        return this.children.containsKey(name) || this.aliasChildren.containsKey(name);
    }

    @Override
    public void addChild(String name, MNode child) {
        this.children.put(name, child);
    }

    @Override
    public void deleteChild(String name) throws DeleteFailedException {
        if (this.children.containsKey(name)) {
            Lock writeLock = this.children.get(name) instanceof LeafMNode ? this.lock.writeLock() : ((InternalMNode)this.children.get((Object)name)).lock.writeLock();
            if (writeLock.tryLock()) {
                this.children.remove(name);
                writeLock.unlock();
            } else {
                throw new DeleteFailedException(this.getFullPath() + '.' + name);
            }
        }
    }

    @Override
    public void deleteAliasChild(String alias) throws DeleteFailedException {
        if (!this.lock.writeLock().tryLock()) {
            throw new DeleteFailedException(this.getFullPath() + '.' + alias);
        }
        this.aliasChildren.remove(alias);
        this.lock.writeLock().unlock();
    }

    @Override
    public MNode getChild(String name) {
        return this.children.containsKey(name) ? this.children.get(name) : this.aliasChildren.get(name);
    }

    @Override
    public int getLeafCount() {
        int leafCount = 0;
        for (MNode child : this.children.values()) {
            leafCount += child.getLeafCount();
        }
        return leafCount;
    }

    @Override
    public void addAlias(String alias, MNode child) {
        this.aliasChildren.put(alias, child);
    }

    @Override
    public Map<String, MNode> getChildren() {
        return this.children;
    }

    public void readLock() {
        InternalMNode node = this;
        while (node != null) {
            node.lock.readLock().lock();
            node = (InternalMNode)node.parent;
        }
    }

    public void readUnlock() {
        InternalMNode node = this;
        while (node != null) {
            node.lock.readLock().unlock();
            node = (InternalMNode)node.parent;
        }
    }
}

