/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.monitor.collector;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MemTableWriteTimeCost {
    private Map<String, Map<MemTableWriteTimeCostType, long[]>> timeCostMaps = new ConcurrentHashMap<String, Map<MemTableWriteTimeCostType, long[]>>();

    public Map<String, Map<MemTableWriteTimeCostType, long[]>> getTimeCostMaps() {
        return this.timeCostMaps;
    }

    public static MemTableWriteTimeCost getInstance() {
        return MemTableWriteTimeCostHolder.INSTANCE;
    }

    private MemTableWriteTimeCost() {
    }

    public void init() {
        if (this.timeCostMaps.get(Thread.currentThread().getName()) == null) {
            ConcurrentHashMap<MemTableWriteTimeCostType, long[]> map = new ConcurrentHashMap<MemTableWriteTimeCostType, long[]>();
            for (MemTableWriteTimeCostType type : MemTableWriteTimeCostType.values()) {
                map.put(type, new long[2]);
            }
            this.timeCostMaps.put(Thread.currentThread().getName(), map);
        } else {
            this.timeCostMaps.get(Thread.currentThread().getName()).clear();
            for (MemTableWriteTimeCostType type : MemTableWriteTimeCostType.values()) {
                this.timeCostMaps.get(Thread.currentThread().getName()).put(type, new long[2]);
            }
        }
    }

    public void measure(MemTableWriteTimeCostType type, long start) {
        long elapse = System.currentTimeMillis() - start;
        long[] a = new long[2];
        if (!this.timeCostMaps.containsKey(Thread.currentThread().getName())) {
            return;
        }
        a[0] = this.timeCostMaps.get(Thread.currentThread().getName()).get((Object)type)[0] + 1L;
        a[1] = this.timeCostMaps.get(Thread.currentThread().getName()).get((Object)type)[1] + elapse;
        this.timeCostMaps.get(Thread.currentThread().getName()).put(type, a);
    }

    public static enum MemTableWriteTimeCostType {
        EXPAND_ARRAY_1,
        EXPAND_ARRAY_2,
        CAPACITY_1,
        CAPACITY_2,
        WRITE_1,
        WRITE_2,
        PUT_TIMESTAMP_1,
        PUT_TIMESTAMP_2;

    }

    private static class MemTableWriteTimeCostHolder {
        private static final MemTableWriteTimeCost INSTANCE = new MemTableWriteTimeCost();

        private MemTableWriteTimeCostHolder() {
        }
    }
}

