/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.crud.DeletePlan;
import org.apache.iotdb.db.qp.physical.crud.InsertPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertTabletPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.SetStorageGroupPlan;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public abstract class PhysicalPlan {
    private static final String SERIALIZATION_UNIMPLEMENTED = "serialization unimplemented";
    private boolean isQuery;
    private Operator.OperatorType operatorType;
    private static final int NULL_VALUE_LEN = -1;
    protected boolean canbeSplit = true;

    public boolean canbeSplit() {
        return this.canbeSplit;
    }

    protected PhysicalPlan(boolean isQuery) {
        this.isQuery = isQuery;
    }

    protected PhysicalPlan(boolean isQuery, Operator.OperatorType operatorType) {
        this.isQuery = isQuery;
        this.operatorType = operatorType;
    }

    public String printQueryPlan() {
        return "abstract plan";
    }

    public abstract List<Path> getPaths();

    public boolean isQuery() {
        return this.isQuery;
    }

    public Operator.OperatorType getOperatorType() {
        return this.operatorType;
    }

    public void setOperatorType(Operator.OperatorType operatorType) {
        this.operatorType = operatorType;
    }

    public List<String> getAggregations() {
        return Collections.emptyList();
    }

    public void setQuery(boolean query) {
        this.isQuery = query;
    }

    public void serializeTo(DataOutputStream stream) throws IOException {
        throw new UnsupportedOperationException(SERIALIZATION_UNIMPLEMENTED);
    }

    public void serializeTo(ByteBuffer buffer) {
        throw new UnsupportedOperationException(SERIALIZATION_UNIMPLEMENTED);
    }

    public void deserializeFrom(ByteBuffer buffer) {
        throw new UnsupportedOperationException(SERIALIZATION_UNIMPLEMENTED);
    }

    protected void putString(ByteBuffer buffer, String value) {
        if (value == null) {
            buffer.putInt(-1);
        } else {
            ReadWriteIOUtils.write((String)value, (ByteBuffer)buffer);
        }
    }

    protected void putString(DataOutputStream stream, String value) throws IOException {
        if (value == null) {
            stream.writeInt(-1);
        } else {
            ReadWriteIOUtils.write((String)value, (OutputStream)stream);
        }
    }

    protected String readString(ByteBuffer buffer) {
        int valueLen = buffer.getInt();
        if (valueLen == -1) {
            return null;
        }
        return ReadWriteIOUtils.readStringWithLength((ByteBuffer)buffer, (int)valueLen);
    }

    public static enum PhysicalPlanType {
        INSERT,
        DELETE,
        BATCHINSERT,
        SET_STORAGE_GROUP,
        CREATE_TIMESERIES;

    }

    public static class Factory {
        private Factory() {
        }

        public static PhysicalPlan create(ByteBuffer buffer) throws IOException {
            PhysicalPlan plan;
            byte typeNum = buffer.get();
            if (typeNum >= PhysicalPlanType.values().length) {
                throw new IOException("unrecognized log type " + typeNum);
            }
            PhysicalPlanType type = PhysicalPlanType.values()[typeNum];
            switch (type) {
                case INSERT: {
                    plan = new InsertPlan();
                    plan.deserializeFrom(buffer);
                    break;
                }
                case DELETE: {
                    plan = new DeletePlan();
                    plan.deserializeFrom(buffer);
                    break;
                }
                case BATCHINSERT: {
                    plan = new InsertTabletPlan();
                    plan.deserializeFrom(buffer);
                    break;
                }
                case SET_STORAGE_GROUP: {
                    plan = new SetStorageGroupPlan();
                    plan.deserializeFrom(buffer);
                    break;
                }
                case CREATE_TIMESERIES: {
                    plan = new CreateTimeSeriesPlan();
                    plan.deserializeFrom(buffer);
                    break;
                }
                default: {
                    throw new IOException("unrecognized log type " + (Object)((Object)type));
                }
            }
            return plan;
        }
    }
}

