/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical.sys;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class CreateTimeSeriesPlan
extends PhysicalPlan {
    private Path path;
    private TSDataType dataType;
    private TSEncoding encoding;
    private CompressionType compressor;
    private String alias;
    private Map<String, String> props;
    private Map<String, String> tags;
    private Map<String, String> attributes;

    public CreateTimeSeriesPlan() {
        super(false, Operator.OperatorType.CREATE_TIMESERIES);
        this.canbeSplit = false;
    }

    public CreateTimeSeriesPlan(Path path, TSDataType dataType, TSEncoding encoding, CompressionType compressor, Map<String, String> props, Map<String, String> tags, Map<String, String> attributes, String alias) {
        super(false, Operator.OperatorType.CREATE_TIMESERIES);
        this.path = path;
        this.dataType = dataType;
        this.encoding = encoding;
        this.compressor = compressor;
        this.props = props;
        this.tags = tags;
        this.attributes = attributes;
        this.alias = alias;
        this.canbeSplit = false;
    }

    public Path getPath() {
        return this.path;
    }

    public void setPath(Path path) {
        this.path = path;
    }

    public TSDataType getDataType() {
        return this.dataType;
    }

    public void setDataType(TSDataType dataType) {
        this.dataType = dataType;
    }

    public CompressionType getCompressor() {
        return this.compressor;
    }

    public void setCompressor(CompressionType compressor) {
        this.compressor = compressor;
    }

    public TSEncoding getEncoding() {
        return this.encoding;
    }

    public void setEncoding(TSEncoding encoding) {
        this.encoding = encoding;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public Map<String, String> getProps() {
        return this.props;
    }

    public void setProps(Map<String, String> props) {
        this.props = props;
    }

    public String toString() {
        return String.format("seriesPath: %s, resultDataType: %s, encoding: %s, compression: %s", this.path, this.dataType, this.encoding, this.compressor);
    }

    @Override
    public List<Path> getPaths() {
        return Collections.singletonList(this.path);
    }

    @Override
    public void serializeTo(DataOutputStream stream) throws IOException {
        stream.writeByte((byte)PhysicalPlan.PhysicalPlanType.CREATE_TIMESERIES.ordinal());
        byte[] bytes = this.path.getFullPath().getBytes();
        stream.writeInt(bytes.length);
        stream.write(bytes);
        stream.write(this.dataType.ordinal());
        stream.write(this.encoding.ordinal());
        stream.write(this.compressor.ordinal());
        if (this.alias != null) {
            stream.write(1);
            ReadWriteIOUtils.write((String)this.alias, (OutputStream)stream);
        } else {
            stream.write(0);
        }
        if (this.props != null && !this.props.isEmpty()) {
            stream.write(1);
            ReadWriteIOUtils.write(this.props, (DataOutputStream)stream);
        } else {
            stream.write(0);
        }
        if (this.tags != null && !this.tags.isEmpty()) {
            stream.write(1);
            ReadWriteIOUtils.write(this.tags, (DataOutputStream)stream);
        } else {
            stream.write(0);
        }
        if (this.attributes != null && !this.attributes.isEmpty()) {
            stream.write(1);
            ReadWriteIOUtils.write(this.attributes, (DataOutputStream)stream);
        } else {
            stream.write(0);
        }
    }

    @Override
    public void deserializeFrom(ByteBuffer buffer) {
        int length = buffer.getInt();
        byte[] bytes = new byte[length];
        buffer.get(bytes);
        this.path = new Path(new String(bytes));
        this.dataType = TSDataType.values()[buffer.get()];
        this.encoding = TSEncoding.values()[buffer.get()];
        this.compressor = CompressionType.values()[buffer.get()];
        if (buffer.get() == 1) {
            this.alias = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        }
        if (buffer.get() == 1) {
            this.props = ReadWriteIOUtils.readMap((ByteBuffer)buffer);
        }
        if (buffer.get() == 1) {
            this.tags = ReadWriteIOUtils.readMap((ByteBuffer)buffer);
        }
        if (buffer.get() == 1) {
            this.attributes = ReadWriteIOUtils.readMap((ByteBuffer)buffer);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateTimeSeriesPlan that = (CreateTimeSeriesPlan)o;
        return Objects.equals(this.path, that.path) && this.dataType == that.dataType && this.encoding == that.encoding && this.compressor == that.compressor;
    }

    public int hashCode() {
        return Objects.hash(this.path, this.dataType, this.encoding, this.compressor);
    }
}

