/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.strategy;

import java.io.File;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.runtime.SQLParserException;
import org.apache.iotdb.db.qp.constant.DatetimeUtils;
import org.apache.iotdb.db.qp.logical.RootOperator;
import org.apache.iotdb.db.qp.logical.crud.BasicFunctionOperator;
import org.apache.iotdb.db.qp.logical.crud.DeleteDataOperator;
import org.apache.iotdb.db.qp.logical.crud.FilterOperator;
import org.apache.iotdb.db.qp.logical.crud.FromOperator;
import org.apache.iotdb.db.qp.logical.crud.InOperator;
import org.apache.iotdb.db.qp.logical.crud.InsertOperator;
import org.apache.iotdb.db.qp.logical.crud.QueryOperator;
import org.apache.iotdb.db.qp.logical.crud.SelectOperator;
import org.apache.iotdb.db.qp.logical.crud.UpdateOperator;
import org.apache.iotdb.db.qp.logical.sys.AlterTimeSeriesOperator;
import org.apache.iotdb.db.qp.logical.sys.AuthorOperator;
import org.apache.iotdb.db.qp.logical.sys.ClearCacheOperator;
import org.apache.iotdb.db.qp.logical.sys.CountOperator;
import org.apache.iotdb.db.qp.logical.sys.CreateTimeSeriesOperator;
import org.apache.iotdb.db.qp.logical.sys.DataAuthOperator;
import org.apache.iotdb.db.qp.logical.sys.DeleteStorageGroupOperator;
import org.apache.iotdb.db.qp.logical.sys.DeleteTimeSeriesOperator;
import org.apache.iotdb.db.qp.logical.sys.FlushOperator;
import org.apache.iotdb.db.qp.logical.sys.LoadConfigurationOperator;
import org.apache.iotdb.db.qp.logical.sys.LoadDataOperator;
import org.apache.iotdb.db.qp.logical.sys.LoadFilesOperator;
import org.apache.iotdb.db.qp.logical.sys.MergeOperator;
import org.apache.iotdb.db.qp.logical.sys.MoveFileOperator;
import org.apache.iotdb.db.qp.logical.sys.RemoveFileOperator;
import org.apache.iotdb.db.qp.logical.sys.SetStorageGroupOperator;
import org.apache.iotdb.db.qp.logical.sys.SetTTLOperator;
import org.apache.iotdb.db.qp.logical.sys.ShowChildPathsOperator;
import org.apache.iotdb.db.qp.logical.sys.ShowDevicesOperator;
import org.apache.iotdb.db.qp.logical.sys.ShowOperator;
import org.apache.iotdb.db.qp.logical.sys.ShowTTLOperator;
import org.apache.iotdb.db.qp.logical.sys.ShowTimeSeriesOperator;
import org.apache.iotdb.db.qp.strategy.SqlBaseBaseListener;
import org.apache.iotdb.db.qp.strategy.SqlBaseParser;
import org.apache.iotdb.db.query.executor.fill.IFill;
import org.apache.iotdb.db.query.executor.fill.LinearFill;
import org.apache.iotdb.db.query.executor.fill.PreviousFill;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.utils.StringContainer;

public class LogicalGenerator
extends SqlBaseBaseListener {
    private RootOperator initializedOperator = null;
    private ZoneId zoneId;
    private int operatorType;
    private CreateTimeSeriesOperator createTimeSeriesOperator;
    private AlterTimeSeriesOperator alterTimeSeriesOperator;
    private InsertOperator insertOp;
    private SelectOperator selectOp;
    private UpdateOperator updateOp;
    private QueryOperator queryOp;
    private DeleteDataOperator deleteDataOp;

    LogicalGenerator(ZoneId zoneId) {
        this.zoneId = zoneId;
    }

    RootOperator getLogicalPlan() {
        return this.initializedOperator;
    }

    @Override
    public void enterCountTimeseries(SqlBaseParser.CountTimeseriesContext ctx) {
        super.enterCountTimeseries(ctx);
        SqlBaseParser.PrefixPathContext pathContext = ctx.prefixPath();
        Path path = pathContext != null ? this.parsePrefixPath(pathContext) : new Path("root");
        this.initializedOperator = ctx.INT() != null ? new CountOperator(78, path, Integer.parseInt(ctx.INT().getText())) : new CountOperator(77, path);
    }

    @Override
    public void enterFlush(SqlBaseParser.FlushContext ctx) {
        super.enterFlush(ctx);
        FlushOperator flushOperator = new FlushOperator(81);
        if (ctx.booleanClause() != null) {
            flushOperator.setSeq(Boolean.parseBoolean(ctx.booleanClause().getText()));
        }
        if (ctx.prefixPath(0) != null) {
            ArrayList<Path> storageGroups = new ArrayList<Path>();
            for (SqlBaseParser.PrefixPathContext prefixPathContext : ctx.prefixPath()) {
                storageGroups.add(this.parsePrefixPath(prefixPathContext));
            }
            flushOperator.setStorageGroupList(storageGroups);
        }
        this.initializedOperator = flushOperator;
    }

    @Override
    public void enterMerge(SqlBaseParser.MergeContext ctx) {
        super.enterMerge(ctx);
        this.initializedOperator = new MergeOperator(82);
    }

    @Override
    public void enterFullMerge(SqlBaseParser.FullMergeContext ctx) {
        super.enterFullMerge(ctx);
        this.initializedOperator = new MergeOperator(83);
    }

    @Override
    public void enterClearcache(SqlBaseParser.ClearcacheContext ctx) {
        super.enterClearcache(ctx);
        this.initializedOperator = new ClearCacheOperator(84);
    }

    @Override
    public void enterCountNodes(SqlBaseParser.CountNodesContext ctx) {
        super.enterCountNodes(ctx);
        this.initializedOperator = new CountOperator(79, this.parsePrefixPath(ctx.prefixPath()), Integer.parseInt(ctx.INT().getText()));
    }

    @Override
    public void enterShowDevices(SqlBaseParser.ShowDevicesContext ctx) {
        super.enterShowDevices(ctx);
        this.initializedOperator = ctx.prefixPath() != null ? new ShowDevicesOperator(76, this.parsePrefixPath(ctx.prefixPath())) : new ShowDevicesOperator(76, new Path("root"));
    }

    @Override
    public void enterShowChildPaths(SqlBaseParser.ShowChildPathsContext ctx) {
        super.enterShowChildPaths(ctx);
        this.initializedOperator = ctx.prefixPath() != null ? new ShowChildPathsOperator(75, this.parsePrefixPath(ctx.prefixPath())) : new ShowChildPathsOperator(75, new Path("root"));
    }

    @Override
    public void enterShowStorageGroup(SqlBaseParser.ShowStorageGroupContext ctx) {
        super.enterShowStorageGroup(ctx);
        this.initializedOperator = new ShowOperator(74);
    }

    @Override
    public void enterLoadFiles(SqlBaseParser.LoadFilesContext ctx) {
        super.enterLoadFiles(ctx);
        this.initializedOperator = ctx.autoCreateSchema() != null ? (ctx.autoCreateSchema().INT() != null ? new LoadFilesOperator(new File(this.removeStringQuote(ctx.STRING_LITERAL().getText())), Boolean.parseBoolean(ctx.autoCreateSchema().booleanClause().getText()), Integer.parseInt(ctx.autoCreateSchema().INT().getText())) : new LoadFilesOperator(new File(this.removeStringQuote(ctx.STRING_LITERAL().getText())), Boolean.parseBoolean(ctx.autoCreateSchema().booleanClause().getText()), IoTDBDescriptor.getInstance().getConfig().getDefaultStorageGroupLevel())) : new LoadFilesOperator(new File(this.removeStringQuote(ctx.STRING_LITERAL().getText())), true, IoTDBDescriptor.getInstance().getConfig().getDefaultStorageGroupLevel());
    }

    @Override
    public void enterMoveFile(SqlBaseParser.MoveFileContext ctx) {
        super.enterMoveFile(ctx);
        this.initializedOperator = new MoveFileOperator(new File(this.removeStringQuote(ctx.STRING_LITERAL(0).getText())), new File(this.removeStringQuote(ctx.STRING_LITERAL(1).getText())));
    }

    @Override
    public void enterRemoveFile(SqlBaseParser.RemoveFileContext ctx) {
        super.enterRemoveFile(ctx);
        this.initializedOperator = new RemoveFileOperator(new File(this.removeStringQuote(ctx.STRING_LITERAL().getText())));
    }

    @Override
    public void enterLoadConfigurationStatement(SqlBaseParser.LoadConfigurationStatementContext ctx) {
        super.enterLoadConfigurationStatement(ctx);
        this.initializedOperator = new LoadConfigurationOperator();
    }

    @Override
    public void enterShowVersion(SqlBaseParser.ShowVersionContext ctx) {
        super.enterShowVersion(ctx);
        this.initializedOperator = new ShowOperator(72);
    }

    @Override
    public void enterShowDynamicParameter(SqlBaseParser.ShowDynamicParameterContext ctx) {
        super.enterShowDynamicParameter(ctx);
        this.initializedOperator = new ShowOperator(68);
    }

    @Override
    public void enterShowFlushTaskInfo(SqlBaseParser.ShowFlushTaskInfoContext ctx) {
        super.enterShowFlushTaskInfo(ctx);
        this.initializedOperator = new ShowOperator(67);
    }

    @Override
    public void enterShowTimeseries(SqlBaseParser.ShowTimeseriesContext ctx) {
        super.enterShowTimeseries(ctx);
        this.initializedOperator = ctx.prefixPath() != null ? new ShowTimeSeriesOperator(73, this.parsePrefixPath(ctx.prefixPath())) : new ShowTimeSeriesOperator(73, new Path("root"));
    }

    @Override
    public void enterCreateTimeseries(SqlBaseParser.CreateTimeseriesContext ctx) {
        super.enterCreateTimeseries(ctx);
        this.createTimeSeriesOperator = new CreateTimeSeriesOperator(51);
        this.operatorType = 51;
        this.createTimeSeriesOperator.setPath(this.parseFullPath(ctx.fullPath()));
    }

    @Override
    public void enterAlterTimeseries(SqlBaseParser.AlterTimeseriesContext ctx) {
        super.enterAlterTimeseries(ctx);
        this.alterTimeSeriesOperator = new AlterTimeSeriesOperator(80);
        this.operatorType = 80;
        this.alterTimeSeriesOperator.setPath(this.parseFullPath(ctx.fullPath()));
    }

    @Override
    public void enterAlterClause(SqlBaseParser.AlterClauseContext ctx) {
        super.enterAlterClause(ctx);
        HashMap<String, String> alterMap = new HashMap<String, String>();
        if (ctx.RENAME() != null) {
            this.alterTimeSeriesOperator.setAlterType(AlterTimeSeriesOperator.AlterType.RENAME);
            alterMap.put(ctx.beforeName.getText(), ctx.currentName.getText());
        } else if (ctx.SET() != null) {
            this.alterTimeSeriesOperator.setAlterType(AlterTimeSeriesOperator.AlterType.SET);
            this.setMap(ctx, alterMap);
        } else if (ctx.DROP() != null) {
            this.alterTimeSeriesOperator.setAlterType(AlterTimeSeriesOperator.AlterType.DROP);
            for (TerminalNode dropId : ctx.ID()) {
                alterMap.put(dropId.getText(), null);
            }
        } else if (ctx.TAGS() != null) {
            this.alterTimeSeriesOperator.setAlterType(AlterTimeSeriesOperator.AlterType.ADD_TAGS);
            this.setMap(ctx, alterMap);
        } else if (ctx.ATTRIBUTES() != null) {
            this.alterTimeSeriesOperator.setAlterType(AlterTimeSeriesOperator.AlterType.ADD_ATTRIBUTES);
            this.setMap(ctx, alterMap);
        } else {
            this.alterTimeSeriesOperator.setAlterType(AlterTimeSeriesOperator.AlterType.UPSERT);
        }
        this.alterTimeSeriesOperator.setAlterMap(alterMap);
        this.initializedOperator = this.alterTimeSeriesOperator;
    }

    private void setMap(SqlBaseParser.AlterClauseContext ctx, Map<String, String> alterMap) {
        List<SqlBaseParser.PropertyContext> tagsList = ctx.property();
        if (ctx.property(0) != null) {
            for (SqlBaseParser.PropertyContext property : tagsList) {
                String value = property.propertyValue().STRING_LITERAL() != null ? this.removeStringQuote(property.propertyValue().getText()) : property.propertyValue().getText();
                alterMap.put(property.ID().getText(), value);
            }
        }
    }

    @Override
    public void enterAlias(SqlBaseParser.AliasContext ctx) {
        super.enterAlias(ctx);
        this.createTimeSeriesOperator.setAlias(ctx.ID().getText());
    }

    @Override
    public void enterCreateUser(SqlBaseParser.CreateUserContext ctx) {
        super.enterCreateUser(ctx);
        AuthorOperator authorOperator = new AuthorOperator(41, AuthorOperator.AuthorType.CREATE_USER);
        authorOperator.setUserName(ctx.ID().getText());
        authorOperator.setPassWord(this.removeStringQuote(ctx.password.getText()));
        this.initializedOperator = authorOperator;
        this.operatorType = 41;
    }

    @Override
    public void enterCreateRole(SqlBaseParser.CreateRoleContext ctx) {
        super.enterCreateRole(ctx);
        AuthorOperator authorOperator = new AuthorOperator(41, AuthorOperator.AuthorType.CREATE_ROLE);
        authorOperator.setRoleName(ctx.ID().getText());
        this.initializedOperator = authorOperator;
        this.operatorType = 41;
    }

    @Override
    public void enterAlterUser(SqlBaseParser.AlterUserContext ctx) {
        super.enterAlterUser(ctx);
        AuthorOperator authorOperator = new AuthorOperator(46, AuthorOperator.AuthorType.UPDATE_USER);
        if (ctx.ID() != null) {
            authorOperator.setUserName(ctx.ID().getText());
        } else {
            authorOperator.setUserName(ctx.ROOT().getText());
        }
        authorOperator.setNewPassword(this.removeStringQuote(ctx.password.getText()));
        this.initializedOperator = authorOperator;
        this.operatorType = 46;
    }

    @Override
    public void enterDropUser(SqlBaseParser.DropUserContext ctx) {
        super.enterDropUser(ctx);
        AuthorOperator authorOperator = new AuthorOperator(42, AuthorOperator.AuthorType.DROP_USER);
        authorOperator.setUserName(ctx.ID().getText());
        this.initializedOperator = authorOperator;
        this.operatorType = 42;
    }

    @Override
    public void enterDropRole(SqlBaseParser.DropRoleContext ctx) {
        super.enterDropRole(ctx);
        AuthorOperator authorOperator = new AuthorOperator(42, AuthorOperator.AuthorType.DROP_ROLE);
        authorOperator.setRoleName(ctx.ID().getText());
        this.initializedOperator = authorOperator;
        this.operatorType = 42;
    }

    @Override
    public void enterGrantUser(SqlBaseParser.GrantUserContext ctx) {
        super.enterGrantUser(ctx);
        AuthorOperator authorOperator = new AuthorOperator(43, AuthorOperator.AuthorType.GRANT_USER);
        authorOperator.setUserName(ctx.ID().getText());
        authorOperator.setPrivilegeList(this.parsePrivilege(ctx.privileges()));
        authorOperator.setNodeNameList(this.parsePrefixPath(ctx.prefixPath()));
        this.initializedOperator = authorOperator;
        this.operatorType = 43;
    }

    @Override
    public void enterGrantRole(SqlBaseParser.GrantRoleContext ctx) {
        super.enterGrantRole(ctx);
        AuthorOperator authorOperator = new AuthorOperator(43, AuthorOperator.AuthorType.GRANT_ROLE);
        authorOperator.setRoleName(ctx.ID().getText());
        authorOperator.setPrivilegeList(this.parsePrivilege(ctx.privileges()));
        authorOperator.setNodeNameList(this.parsePrefixPath(ctx.prefixPath()));
        this.initializedOperator = authorOperator;
        this.operatorType = 43;
    }

    @Override
    public void enterRevokeUser(SqlBaseParser.RevokeUserContext ctx) {
        super.enterRevokeUser(ctx);
        AuthorOperator authorOperator = new AuthorOperator(43, AuthorOperator.AuthorType.REVOKE_USER);
        authorOperator.setUserName(ctx.ID().getText());
        authorOperator.setPrivilegeList(this.parsePrivilege(ctx.privileges()));
        authorOperator.setNodeNameList(this.parsePrefixPath(ctx.prefixPath()));
        this.initializedOperator = authorOperator;
        this.operatorType = 43;
    }

    @Override
    public void enterRevokeRole(SqlBaseParser.RevokeRoleContext ctx) {
        super.enterRevokeRole(ctx);
        AuthorOperator authorOperator = new AuthorOperator(43, AuthorOperator.AuthorType.REVOKE_ROLE);
        authorOperator.setRoleName(ctx.ID().getText());
        authorOperator.setPrivilegeList(this.parsePrivilege(ctx.privileges()));
        authorOperator.setNodeNameList(this.parsePrefixPath(ctx.prefixPath()));
        this.initializedOperator = authorOperator;
        this.operatorType = 43;
    }

    @Override
    public void enterGrantRoleToUser(SqlBaseParser.GrantRoleToUserContext ctx) {
        super.enterGrantRoleToUser(ctx);
        AuthorOperator authorOperator = new AuthorOperator(43, AuthorOperator.AuthorType.GRANT_ROLE_TO_USER);
        authorOperator.setRoleName(ctx.roleName.getText());
        authorOperator.setUserName(ctx.userName.getText());
        this.initializedOperator = authorOperator;
        this.operatorType = 43;
    }

    @Override
    public void enterRevokeRoleFromUser(SqlBaseParser.RevokeRoleFromUserContext ctx) {
        super.enterRevokeRoleFromUser(ctx);
        AuthorOperator authorOperator = new AuthorOperator(43, AuthorOperator.AuthorType.REVOKE_ROLE_FROM_USER);
        authorOperator.setRoleName(ctx.roleName.getText());
        authorOperator.setUserName(ctx.userName.getText());
        this.initializedOperator = authorOperator;
        this.operatorType = 43;
    }

    @Override
    public void enterLoadStatement(SqlBaseParser.LoadStatementContext ctx) {
        super.enterLoadStatement(ctx);
        if (ctx.prefixPath().nodeName().size() < 3) {
            throw new SQLParserException("data load command: child count < 3\n");
        }
        String csvPath = ctx.STRING_LITERAL().getText();
        StringContainer sc = new StringContainer(".");
        List<SqlBaseParser.NodeNameContext> nodeNames = ctx.prefixPath().nodeName();
        sc.addTail(new String[]{ctx.prefixPath().ROOT().getText()});
        for (SqlBaseParser.NodeNameContext nodeName : nodeNames) {
            sc.addTail(new String[]{nodeName.getText()});
        }
        this.initializedOperator = new LoadDataOperator(45, this.removeStringQuote(csvPath), sc.toString());
        this.operatorType = 45;
    }

    @Override
    public void enterGrantWatermarkEmbedding(SqlBaseParser.GrantWatermarkEmbeddingContext ctx) {
        super.enterGrantWatermarkEmbedding(ctx);
        List<SqlBaseParser.RootOrIdContext> rootOrIdList = ctx.rootOrId();
        ArrayList<String> users = new ArrayList<String>();
        for (SqlBaseParser.RootOrIdContext rootOrId : rootOrIdList) {
            users.add(rootOrId.getText());
        }
        this.initializedOperator = new DataAuthOperator(34, users);
    }

    @Override
    public void enterRevokeWatermarkEmbedding(SqlBaseParser.RevokeWatermarkEmbeddingContext ctx) {
        super.enterRevokeWatermarkEmbedding(ctx);
        List<SqlBaseParser.RootOrIdContext> rootOrIdList = ctx.rootOrId();
        ArrayList<String> users = new ArrayList<String>();
        for (SqlBaseParser.RootOrIdContext rootOrId : rootOrIdList) {
            users.add(rootOrId.getText());
        }
        this.initializedOperator = new DataAuthOperator(35, users);
        this.operatorType = 35;
    }

    @Override
    public void enterListUser(SqlBaseParser.ListUserContext ctx) {
        super.enterListUser(ctx);
        this.initializedOperator = new AuthorOperator(59, AuthorOperator.AuthorType.LIST_USER);
        this.operatorType = 59;
    }

    @Override
    public void enterListRole(SqlBaseParser.ListRoleContext ctx) {
        super.enterListRole(ctx);
        this.initializedOperator = new AuthorOperator(59, AuthorOperator.AuthorType.LIST_ROLE);
        this.operatorType = 59;
    }

    @Override
    public void enterListPrivilegesUser(SqlBaseParser.ListPrivilegesUserContext ctx) {
        super.enterListPrivilegesUser(ctx);
        AuthorOperator operator = new AuthorOperator(59, AuthorOperator.AuthorType.LIST_USER_PRIVILEGE);
        operator.setUserName(ctx.ID().getText());
        operator.setNodeNameList(this.parsePrefixPath(ctx.prefixPath()));
        this.initializedOperator = operator;
        this.operatorType = 59;
    }

    @Override
    public void enterListPrivilegesRole(SqlBaseParser.ListPrivilegesRoleContext ctx) {
        super.enterListPrivilegesRole(ctx);
        AuthorOperator operator = new AuthorOperator(59, AuthorOperator.AuthorType.LIST_ROLE_PRIVILEGE);
        operator.setRoleName(ctx.ID().getText());
        operator.setNodeNameList(this.parsePrefixPath(ctx.prefixPath()));
        this.initializedOperator = operator;
        this.operatorType = 59;
    }

    @Override
    public void enterListUserPrivileges(SqlBaseParser.ListUserPrivilegesContext ctx) {
        super.enterListUserPrivileges(ctx);
        AuthorOperator operator = new AuthorOperator(59, AuthorOperator.AuthorType.LIST_USER_PRIVILEGE);
        operator.setUserName(ctx.ID().getText());
        this.initializedOperator = operator;
        this.operatorType = 59;
    }

    @Override
    public void enterListRolePrivileges(SqlBaseParser.ListRolePrivilegesContext ctx) {
        super.enterListRolePrivileges(ctx);
        AuthorOperator operator = new AuthorOperator(59, AuthorOperator.AuthorType.LIST_ROLE_PRIVILEGE);
        operator.setRoleName(ctx.ID().getText());
        this.initializedOperator = operator;
        this.operatorType = 59;
    }

    @Override
    public void enterListAllRoleOfUser(SqlBaseParser.ListAllRoleOfUserContext ctx) {
        super.enterListAllRoleOfUser(ctx);
        AuthorOperator operator = new AuthorOperator(59, AuthorOperator.AuthorType.LIST_USER_ROLES);
        this.initializedOperator = operator;
        operator.setUserName(ctx.ID().getText());
        this.operatorType = 59;
    }

    @Override
    public void enterListAllUserOfRole(SqlBaseParser.ListAllUserOfRoleContext ctx) {
        super.enterListAllUserOfRole(ctx);
        AuthorOperator operator = new AuthorOperator(59, AuthorOperator.AuthorType.LIST_ROLE_USERS);
        this.initializedOperator = operator;
        operator.setRoleName(ctx.ID().getText());
        this.operatorType = 59;
    }

    @Override
    public void enterSetTTLStatement(SqlBaseParser.SetTTLStatementContext ctx) {
        super.enterSetTTLStatement(ctx);
        SetTTLOperator operator = new SetTTLOperator(63);
        operator.setStorageGroup(this.parsePrefixPath(ctx.prefixPath()).getFullPath());
        operator.setDataTTL(Long.parseLong(ctx.INT().getText()));
        this.initializedOperator = operator;
        this.operatorType = 63;
    }

    @Override
    public void enterUnsetTTLStatement(SqlBaseParser.UnsetTTLStatementContext ctx) {
        super.enterUnsetTTLStatement(ctx);
        SetTTLOperator operator = new SetTTLOperator(64);
        operator.setStorageGroup(this.parsePrefixPath(ctx.prefixPath()).getFullPath());
        this.initializedOperator = operator;
        this.operatorType = 64;
    }

    @Override
    public void enterShowTTLStatement(SqlBaseParser.ShowTTLStatementContext ctx) {
        super.enterShowTTLStatement(ctx);
        ArrayList<String> storageGroups = new ArrayList<String>();
        List<SqlBaseParser.PrefixPathContext> prefixPathList = ctx.prefixPath();
        for (SqlBaseParser.PrefixPathContext prefixPath : prefixPathList) {
            storageGroups.add(this.parsePrefixPath(prefixPath).getFullPath());
        }
        this.initializedOperator = new ShowTTLOperator(storageGroups);
    }

    @Override
    public void enterShowAllTTLStatement(SqlBaseParser.ShowAllTTLStatementContext ctx) {
        super.enterShowAllTTLStatement(ctx);
        ArrayList<String> storageGroups = new ArrayList<String>();
        this.initializedOperator = new ShowTTLOperator(storageGroups);
    }

    private String[] parsePrivilege(SqlBaseParser.PrivilegesContext ctx) {
        List<TerminalNode> privilegeList = ctx.STRING_LITERAL();
        ArrayList<String> privileges = new ArrayList<String>();
        for (TerminalNode privilege : privilegeList) {
            privileges.add(this.removeStringQuote(privilege.getText()));
        }
        return privileges.toArray(new String[0]);
    }

    private String removeStringQuote(String src) {
        if (src.charAt(0) == '\'' && src.charAt(src.length() - 1) == '\'') {
            return src.substring(1, src.length() - 1);
        }
        if (src.charAt(0) == '\"' && src.charAt(src.length() - 1) == '\"') {
            return src.substring(1, src.length() - 1);
        }
        throw new SQLParserException("error format for string with quote:" + src);
    }

    @Override
    public void enterDeleteTimeseries(SqlBaseParser.DeleteTimeseriesContext ctx) {
        super.enterDeleteTimeseries(ctx);
        ArrayList<Path> deletePaths = new ArrayList<Path>();
        List<SqlBaseParser.PrefixPathContext> prefixPaths = ctx.prefixPath();
        for (SqlBaseParser.PrefixPathContext prefixPath : prefixPaths) {
            deletePaths.add(this.parsePrefixPath(prefixPath));
        }
        DeleteTimeSeriesOperator deleteTimeSeriesOperator = new DeleteTimeSeriesOperator(52);
        deleteTimeSeriesOperator.setDeletePathList(deletePaths);
        this.initializedOperator = deleteTimeSeriesOperator;
        this.operatorType = 52;
    }

    @Override
    public void enterSetStorageGroup(SqlBaseParser.SetStorageGroupContext ctx) {
        super.enterSetStorageGroup(ctx);
        SetStorageGroupOperator setStorageGroupOperator = new SetStorageGroupOperator(53);
        Path path = this.parseFullPath(ctx.fullPath());
        setStorageGroupOperator.setPath(path);
        this.initializedOperator = setStorageGroupOperator;
        this.operatorType = 53;
    }

    @Override
    public void enterDeleteStorageGroup(SqlBaseParser.DeleteStorageGroupContext ctx) {
        super.enterDeleteStorageGroup(ctx);
        ArrayList<Path> deletePaths = new ArrayList<Path>();
        List<SqlBaseParser.FullPathContext> fullPaths = ctx.fullPath();
        for (SqlBaseParser.FullPathContext fullPath : fullPaths) {
            deletePaths.add(this.parseFullPath(fullPath));
        }
        DeleteStorageGroupOperator deleteStorageGroupOperator = new DeleteStorageGroupOperator(62);
        deleteStorageGroupOperator.setDeletePathList(deletePaths);
        this.initializedOperator = deleteStorageGroupOperator;
        this.operatorType = 62;
    }

    @Override
    public void enterDeleteStatement(SqlBaseParser.DeleteStatementContext ctx) {
        super.enterDeleteStatement(ctx);
        this.operatorType = 25;
        this.deleteDataOp = new DeleteDataOperator(25);
        this.selectOp = new SelectOperator(21);
        List<SqlBaseParser.PrefixPathContext> prefixPaths = ctx.prefixPath();
        for (SqlBaseParser.PrefixPathContext prefixPath : prefixPaths) {
            Path path = this.parsePrefixPath(prefixPath);
            this.selectOp.addSelectPath(path);
        }
        this.deleteDataOp.setSelectOperator(this.selectOp);
        this.initializedOperator = this.deleteDataOp;
    }

    @Override
    public void enterDisableAlign(SqlBaseParser.DisableAlignContext ctx) {
        super.enterDisableAlign(ctx);
        this.queryOp.setAlignByTime(false);
    }

    @Override
    public void enterGroupByFillClause(SqlBaseParser.GroupByFillClauseContext ctx) {
        super.enterGroupByFillClause(ctx);
        this.queryOp.setGroupBy(true);
        this.queryOp.setFill(true);
        this.queryOp.setLeftCRightO(ctx.timeInterval().LS_BRACKET() != null);
        this.queryOp.setUnit(this.parseDuration(ctx.DURATION().getText()));
        this.queryOp.setSlidingStep(this.queryOp.getUnit());
        this.parseTimeInterval(ctx.timeInterval());
        List<SqlBaseParser.TypeClauseContext> list = ctx.typeClause();
        EnumMap<TSDataType, IFill> fillTypes = new EnumMap<TSDataType, IFill>(TSDataType.class);
        for (SqlBaseParser.TypeClauseContext typeClause : list) {
            if (typeClause.linearClause() != null) {
                throw new SQLParserException("group by fill doesn't support linear fill");
            }
            if ("all".equalsIgnoreCase(typeClause.dataType().getText())) {
                PreviousFill fill;
                long preRange;
                if (typeClause.previousUntilLastClause() != null) {
                    preRange = typeClause.previousUntilLastClause().DURATION() != null ? this.parseDuration(typeClause.previousUntilLastClause().DURATION().getText()) : (long)IoTDBDescriptor.getInstance().getConfig().getDefaultFillInterval();
                    fill = new PreviousFill(preRange, true);
                } else {
                    preRange = typeClause.previousClause().DURATION() != null ? this.parseDuration(typeClause.previousClause().DURATION().getText()) : (long)IoTDBDescriptor.getInstance().getConfig().getDefaultFillInterval();
                    fill = new PreviousFill(preRange);
                }
                for (TSDataType tsDataType : TSDataType.values()) {
                    fillTypes.put(tsDataType, ((IFill)fill).copy());
                }
                break;
            }
            this.parseTypeClause(typeClause, fillTypes);
        }
        this.queryOp.setFill(true);
        this.queryOp.setFillTypes(fillTypes);
    }

    private void parseTimeInterval(SqlBaseParser.TimeIntervalContext timeInterval) {
        long startTime = timeInterval.timeValue(0).INT() != null ? Long.parseLong(timeInterval.timeValue(0).INT().getText()) : (timeInterval.timeValue(0).dateExpression() != null ? this.parseDateExpression(timeInterval.timeValue(0).dateExpression()).longValue() : this.parseTimeFormat(timeInterval.timeValue(0).dateFormat().getText()));
        long endTime = timeInterval.timeValue(1).INT() != null ? Long.parseLong(timeInterval.timeValue(1).INT().getText()) : (timeInterval.timeValue(1).dateExpression() != null ? this.parseDateExpression(timeInterval.timeValue(1).dateExpression()).longValue() : this.parseTimeFormat(timeInterval.timeValue(1).dateFormat().getText()));
        this.queryOp.setStartTime(startTime);
        this.queryOp.setEndTime(endTime);
    }

    @Override
    public void enterGroupByClause(SqlBaseParser.GroupByClauseContext ctx) {
        super.enterGroupByClause(ctx);
        this.queryOp.setGroupBy(true);
        this.queryOp.setLeftCRightO(ctx.timeInterval().LS_BRACKET() != null);
        this.queryOp.setUnit(this.parseDuration(ctx.DURATION(0).getText()));
        this.queryOp.setSlidingStep(this.queryOp.getUnit());
        if (ctx.DURATION().size() == 2) {
            this.queryOp.setSlidingStep(this.parseDuration(ctx.DURATION(1).getText()));
            if (this.queryOp.getSlidingStep() < this.queryOp.getUnit()) {
                throw new SQLParserException("The third parameter sliding step shouldn't be smaller than the second parameter time interval.");
            }
        }
        this.parseTimeInterval(ctx.timeInterval());
    }

    @Override
    public void enterFillClause(SqlBaseParser.FillClauseContext ctx) {
        super.enterFillClause(ctx);
        FilterOperator filterOperator = this.queryOp.getFilterOperator();
        if (!filterOperator.isLeaf() || filterOperator.getTokenIntType() != 113) {
            throw new SQLParserException("Only \"=\" can be used in fill function");
        }
        List<SqlBaseParser.TypeClauseContext> list = ctx.typeClause();
        EnumMap<TSDataType, IFill> fillTypes = new EnumMap<TSDataType, IFill>(TSDataType.class);
        for (SqlBaseParser.TypeClauseContext typeClause : list) {
            this.parseTypeClause(typeClause, fillTypes);
        }
        this.queryOp.setFill(true);
        this.queryOp.setFillTypes(fillTypes);
    }

    private void parseTypeClause(SqlBaseParser.TypeClauseContext ctx, Map<TSDataType, IFill> fillTypes) {
        TSDataType dataType = this.parseType(ctx.dataType().getText());
        if (ctx.linearClause() != null && dataType == TSDataType.TEXT) {
            throw new SQLParserException(String.format("type %s cannot use %s fill function", dataType, ctx.linearClause().LINEAR().getText()));
        }
        int defaultFillInterval = IoTDBDescriptor.getInstance().getConfig().getDefaultFillInterval();
        if (ctx.linearClause() != null) {
            if (ctx.linearClause().DURATION(0) != null) {
                long beforeRange = this.parseDuration(ctx.linearClause().DURATION(0).getText());
                long afterRange = this.parseDuration(ctx.linearClause().DURATION(1).getText());
                fillTypes.put(dataType, new LinearFill(beforeRange, afterRange));
            } else {
                fillTypes.put(dataType, new LinearFill(defaultFillInterval, (long)defaultFillInterval));
            }
        } else if (ctx.previousClause() != null) {
            if (ctx.previousClause().DURATION() != null) {
                long preRange = this.parseDuration(ctx.previousClause().DURATION().getText());
                fillTypes.put(dataType, new PreviousFill(preRange));
            } else {
                fillTypes.put(dataType, new PreviousFill(defaultFillInterval));
            }
        } else if (ctx.previousUntilLastClause().DURATION() != null) {
            long preRange = this.parseDuration(ctx.previousUntilLastClause().DURATION().getText());
            fillTypes.put(dataType, new PreviousFill(preRange, true));
        } else {
            fillTypes.put(dataType, new PreviousFill(defaultFillInterval, true));
        }
    }

    @Override
    public void enterAlignByDeviceClause(SqlBaseParser.AlignByDeviceClauseContext ctx) {
        super.enterAlignByDeviceClause(ctx);
        this.queryOp.setAlignByDevice(true);
    }

    private TSDataType parseType(String datatype) {
        String type;
        switch (type = datatype.toLowerCase()) {
            case "int32": {
                return TSDataType.INT32;
            }
            case "int64": {
                return TSDataType.INT64;
            }
            case "float": {
                return TSDataType.FLOAT;
            }
            case "double": {
                return TSDataType.DOUBLE;
            }
            case "boolean": {
                return TSDataType.BOOLEAN;
            }
            case "text": {
                return TSDataType.TEXT;
            }
        }
        throw new SQLParserException("not a valid fill type : " + type);
    }

    @Override
    public void enterLimitClause(SqlBaseParser.LimitClauseContext ctx) {
        int limit;
        super.enterLimitClause(ctx);
        try {
            limit = Integer.parseInt(ctx.INT().getText());
        }
        catch (NumberFormatException e) {
            throw new SQLParserException("Out of range. LIMIT <N>: N should be Int32.");
        }
        if (limit <= 0) {
            throw new SQLParserException("LIMIT <N>: N should be greater than 0.");
        }
        if (this.initializedOperator instanceof ShowTimeSeriesOperator) {
            ((ShowTimeSeriesOperator)this.initializedOperator).setLimit(limit);
        } else {
            this.queryOp.setRowLimit(limit);
        }
    }

    @Override
    public void enterOffsetClause(SqlBaseParser.OffsetClauseContext ctx) {
        int offset;
        super.enterOffsetClause(ctx);
        try {
            offset = Integer.parseInt(ctx.INT().getText());
        }
        catch (NumberFormatException e) {
            throw new SQLParserException("Out of range. OFFSET <OFFSETValue>: OFFSETValue should be Int32.");
        }
        if (offset < 0) {
            throw new SQLParserException("OFFSET <OFFSETValue>: OFFSETValue should >= 0.");
        }
        if (this.initializedOperator instanceof ShowTimeSeriesOperator) {
            ((ShowTimeSeriesOperator)this.initializedOperator).setOffset(offset);
        } else {
            this.queryOp.setRowOffset(offset);
        }
    }

    @Override
    public void enterSlimitClause(SqlBaseParser.SlimitClauseContext ctx) {
        int slimit;
        super.enterSlimitClause(ctx);
        try {
            slimit = Integer.parseInt(ctx.INT().getText());
        }
        catch (NumberFormatException e) {
            throw new SQLParserException("Out of range. SLIMIT <SN>: SN should be Int32.");
        }
        if (slimit <= 0) {
            throw new SQLParserException("SLIMIT <SN>: SN should be greater than 0.");
        }
        this.queryOp.setSeriesLimit(slimit);
    }

    @Override
    public void enterSoffsetClause(SqlBaseParser.SoffsetClauseContext ctx) {
        int soffset;
        super.enterSoffsetClause(ctx);
        try {
            soffset = Integer.parseInt(ctx.INT().getText());
        }
        catch (NumberFormatException e) {
            throw new SQLParserException("Out of range. SOFFSET <SOFFSETValue>: SOFFSETValue should be Int32.");
        }
        if (soffset < 0) {
            throw new SQLParserException("SOFFSET <SOFFSETValue>: SOFFSETValue should >= 0.");
        }
        this.queryOp.setSeriesOffset(soffset);
    }

    @Override
    public void enterInsertColumnSpec(SqlBaseParser.InsertColumnSpecContext ctx) {
        super.enterInsertColumnSpec(ctx);
        List<SqlBaseParser.NodeNameWithoutStarContext> nodeNamesWithoutStar = ctx.nodeNameWithoutStar();
        ArrayList<String> measurementList = new ArrayList<String>();
        for (SqlBaseParser.NodeNameWithoutStarContext nodeNameWithoutStar : nodeNamesWithoutStar) {
            String measurement = nodeNameWithoutStar.getText();
            if (measurement.contains("\"") || measurement.contains("'")) {
                measurement = measurement.substring(1, measurement.length() - 1);
            }
            measurementList.add(measurement);
        }
        this.insertOp.setMeasurementList(measurementList.toArray(new String[0]));
    }

    @Override
    public void enterInsertValuesSpec(SqlBaseParser.InsertValuesSpecContext ctx) {
        super.enterInsertValuesSpec(ctx);
        long timestamp = ctx.dateFormat() != null ? this.parseTimeFormat(ctx.dateFormat().getText()) : Long.parseLong(ctx.INT().getText());
        this.insertOp.setTime(timestamp);
        ArrayList<String> valueList = new ArrayList<String>();
        List<SqlBaseParser.ConstantContext> values = ctx.constant();
        for (SqlBaseParser.ConstantContext value : values) {
            valueList.add(value.getText());
        }
        this.insertOp.setValueList(valueList.toArray(new String[0]));
        this.initializedOperator = this.insertOp;
    }

    private Path parseFullPath(SqlBaseParser.FullPathContext ctx) {
        List<SqlBaseParser.NodeNameWithoutStarContext> nodeNamesWithoutStar = ctx.nodeNameWithoutStar();
        ArrayList<String> path = new ArrayList<String>();
        if (ctx.ROOT() != null) {
            path.add(ctx.ROOT().getText());
        }
        for (SqlBaseParser.NodeNameWithoutStarContext nodeNameWithoutStar : nodeNamesWithoutStar) {
            path.add(nodeNameWithoutStar.getText());
        }
        return new Path(new StringContainer(path.toArray(new String[0]), "."));
    }

    @Override
    public void enterAttributeClauses(SqlBaseParser.AttributeClausesContext ctx) {
        super.enterAttributeClauses(ctx);
        String dataType = ctx.dataType().getChild(0).getText().toUpperCase();
        String encoding = ctx.encoding().getChild(0).getText().toUpperCase();
        this.createTimeSeriesOperator.setDataType(TSDataType.valueOf((String)dataType));
        this.createTimeSeriesOperator.setEncoding(TSEncoding.valueOf((String)encoding));
        List<SqlBaseParser.PropertyContext> properties = ctx.property();
        HashMap<String, String> props = new HashMap<String, String>(properties.size());
        CompressionType compressor = ctx.propertyValue() != null ? CompressionType.valueOf((String)ctx.propertyValue().getText().toUpperCase()) : TSFileDescriptor.getInstance().getConfig().getCompressor();
        this.checkMetadataArgs(dataType, encoding, compressor.toString().toUpperCase());
        if (ctx.property(0) != null) {
            for (SqlBaseParser.PropertyContext property : properties) {
                props.put(property.ID().getText().toLowerCase(), property.propertyValue().getText().toLowerCase());
            }
        }
        this.createTimeSeriesOperator.setCompressor(compressor);
        this.createTimeSeriesOperator.setProps(props);
        this.initializedOperator = this.createTimeSeriesOperator;
    }

    @Override
    public void enterAliasClause(SqlBaseParser.AliasClauseContext ctx) {
        super.enterAliasClause(ctx);
        if (this.alterTimeSeriesOperator != null && ctx.ID() != null) {
            this.alterTimeSeriesOperator.setAlias(ctx.ID().getText());
        }
    }

    @Override
    public void enterAttributeClause(SqlBaseParser.AttributeClauseContext ctx) {
        super.enterAttributeClause(ctx);
        Map<String, String> attributes = this.extractMap(ctx.property(), ctx.property(0));
        if (this.createTimeSeriesOperator != null) {
            this.createTimeSeriesOperator.setAttributes(attributes);
        } else if (this.alterTimeSeriesOperator != null) {
            this.alterTimeSeriesOperator.setAttributesMap(attributes);
        }
    }

    @Override
    public void enterTagClause(SqlBaseParser.TagClauseContext ctx) {
        super.enterTagClause(ctx);
        Map<String, String> tags = this.extractMap(ctx.property(), ctx.property(0));
        if (this.createTimeSeriesOperator != null) {
            this.createTimeSeriesOperator.setTags(tags);
        } else if (this.alterTimeSeriesOperator != null) {
            this.alterTimeSeriesOperator.setTagsMap(tags);
        }
    }

    private Map<String, String> extractMap(List<SqlBaseParser.PropertyContext> property2, SqlBaseParser.PropertyContext property3) {
        HashMap<String, String> tags = new HashMap<String, String>(property2.size());
        if (property3 != null) {
            for (SqlBaseParser.PropertyContext property : property2) {
                String value = property.propertyValue().STRING_LITERAL() != null ? this.removeStringQuote(property.propertyValue().getText()) : property.propertyValue().getText();
                tags.put(property.ID().getText(), value);
            }
        }
        return tags;
    }

    @Override
    public void enterInsertStatement(SqlBaseParser.InsertStatementContext ctx) {
        super.enterInsertStatement(ctx);
        this.insertOp = new InsertOperator(24);
        this.selectOp = new SelectOperator(21);
        this.operatorType = 24;
        this.selectOp.addSelectPath(this.parseFullPath(ctx.fullPath()));
        this.insertOp.setSelectOperator(this.selectOp);
    }

    @Override
    public void enterUpdateStatement(SqlBaseParser.UpdateStatementContext ctx) {
        super.enterUpdateStatement(ctx);
        this.updateOp = new UpdateOperator(26);
        FromOperator fromOp = new FromOperator(22);
        fromOp.addPrefixTablePath(this.parsePrefixPath(ctx.prefixPath()));
        this.selectOp = new SelectOperator(21);
        this.operatorType = 26;
        this.initializedOperator = this.updateOp;
    }

    @Override
    public void enterSelectStatement(SqlBaseParser.SelectStatementContext ctx) {
        super.enterSelectStatement(ctx);
        this.operatorType = 27;
        this.queryOp = new QueryOperator(27);
        this.initializedOperator = this.queryOp;
    }

    @Override
    public void enterSelectConstElement(SqlBaseParser.SelectConstElementContext ctx) {
        super.enterSelectConstElement(ctx);
        this.operatorType = 27;
        this.queryOp = new QueryOperator(27);
        this.initializedOperator = this.queryOp;
    }

    @Override
    public void enterFromClause(SqlBaseParser.FromClauseContext ctx) {
        super.enterFromClause(ctx);
        FromOperator fromOp = new FromOperator(22);
        List<SqlBaseParser.PrefixPathContext> prefixFromPaths = ctx.prefixPath();
        for (SqlBaseParser.PrefixPathContext prefixFromPath : prefixFromPaths) {
            Path path = this.parsePrefixPath(prefixFromPath);
            fromOp.addPrefixTablePath(path);
        }
        this.queryOp.setFromOperator(fromOp);
    }

    @Override
    public void enterFunctionElement(SqlBaseParser.FunctionElementContext ctx) {
        super.enterFunctionElement(ctx);
        this.selectOp = new SelectOperator(21);
        List<SqlBaseParser.FunctionCallContext> functionCallContextList = ctx.functionCall();
        for (SqlBaseParser.FunctionCallContext functionCallContext : functionCallContextList) {
            Path path = this.parseSuffixPath(functionCallContext.suffixPath());
            this.selectOp.addClusterPath(path, functionCallContext.functionName().getText());
        }
        this.queryOp.setSelectOperator(this.selectOp);
    }

    @Override
    public void enterSelectElement(SqlBaseParser.SelectElementContext ctx) {
        super.enterSelectElement(ctx);
        this.selectOp = new SelectOperator(21);
        List<SqlBaseParser.SuffixPathContext> suffixPaths = ctx.suffixPath();
        for (SqlBaseParser.SuffixPathContext suffixPath : suffixPaths) {
            Path path = this.parseSuffixPath(suffixPath);
            this.selectOp.addSelectPath(path);
        }
        this.queryOp.setSelectOperator(this.selectOp);
    }

    @Override
    public void enterLastElement(SqlBaseParser.LastElementContext ctx) {
        super.enterLastElement(ctx);
        this.selectOp = new SelectOperator(21);
        this.selectOp.setLastQuery();
        SqlBaseParser.LastClauseContext lastClauseContext = ctx.lastClause();
        List<SqlBaseParser.SuffixPathContext> suffixPaths = lastClauseContext.suffixPath();
        for (SqlBaseParser.SuffixPathContext suffixPath : suffixPaths) {
            Path path = this.parseSuffixPath(suffixPath);
            this.selectOp.addSelectPath(path);
        }
        this.queryOp.setSelectOperator(this.selectOp);
    }

    @Override
    public void enterSetCol(SqlBaseParser.SetColContext ctx) {
        super.enterSetCol(ctx);
        this.selectOp.addSelectPath(this.parseSuffixPath(ctx.suffixPath()));
        this.updateOp.setSelectOperator(this.selectOp);
        this.updateOp.setValue(ctx.constant().getText());
    }

    private Path parsePrefixPath(SqlBaseParser.PrefixPathContext ctx) {
        List<SqlBaseParser.NodeNameContext> nodeNames = ctx.nodeName();
        ArrayList<String> path = new ArrayList<String>();
        path.add(ctx.ROOT().getText());
        for (SqlBaseParser.NodeNameContext nodeName : nodeNames) {
            path.add(nodeName.getText());
        }
        return new Path(new StringContainer(path.toArray(new String[0]), "."));
    }

    private Long parseDuration(String durationStr) {
        String timestampPrecision = IoTDBDescriptor.getInstance().getConfig().getTimestampPrecision();
        long total = 0L;
        long tmp = 0L;
        for (int i = 0; i < durationStr.length(); ++i) {
            char ch = durationStr.charAt(i);
            if (Character.isDigit(ch)) {
                tmp *= 10L;
                tmp += (long)(ch - 48);
                continue;
            }
            String unit = durationStr.charAt(i) + "";
            if (i + 1 < durationStr.length() && !Character.isDigit(durationStr.charAt(i + 1))) {
                unit = unit + durationStr.charAt(++i);
            }
            total += DatetimeUtils.convertDurationStrToLong(tmp, unit.toLowerCase(), timestampPrecision);
            tmp = 0L;
        }
        if (total <= 0L) {
            throw new SQLParserException("Interval must more than 0.");
        }
        return total;
    }

    @Override
    public void enterWhereClause(SqlBaseParser.WhereClauseContext ctx) {
        super.enterWhereClause(ctx);
        FilterOperator whereOp = new FilterOperator(23);
        whereOp.addChildOperator(this.parseOrExpression(ctx.orExpression()));
        switch (this.operatorType) {
            case 25: {
                this.deleteDataOp.setFilterOperator(whereOp.getChildren().get(0));
                long deleteTime = this.parseDeleteTimeFilter(this.deleteDataOp);
                this.deleteDataOp.setTime(deleteTime);
                break;
            }
            case 27: {
                this.queryOp.setFilterOperator(whereOp.getChildren().get(0));
                break;
            }
            case 26: {
                this.updateOp.setFilterOperator(whereOp.getChildren().get(0));
                break;
            }
            default: {
                throw new SQLParserException("Where only support select, delete, update.");
            }
        }
    }

    @Override
    public void enterShowWhereClause(SqlBaseParser.ShowWhereClauseContext ctx) {
        SqlBaseParser.PropertyValueContext propertyValueContext;
        super.enterShowWhereClause(ctx);
        ShowTimeSeriesOperator operator = (ShowTimeSeriesOperator)this.initializedOperator;
        if (ctx.containsExpression() != null) {
            operator.setContains(true);
            propertyValueContext = ctx.containsExpression().propertyValue();
            operator.setKey(ctx.containsExpression().ID().getText());
        } else {
            operator.setContains(false);
            propertyValueContext = ctx.property().propertyValue();
            operator.setKey(ctx.property().ID().getText());
        }
        String value = propertyValueContext.STRING_LITERAL() != null ? this.removeStringQuote(propertyValueContext.getText()) : propertyValueContext.getText();
        operator.setValue(value);
    }

    private FilterOperator parseOrExpression(SqlBaseParser.OrExpressionContext ctx) {
        if (ctx.andExpression().size() == 1) {
            return this.parseAndExpression(ctx.andExpression(0));
        }
        FilterOperator binaryOp = new FilterOperator(2);
        if (ctx.andExpression().size() > 2) {
            binaryOp.addChildOperator(this.parseAndExpression(ctx.andExpression(0)));
            binaryOp.addChildOperator(this.parseAndExpression(ctx.andExpression(1)));
            for (int i = 2; i < ctx.andExpression().size(); ++i) {
                FilterOperator op = new FilterOperator(2);
                op.addChildOperator(binaryOp);
                op.addChildOperator(this.parseAndExpression(ctx.andExpression(i)));
                binaryOp = op;
            }
        } else {
            for (SqlBaseParser.AndExpressionContext andExpressionContext : ctx.andExpression()) {
                binaryOp.addChildOperator(this.parseAndExpression(andExpressionContext));
            }
        }
        return binaryOp;
    }

    private FilterOperator parseAndExpression(SqlBaseParser.AndExpressionContext ctx) {
        if (ctx.predicate().size() == 1) {
            return this.parsePredicate(ctx.predicate(0));
        }
        FilterOperator binaryOp = new FilterOperator(1);
        int size = ctx.predicate().size();
        if (size > 2) {
            binaryOp.addChildOperator(this.parsePredicate(ctx.predicate(0)));
            binaryOp.addChildOperator(this.parsePredicate(ctx.predicate(1)));
            for (int i = 2; i < size; ++i) {
                FilterOperator op = new FilterOperator(1);
                op.addChildOperator(binaryOp);
                op.addChildOperator(this.parsePredicate(ctx.predicate(i)));
                binaryOp = op;
            }
        } else {
            for (SqlBaseParser.PredicateContext predicateContext : ctx.predicate()) {
                binaryOp.addChildOperator(this.parsePredicate(predicateContext));
            }
        }
        return binaryOp;
    }

    private FilterOperator parsePredicate(SqlBaseParser.PredicateContext ctx) {
        if (ctx.OPERATOR_NOT() != null) {
            FilterOperator notOp = new FilterOperator(3);
            notOp.addChildOperator(this.parseOrExpression(ctx.orExpression()));
            return notOp;
        }
        if (ctx.LR_BRACKET() != null && ctx.OPERATOR_NOT() == null) {
            return this.parseOrExpression(ctx.orExpression());
        }
        Path path = null;
        if (ctx.TIME() != null || ctx.TIMESTAMP() != null) {
            path = new Path("time");
        }
        if (ctx.fullPath() != null) {
            path = this.parseFullPath(ctx.fullPath());
        }
        if (ctx.suffixPath() != null) {
            path = this.parseSuffixPath(ctx.suffixPath());
        }
        if (path == null) {
            throw new SQLParserException("Path is null, please check the sql.");
        }
        if (ctx.inClause() != null) {
            return this.parseInOperator(ctx.inClause(), path);
        }
        return this.parseBasicFunctionOperator(ctx, path);
    }

    private FilterOperator parseInOperator(SqlBaseParser.InClauseContext ctx, Path path) {
        HashSet<String> values = new HashSet<String>();
        boolean not = ctx.OPERATOR_NOT() != null;
        for (SqlBaseParser.ConstantContext constant : ctx.constant()) {
            if (constant.dateExpression() != null) {
                if (!path.equals("time")) {
                    throw new SQLParserException(path.toString(), "Date can only be used to time");
                }
                values.add(Long.toString(this.parseDateExpression(constant.dateExpression())));
                continue;
            }
            values.add(constant.getText());
        }
        return new InOperator(ctx.OPERATOR_IN().getSymbol().getType(), path, not, values);
    }

    private FilterOperator parseBasicFunctionOperator(SqlBaseParser.PredicateContext ctx, Path path) {
        BasicFunctionOperator basic;
        if (ctx.constant().dateExpression() != null) {
            if (!path.equals("time")) {
                throw new SQLParserException(path.toString(), "Date can only be used to time");
            }
            basic = new BasicFunctionOperator(ctx.comparisonOperator().type.getType(), path, Long.toString(this.parseDateExpression(ctx.constant().dateExpression())));
        } else {
            basic = new BasicFunctionOperator(ctx.comparisonOperator().type.getType(), path, ctx.constant().getText());
        }
        return basic;
    }

    private Path parseSuffixPath(SqlBaseParser.SuffixPathContext ctx) {
        List<SqlBaseParser.NodeNameContext> nodeNames = ctx.nodeName();
        ArrayList<String> path = new ArrayList<String>();
        for (SqlBaseParser.NodeNameContext nodeName : nodeNames) {
            path.add(nodeName.getText());
        }
        return new Path(new StringContainer(path.toArray(new String[0]), "."));
    }

    private Long parseDateExpression(SqlBaseParser.DateExpressionContext ctx) {
        long time = this.parseTimeFormat(ctx.getChild(0).getText());
        for (int i = 1; i < ctx.getChildCount(); i += 2) {
            if (ctx.getChild(i).getText().equals("+")) {
                time += this.parseDuration(ctx.getChild(i + 1).getText()).longValue();
                continue;
            }
            time -= this.parseDuration(ctx.getChild(i + 1).getText()).longValue();
        }
        return time;
    }

    long parseTimeFormat(String timestampStr) throws SQLParserException {
        if (timestampStr == null || timestampStr.trim().equals("")) {
            throw new SQLParserException("input timestamp cannot be empty");
        }
        long startupNano = IoTDBDescriptor.getInstance().getConfig().getStartUpNanosecond();
        if (timestampStr.equalsIgnoreCase("now()")) {
            String timePrecision;
            switch (timePrecision = IoTDBDescriptor.getInstance().getConfig().getTimestampPrecision()) {
                case "ns": {
                    return System.currentTimeMillis() * 1000000L + (System.nanoTime() - startupNano) % 1000000L;
                }
                case "us": {
                    return System.currentTimeMillis() * 1000L + (System.nanoTime() - startupNano) / 1000L % 1000L;
                }
            }
            return System.currentTimeMillis();
        }
        try {
            return DatetimeUtils.convertDatetimeStrToLong(timestampStr, this.zoneId);
        }
        catch (Exception e) {
            throw new SQLParserException(String.format("Input time format %s error. Input like yyyy-MM-dd HH:mm:ss, yyyy-MM-ddTHH:mm:ss or refer to user document for more info.", timestampStr));
        }
    }

    private long parseDeleteTimeFilter(DeleteDataOperator operator) {
        FilterOperator filterOperator = operator.getFilterOperator();
        if (filterOperator.getTokenIntType() != 116 && filterOperator.getTokenIntType() != 117) {
            throw new SQLParserException("For delete command, where clause must be like : time < XXX or time <= XXX");
        }
        long time = Long.parseLong(((BasicFunctionOperator)filterOperator).getValue());
        if (filterOperator.getTokenIntType() == 116) {
            --time;
        }
        return time;
    }

    private void checkMetadataArgs(String dataType, String encoding, String compressor) {
        TSEncoding tsEncoding;
        TSDataType tsDataType;
        if (dataType == null) {
            throw new SQLParserException("data type cannot be null");
        }
        try {
            tsDataType = TSDataType.valueOf((String)dataType);
        }
        catch (Exception e) {
            throw new SQLParserException(String.format("data type %s not support", dataType));
        }
        if (encoding == null) {
            throw new SQLParserException("encoding type cannot be null");
        }
        try {
            tsEncoding = TSEncoding.valueOf((String)encoding);
        }
        catch (Exception e) {
            throw new SQLParserException(String.format("encoding %s is not support", encoding));
        }
        try {
            CompressionType.valueOf((String)compressor);
        }
        catch (Exception e) {
            throw new SQLParserException(String.format("compressor %s is not support", compressor));
        }
        this.checkDataTypeEncoding(tsDataType, tsEncoding);
    }

    private void checkDataTypeEncoding(TSDataType tsDataType, TSEncoding tsEncoding) {
        boolean throwExp = false;
        switch (tsDataType) {
            case BOOLEAN: {
                if (tsEncoding.equals((Object)TSEncoding.RLE) || tsEncoding.equals((Object)TSEncoding.PLAIN)) break;
                throwExp = true;
                break;
            }
            case INT32: 
            case INT64: {
                if (tsEncoding.equals((Object)TSEncoding.RLE) || tsEncoding.equals((Object)TSEncoding.PLAIN) || tsEncoding.equals((Object)TSEncoding.TS_2DIFF)) break;
                throwExp = true;
                break;
            }
            case FLOAT: 
            case DOUBLE: {
                if (tsEncoding.equals((Object)TSEncoding.RLE) || tsEncoding.equals((Object)TSEncoding.PLAIN) || tsEncoding.equals((Object)TSEncoding.TS_2DIFF) || tsEncoding.equals((Object)TSEncoding.GORILLA)) break;
                throwExp = true;
                break;
            }
            case TEXT: {
                if (tsEncoding.equals((Object)TSEncoding.PLAIN)) break;
                throwExp = true;
                break;
            }
            default: {
                throwExp = true;
            }
        }
        if (throwExp) {
            throw new SQLParserException(String.format("encoding %s does not support %s", tsEncoding, tsDataType));
        }
    }
}

