/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.strategy.optimizer;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.exception.query.LogicalOptimizeException;
import org.apache.iotdb.db.exception.runtime.SQLParserException;
import org.apache.iotdb.db.metadata.MManager;
import org.apache.iotdb.db.qp.constant.SQLConstant;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.logical.crud.BasicFunctionOperator;
import org.apache.iotdb.db.qp.logical.crud.FilterOperator;
import org.apache.iotdb.db.qp.logical.crud.FromOperator;
import org.apache.iotdb.db.qp.logical.crud.FunctionOperator;
import org.apache.iotdb.db.qp.logical.crud.QueryOperator;
import org.apache.iotdb.db.qp.logical.crud.SFWOperator;
import org.apache.iotdb.db.qp.logical.crud.SelectOperator;
import org.apache.iotdb.db.qp.strategy.optimizer.ILogicalOptimizer;
import org.apache.iotdb.tsfile.read.common.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcatPathOptimizer
implements ILogicalOptimizer {
    private static final Logger logger = LoggerFactory.getLogger(ConcatPathOptimizer.class);
    private static final String WARNING_NO_SUFFIX_PATHS = "given SFWOperator doesn't have suffix paths, cannot concat seriesPath";
    private static final String WARNING_NO_PREFIX_PATHS = "given SFWOperator doesn't have prefix paths, cannot concat seriesPath";

    @Override
    public Operator transform(Operator operator) throws LogicalOptimizeException {
        if (!(operator instanceof SFWOperator)) {
            logger.warn("given operator isn't SFWOperator, cannot concat seriesPath");
            return operator;
        }
        SFWOperator sfwOperator = (SFWOperator)operator;
        FromOperator from = sfwOperator.getFromOperator();
        if (from == null) {
            logger.warn(WARNING_NO_PREFIX_PATHS);
            return operator;
        }
        List<Path> prefixPaths = from.getPrefixPaths();
        if (prefixPaths.isEmpty()) {
            logger.warn(WARNING_NO_PREFIX_PATHS);
            return operator;
        }
        SelectOperator select = sfwOperator.getSelectOperator();
        if (select == null) {
            logger.warn(WARNING_NO_SUFFIX_PATHS);
            return operator;
        }
        List<Path> initialSuffixPaths = select.getSuffixPaths();
        if (initialSuffixPaths.isEmpty()) {
            logger.warn(WARNING_NO_SUFFIX_PATHS);
            return operator;
        }
        this.checkAggrOfSelectOperator(select);
        boolean isAlignByDevice = false;
        if (operator instanceof QueryOperator) {
            if (!((QueryOperator)operator).isAlignByDevice() || ((QueryOperator)operator).isLastQuery()) {
                this.concatSelect(prefixPaths, select);
                if (((QueryOperator)operator).hasSlimit()) {
                    int seriesLimit = ((QueryOperator)operator).getSeriesLimit();
                    int seriesOffset = ((QueryOperator)operator).getSeriesOffset();
                    this.slimitTrim(select, seriesLimit, seriesOffset);
                }
            } else {
                isAlignByDevice = true;
                for (Path path : initialSuffixPaths) {
                    String device = path.getDevice();
                    if (device.isEmpty()) continue;
                    throw new LogicalOptimizeException("The paths of the SELECT clause can only be single level. In other words, the paths of the SELECT clause can only be measurements or STAR, without DOT. For more details please refer to the SQL document.");
                }
            }
        }
        FilterOperator filter = sfwOperator.getFilterOperator();
        HashSet<Path> filterPaths = new HashSet<Path>();
        if (filter == null) {
            return operator;
        }
        if (!isAlignByDevice) {
            sfwOperator.setFilterOperator(this.concatFilter(prefixPaths, filter, filterPaths));
        }
        sfwOperator.getFilterOperator().setPathSet(filterPaths);
        return sfwOperator;
    }

    private List<Path> judgeSelectOperator(SelectOperator selectOperator) throws LogicalOptimizeException {
        if (selectOperator == null) {
            throw new LogicalOptimizeException(WARNING_NO_SUFFIX_PATHS);
        }
        List<Path> suffixPaths = selectOperator.getSuffixPaths();
        if (suffixPaths.isEmpty()) {
            throw new LogicalOptimizeException(WARNING_NO_SUFFIX_PATHS);
        }
        return suffixPaths;
    }

    private void checkAggrOfSelectOperator(SelectOperator selectOperator) throws LogicalOptimizeException {
        if (!selectOperator.getAggregations().isEmpty() && selectOperator.getSuffixPaths().size() != selectOperator.getAggregations().size()) {
            throw new LogicalOptimizeException("Common queries and aggregated queries are not allowed to appear at the same time");
        }
    }

    private void extendListSafely(List<String> source, int index, List<String> target) {
        if (source != null && !source.isEmpty()) {
            target.add(source.get(index));
        }
    }

    private void concatSelect(List<Path> fromPaths, SelectOperator selectOperator) throws LogicalOptimizeException {
        List<Path> suffixPaths = this.judgeSelectOperator(selectOperator);
        ArrayList<Path> allPaths = new ArrayList<Path>();
        List<String> originAggregations = selectOperator.getAggregations();
        ArrayList<String> afterConcatAggregations = new ArrayList<String>();
        for (int i = 0; i < suffixPaths.size(); ++i) {
            Path selectPath = suffixPaths.get(i);
            for (Path fromPath : fromPaths) {
                allPaths.add(Path.addPrefixPath((Path)selectPath, (Path)fromPath));
                this.extendListSafely(originAggregations, i, afterConcatAggregations);
            }
        }
        this.removeStarsInPath(allPaths, afterConcatAggregations, selectOperator);
    }

    private void slimitTrim(SelectOperator select, int seriesLimit, int seriesOffset) throws LogicalOptimizeException {
        List<Path> suffixList = select.getSuffixPaths();
        List<String> aggregations = select.getAggregations();
        int size = suffixList.size();
        if (seriesOffset >= size) {
            throw new LogicalOptimizeException("SOFFSET <SOFFSETValue>: SOFFSETValue exceeds the range.");
        }
        int endPosition = seriesOffset + seriesLimit;
        if (endPosition > size) {
            endPosition = size;
        }
        ArrayList<Path> trimedSuffixList = new ArrayList<Path>(suffixList.subList(seriesOffset, endPosition));
        select.setSuffixPathList(trimedSuffixList);
        if (aggregations != null && !aggregations.isEmpty()) {
            ArrayList<String> trimedAggregations = new ArrayList<String>(aggregations.subList(seriesOffset, endPosition));
            select.setAggregations(trimedAggregations);
        }
    }

    private FilterOperator concatFilter(List<Path> fromPaths, FilterOperator operator, Set<Path> filterPaths) throws LogicalOptimizeException {
        if (!operator.isLeaf()) {
            ArrayList<FilterOperator> newFilterList = new ArrayList<FilterOperator>();
            for (FilterOperator child : operator.getChildren()) {
                newFilterList.add(this.concatFilter(fromPaths, child, filterPaths));
            }
            operator.setChildren(newFilterList);
            return operator;
        }
        FunctionOperator functionOperator = (FunctionOperator)operator;
        Path filterPath = functionOperator.getSinglePath();
        if (SQLConstant.isReservedPath(filterPath) || filterPath.startWith("root")) {
            filterPaths.add(filterPath);
            return operator;
        }
        ArrayList<Path> concatPaths = new ArrayList<Path>();
        fromPaths.forEach(fromPath -> concatPaths.add(Path.addPrefixPath((Path)filterPath, (Path)fromPath)));
        List<Path> noStarPaths = this.removeStarsInPathWithUnique(concatPaths);
        filterPaths.addAll(noStarPaths);
        if (noStarPaths.size() == 1) {
            functionOperator.setSinglePath(noStarPaths.get(0));
            return operator;
        }
        return this.constructBinaryFilterTreeWithAnd(noStarPaths, operator);
    }

    private FilterOperator constructBinaryFilterTreeWithAnd(List<Path> noStarPaths, FilterOperator operator) throws LogicalOptimizeException {
        FilterOperator filterBinaryTree;
        FilterOperator currentNode = filterBinaryTree = new FilterOperator(1);
        for (int i = 0; i < noStarPaths.size(); ++i) {
            if (i > 0 && i < noStarPaths.size() - 1) {
                FilterOperator newInnerNode = new FilterOperator(1);
                currentNode.addChildOperator(newInnerNode);
                currentNode = newInnerNode;
            }
            try {
                currentNode.addChildOperator(new BasicFunctionOperator(operator.getTokenIntType(), noStarPaths.get(i), ((BasicFunctionOperator)operator).getValue()));
                continue;
            }
            catch (SQLParserException e) {
                throw new LogicalOptimizeException(e.getMessage());
            }
        }
        return filterBinaryTree;
    }

    private List<Path> removeStarsInPathWithUnique(List<Path> paths) throws LogicalOptimizeException {
        ArrayList<Path> retPaths = new ArrayList<Path>();
        HashSet<String> pathSet = new HashSet<String>();
        try {
            for (Path path : paths) {
                List<Path> all = this.removeWildcard(path.getFullPath());
                for (Path subPath : all) {
                    if (pathSet.contains(subPath.getFullPath())) continue;
                    pathSet.add(subPath.getFullPath());
                    retPaths.add(subPath);
                }
            }
        }
        catch (MetadataException e) {
            throw new LogicalOptimizeException("error when remove star: " + e.getMessage());
        }
        return retPaths;
    }

    private void removeStarsInPath(List<Path> paths, List<String> afterConcatAggregations, SelectOperator selectOperator) throws LogicalOptimizeException {
        ArrayList<Path> retPaths = new ArrayList<Path>();
        ArrayList<String> newAggregations = new ArrayList<String>();
        for (int i = 0; i < paths.size(); ++i) {
            try {
                List<Path> actualPaths = this.removeWildcard(paths.get(i).getFullPath());
                for (Path actualPath : actualPaths) {
                    retPaths.add(actualPath);
                    if (afterConcatAggregations == null || afterConcatAggregations.isEmpty()) continue;
                    newAggregations.add(afterConcatAggregations.get(i));
                }
                continue;
            }
            catch (MetadataException e) {
                throw new LogicalOptimizeException("error when remove star: " + e.getMessage());
            }
        }
        selectOperator.setSuffixPathList(retPaths);
        selectOperator.setAggregations(newAggregations);
    }

    protected List<Path> removeWildcard(String path) throws MetadataException {
        return MManager.getInstance().getAllTimeseriesPath(path);
    }
}

