/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.aggregation.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.db.query.aggregation.AggregateResult;
import org.apache.iotdb.db.query.aggregation.AggregationType;
import org.apache.iotdb.db.query.reader.series.IReaderByTimestamp;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class LastValueAggrResult
extends AggregateResult {
    private long timestamp = Long.MIN_VALUE;

    public LastValueAggrResult(TSDataType dataType) {
        super(dataType, AggregationType.LAST_VALUE);
        this.reset();
    }

    @Override
    public void reset() {
        super.reset();
        this.timestamp = Long.MIN_VALUE;
    }

    @Override
    public Object getResult() {
        return this.hasResult() ? this.getValue() : null;
    }

    @Override
    public void updateResultFromStatistics(Statistics statistics) {
        Object lastVal = statistics.getLastValue();
        this.setValue(lastVal);
        this.timestamp = statistics.getEndTime();
    }

    @Override
    public void updateResultFromPageData(BatchData dataInThisPage) {
        this.updateResultFromPageData(dataInThisPage, Long.MAX_VALUE);
    }

    @Override
    public void updateResultFromPageData(BatchData dataInThisPage, long bound) {
        long time = Long.MIN_VALUE;
        Object lastVal = null;
        while (dataInThisPage.hasCurrent() && dataInThisPage.currentTime() < bound) {
            time = dataInThisPage.currentTime();
            lastVal = dataInThisPage.currentValue();
            dataInThisPage.next();
        }
        if (time != Long.MIN_VALUE) {
            this.setValue(lastVal);
            this.timestamp = time;
        }
    }

    @Override
    public void updateResultUsingTimestamps(long[] timestamps, int length, IReaderByTimestamp dataReader) throws IOException {
        long time = Long.MIN_VALUE;
        Object lastVal = null;
        for (int i = 0; i < length; ++i) {
            Object value = dataReader.getValueInTimestamp(timestamps[i]);
            if (value == null) continue;
            time = timestamps[i];
            lastVal = value;
        }
        if (time != Long.MIN_VALUE) {
            this.setValue(lastVal);
            this.timestamp = time;
        }
    }

    @Override
    public boolean isCalculatedAggregationResult() {
        return false;
    }

    @Override
    public void merge(AggregateResult another) {
        LastValueAggrResult anotherLast = (LastValueAggrResult)another;
        if (this.getValue() == null || this.timestamp < anotherLast.timestamp) {
            this.setValue(anotherLast.getValue());
            this.timestamp = anotherLast.timestamp;
        }
    }

    @Override
    protected void deserializeSpecificFields(ByteBuffer buffer) {
        this.timestamp = buffer.getLong();
    }

    @Override
    protected void serializeSpecificFields(OutputStream outputStream) throws IOException {
        ReadWriteIOUtils.write((long)this.timestamp, (OutputStream)outputStream);
    }
}

