/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.aggregation.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.db.query.aggregation.AggregateResult;
import org.apache.iotdb.db.query.aggregation.AggregationType;
import org.apache.iotdb.db.query.reader.series.IReaderByTimestamp;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.BatchData;

public class MaxValueAggrResult
extends AggregateResult {
    public MaxValueAggrResult(TSDataType dataType) {
        super(dataType, AggregationType.MAX_VALUE);
        this.reset();
    }

    @Override
    public Object getResult() {
        return this.hasResult() ? this.getValue() : null;
    }

    @Override
    public void updateResultFromStatistics(Statistics statistics) {
        Comparable maxVal = (Comparable)statistics.getMaxValue();
        this.updateResult(maxVal);
    }

    @Override
    public void updateResultFromPageData(BatchData dataInThisPage) {
        this.updateResultFromPageData(dataInThisPage, Long.MAX_VALUE);
    }

    @Override
    public void updateResultFromPageData(BatchData dataInThisPage, long bound) {
        Comparable maxVal = null;
        while (dataInThisPage.hasCurrent() && dataInThisPage.currentTime() < bound) {
            if (maxVal == null || maxVal.compareTo(dataInThisPage.currentValue()) < 0) {
                maxVal = (Comparable)dataInThisPage.currentValue();
            }
            dataInThisPage.next();
        }
        this.updateResult(maxVal);
    }

    @Override
    public void updateResultUsingTimestamps(long[] timestamps, int length, IReaderByTimestamp dataReader) throws IOException {
        Comparable maxVal = null;
        for (int i = 0; i < length; ++i) {
            Object value = dataReader.getValueInTimestamp(timestamps[i]);
            if (value == null || maxVal != null && maxVal.compareTo(value) >= 0) continue;
            maxVal = (Comparable)value;
        }
        this.updateResult(maxVal);
    }

    @Override
    public boolean isCalculatedAggregationResult() {
        return false;
    }

    @Override
    public void merge(AggregateResult another) {
        this.updateResult((Comparable)another.getResult());
    }

    @Override
    protected void deserializeSpecificFields(ByteBuffer buffer) {
    }

    @Override
    protected void serializeSpecificFields(OutputStream outputStream) throws IOException {
    }

    private void updateResult(Comparable<Object> maxVal) {
        if (maxVal == null) {
            return;
        }
        if (!this.hasResult() || maxVal.compareTo(this.getValue()) > 0) {
            this.setValue(maxVal);
        }
    }
}

