/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.control;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.db.engine.querycontext.QueryDataSource;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.query.control.FileReaderManager;

public class QueryFileManager {
    private Map<Long, Set<TsFileResource>> sealedFilePathsMap = new ConcurrentHashMap<Long, Set<TsFileResource>>();
    private Map<Long, Set<TsFileResource>> unsealedFilePathsMap = new ConcurrentHashMap<Long, Set<TsFileResource>>();

    QueryFileManager() {
    }

    void addQueryId(long queryId) {
        this.sealedFilePathsMap.computeIfAbsent(queryId, x -> new HashSet());
        this.unsealedFilePathsMap.computeIfAbsent(queryId, x -> new HashSet());
    }

    public void addUsedFilesForQuery(long queryId, QueryDataSource dataSource) {
        this.addUsedFilesForQuery(queryId, dataSource.getSeqResources());
        this.addUsedFilesForQuery(queryId, dataSource.getUnseqResources());
    }

    private void addUsedFilesForQuery(long queryId, List<TsFileResource> resources) {
        Iterator<TsFileResource> iterator = resources.iterator();
        while (iterator.hasNext()) {
            Map<Long, Set<TsFileResource>> pathMap;
            TsFileResource tsFileResource = iterator.next();
            boolean isClosed = tsFileResource.isClosed();
            this.addFilePathToMap(queryId, tsFileResource, isClosed);
            if (!tsFileResource.isDeleted()) continue;
            Map<Long, Set<TsFileResource>> map = pathMap = !isClosed ? this.unsealedFilePathsMap : this.sealedFilePathsMap;
            if (pathMap.get(queryId).remove(tsFileResource)) {
                FileReaderManager.getInstance().decreaseFileReaderReference(tsFileResource, isClosed);
            }
            iterator.remove();
        }
    }

    void removeUsedFilesForQuery(long queryId) {
        Set<TsFileResource> tsFiles = this.sealedFilePathsMap.get(queryId);
        if (tsFiles != null) {
            for (TsFileResource tsFile : tsFiles) {
                FileReaderManager.getInstance().decreaseFileReaderReference(tsFile, true);
            }
            this.sealedFilePathsMap.remove(queryId);
        }
        if ((tsFiles = this.unsealedFilePathsMap.get(queryId)) != null) {
            for (TsFileResource tsFile : tsFiles) {
                FileReaderManager.getInstance().decreaseFileReaderReference(tsFile, false);
            }
            this.unsealedFilePathsMap.remove(queryId);
        }
    }

    void addFilePathToMap(long queryId, TsFileResource tsFile, boolean isClosed) {
        Map<Long, Set<TsFileResource>> pathMap;
        Map<Long, Set<TsFileResource>> map = pathMap = isClosed ? this.sealedFilePathsMap : this.unsealedFilePathsMap;
        if (!pathMap.get(queryId).contains(tsFile)) {
            pathMap.get(queryId).add(tsFile);
            FileReaderManager.getInstance().increaseFileReaderReference(tsFile, isClosed);
        }
    }
}

