/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.dataset;

import java.io.IOException;
import java.util.List;
import org.apache.iotdb.db.query.reader.series.IReaderByTimestamp;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;
import org.apache.iotdb.tsfile.read.query.timegenerator.TimeGenerator;

public class RawQueryDataSetWithValueFilter
extends QueryDataSet {
    private TimeGenerator timeGenerator;
    private List<IReaderByTimestamp> seriesReaderByTimestampList;
    private boolean hasCachedRowRecord;
    private RowRecord cachedRowRecord;
    private List<Boolean> cached;

    public RawQueryDataSetWithValueFilter(List<Path> paths, List<TSDataType> dataTypes, TimeGenerator timeGenerator, List<IReaderByTimestamp> readers, List<Boolean> cached) {
        super(paths, dataTypes);
        this.timeGenerator = timeGenerator;
        this.seriesReaderByTimestampList = readers;
        this.cached = cached;
    }

    protected boolean hasNextWithoutConstraint() throws IOException {
        if (this.hasCachedRowRecord) {
            return true;
        }
        return this.cacheRowRecord();
    }

    protected RowRecord nextWithoutConstraint() throws IOException {
        if (!this.hasCachedRowRecord && !this.cacheRowRecord()) {
            return null;
        }
        this.hasCachedRowRecord = false;
        return this.cachedRowRecord;
    }

    private boolean cacheRowRecord() throws IOException {
        while (this.timeGenerator.hasNext()) {
            boolean hasField = false;
            long timestamp = this.timeGenerator.next();
            RowRecord rowRecord = new RowRecord(timestamp);
            for (int i = 0; i < this.seriesReaderByTimestampList.size(); ++i) {
                Object value;
                if (this.cached.get(i).booleanValue()) {
                    value = this.timeGenerator.getValue((Path)this.paths.get(i), timestamp);
                } else {
                    IReaderByTimestamp reader = this.seriesReaderByTimestampList.get(i);
                    value = reader.getValueInTimestamp(timestamp);
                }
                if (value == null) {
                    rowRecord.addField(null);
                    continue;
                }
                hasField = true;
                rowRecord.addField(value, (TSDataType)this.dataTypes.get(i));
            }
            if (!hasField) continue;
            this.hasCachedRowRecord = true;
            this.cachedRowRecord = rowRecord;
            break;
        }
        return this.hasCachedRowRecord;
    }
}

