/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.dataset.groupby;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.qp.physical.crud.GroupByFillPlan;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.dataset.groupby.GroupByEngineDataSet;
import org.apache.iotdb.db.query.executor.LastQueryExecutor;
import org.apache.iotdb.db.query.executor.fill.IFill;
import org.apache.iotdb.db.query.executor.fill.PreviousFill;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.common.Field;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;

public class GroupByFillDataSet
extends QueryDataSet {
    private GroupByEngineDataSet groupByEngineDataSet;
    private Map<TSDataType, IFill> fillTypes;
    private Object[] previousValue;
    private long[] lastTimeArray;

    public GroupByFillDataSet(List<Path> paths, List<TSDataType> dataTypes, GroupByEngineDataSet groupByEngineDataSet, Map<TSDataType, IFill> fillTypes, QueryContext context, GroupByFillPlan groupByFillPlan) throws StorageEngineException, IOException, QueryProcessException {
        super(paths, dataTypes);
        this.groupByEngineDataSet = groupByEngineDataSet;
        this.fillTypes = fillTypes;
        this.initPreviousParis(context, groupByFillPlan);
        this.initLastTimeArray(context, groupByFillPlan);
    }

    private void initPreviousParis(QueryContext context, GroupByFillPlan groupByFillPlan) throws StorageEngineException, IOException, QueryProcessException {
        this.previousValue = new Object[this.paths.size()];
        for (int i = 0; i < this.paths.size(); ++i) {
            Path path = (Path)this.paths.get(i);
            TSDataType dataType = (TSDataType)this.dataTypes.get(i);
            PreviousFill fill = this.fillTypes.containsKey(dataType) ? new PreviousFill(dataType, this.groupByEngineDataSet.getStartTime(), ((PreviousFill)this.fillTypes.get(dataType)).getBeforeRange(), ((PreviousFill)this.fillTypes.get(dataType)).isUntilLast()) : new PreviousFill(dataType, this.groupByEngineDataSet.getStartTime(), IoTDBDescriptor.getInstance().getConfig().getDefaultFillInterval());
            ((IFill)fill).configureFill(path, dataType, this.groupByEngineDataSet.getStartTime(), groupByFillPlan.getAllMeasurementsInDevice(path.getDevice()), context);
            TimeValuePair timeValuePair = ((IFill)fill).getFillResult();
            this.previousValue[i] = timeValuePair == null || timeValuePair.getValue() == null ? null : timeValuePair.getValue().getValue();
        }
    }

    private void initLastTimeArray(QueryContext context, GroupByFillPlan groupByFillPlan) throws IOException, StorageEngineException, QueryProcessException {
        this.lastTimeArray = new long[this.paths.size()];
        Arrays.fill(this.lastTimeArray, Long.MAX_VALUE);
        for (int i = 0; i < this.paths.size(); ++i) {
            TimeValuePair lastTimeValuePair = LastQueryExecutor.calculateLastPairForOneSeries((Path)this.paths.get(i), (TSDataType)this.dataTypes.get(i), context, groupByFillPlan.getAllMeasurementsInDevice(((Path)this.paths.get(i)).getDevice()));
            if (lastTimeValuePair.getValue() == null) continue;
            this.lastTimeArray[i] = lastTimeValuePair.getTimestamp();
        }
    }

    protected boolean hasNextWithoutConstraint() {
        return this.groupByEngineDataSet.hasNextWithoutConstraint();
    }

    protected RowRecord nextWithoutConstraint() throws IOException {
        RowRecord rowRecord = this.groupByEngineDataSet.nextWithoutConstraint();
        for (int i = 0; i < this.paths.size(); ++i) {
            Field field = (Field)rowRecord.getFields().get(i);
            if (field == null || field.getDataType() == null) {
                if (this.previousValue[i] == null || (!this.fillTypes.containsKey(this.dataTypes.get(i)) || ((PreviousFill)this.fillTypes.get(this.dataTypes.get(i))).isUntilLast()) && rowRecord.getTimestamp() > this.lastTimeArray[i] || this.fillTypes.containsKey(this.dataTypes.get(i)) && ((PreviousFill)this.fillTypes.get(this.dataTypes.get(i))).getBeforeRange() >= 0L && ((PreviousFill)this.fillTypes.get(this.dataTypes.get(i))).getBeforeRange() < this.groupByEngineDataSet.interval) continue;
                rowRecord.getFields().set(i, Field.getField((Object)this.previousValue[i], (TSDataType)((TSDataType)this.dataTypes.get(i))));
                continue;
            }
            this.previousValue[i] = field.getObjectValue(field.getDataType());
        }
        return rowRecord;
    }
}

