/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.executor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.querycontext.QueryDataSource;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.qp.physical.crud.AggregationPlan;
import org.apache.iotdb.db.qp.physical.crud.RawDataQueryPlan;
import org.apache.iotdb.db.query.aggregation.AggregateResult;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.control.QueryResourceManager;
import org.apache.iotdb.db.query.dataset.SingleDataSet;
import org.apache.iotdb.db.query.factory.AggregateResultFactory;
import org.apache.iotdb.db.query.filter.TsFileFilter;
import org.apache.iotdb.db.query.reader.series.IAggregateReader;
import org.apache.iotdb.db.query.reader.series.IReaderByTimestamp;
import org.apache.iotdb.db.query.reader.series.SeriesAggregateReader;
import org.apache.iotdb.db.query.reader.series.SeriesReaderByTimestamp;
import org.apache.iotdb.db.query.timegenerator.ServerTimeGenerator;
import org.apache.iotdb.db.utils.QueryUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.iotdb.tsfile.read.expression.IExpression;
import org.apache.iotdb.tsfile.read.expression.impl.GlobalTimeExpression;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;
import org.apache.iotdb.tsfile.read.query.timegenerator.TimeGenerator;

public class AggregationExecutor {
    private List<Path> selectedSeries;
    protected List<TSDataType> dataTypes;
    protected List<String> aggregations;
    protected IExpression expression;
    private int aggregateFetchSize;

    protected AggregationExecutor(AggregationPlan aggregationPlan) {
        this.selectedSeries = aggregationPlan.getDeduplicatedPaths();
        this.dataTypes = aggregationPlan.getDeduplicatedDataTypes();
        this.aggregations = aggregationPlan.getDeduplicatedAggregations();
        this.expression = aggregationPlan.getExpression();
        this.aggregateFetchSize = IoTDBDescriptor.getInstance().getConfig().getBatchSize();
    }

    public QueryDataSet executeWithoutValueFilter(QueryContext context, AggregationPlan aggregationPlan) throws StorageEngineException, IOException, QueryProcessException {
        Filter timeFilter = null;
        if (this.expression != null) {
            timeFilter = ((GlobalTimeExpression)this.expression).getFilter();
        }
        Map<Path, List<Integer>> pathToAggrIndexesMap = this.groupAggregationsBySeries(this.selectedSeries);
        AggregateResult[] aggregateResultList = new AggregateResult[this.selectedSeries.size()];
        for (Map.Entry<Path, List<Integer>> entry : pathToAggrIndexesMap.entrySet()) {
            List<AggregateResult> aggregateResults = this.aggregateOneSeries(entry, aggregationPlan.getAllMeasurementsInDevice(entry.getKey().getDevice()), timeFilter, context);
            int index = 0;
            for (int i : entry.getValue()) {
                aggregateResultList[i] = aggregateResults.get(index);
                ++index;
            }
        }
        return this.constructDataSet(Arrays.asList(aggregateResultList));
    }

    protected List<AggregateResult> aggregateOneSeries(Map.Entry<Path, List<Integer>> pathToAggrIndexes, Set<String> measurements, Filter timeFilter, QueryContext context) throws IOException, QueryProcessException, StorageEngineException {
        ArrayList<AggregateResult> aggregateResultList = new ArrayList<AggregateResult>();
        Path seriesPath = pathToAggrIndexes.getKey();
        TSDataType tsDataType = this.dataTypes.get(pathToAggrIndexes.getValue().get(0));
        for (int i : pathToAggrIndexes.getValue()) {
            AggregateResult aggregateResult = AggregateResultFactory.getAggrResultByName(this.aggregations.get(i), tsDataType);
            aggregateResultList.add(aggregateResult);
        }
        AggregationExecutor.aggregateOneSeries(seriesPath, measurements, context, timeFilter, tsDataType, aggregateResultList, null);
        return aggregateResultList;
    }

    public static void aggregateOneSeries(Path seriesPath, Set<String> measurements, QueryContext context, Filter timeFilter, TSDataType tsDataType, List<AggregateResult> aggregateResultList, TsFileFilter fileFilter) throws StorageEngineException, IOException, QueryProcessException {
        QueryDataSource queryDataSource = QueryResourceManager.getInstance().getQueryDataSource(seriesPath, context, timeFilter);
        if (fileFilter != null) {
            QueryUtils.filterQueryDataSource(queryDataSource, fileFilter);
        }
        timeFilter = queryDataSource.updateFilterUsingTTL(timeFilter);
        SeriesAggregateReader seriesReader = new SeriesAggregateReader(seriesPath, measurements, tsDataType, context, queryDataSource, timeFilter, null, null);
        AggregationExecutor.aggregateFromReader(seriesReader, aggregateResultList);
    }

    private static void aggregateFromReader(IAggregateReader seriesReader, List<AggregateResult> aggregateResultList) throws QueryProcessException, IOException {
        int remainingToCalculate = aggregateResultList.size();
        boolean[] isCalculatedArray = new boolean[aggregateResultList.size()];
        while (seriesReader.hasNextFile()) {
            if (seriesReader.canUseCurrentFileStatistics()) {
                Statistics fileStatistics = seriesReader.currentFileStatistics();
                if ((remainingToCalculate = AggregationExecutor.aggregateStatistics(aggregateResultList, isCalculatedArray, remainingToCalculate, fileStatistics)) == 0) {
                    return;
                }
                seriesReader.skipCurrentFile();
                continue;
            }
            while (seriesReader.hasNextChunk()) {
                if (seriesReader.canUseCurrentChunkStatistics()) {
                    Statistics chunkStatistics = seriesReader.currentChunkStatistics();
                    if ((remainingToCalculate = AggregationExecutor.aggregateStatistics(aggregateResultList, isCalculatedArray, remainingToCalculate, chunkStatistics)) == 0) {
                        return;
                    }
                    seriesReader.skipCurrentChunk();
                    continue;
                }
                if ((remainingToCalculate = AggregationExecutor.aggregatePages(seriesReader, aggregateResultList, isCalculatedArray, remainingToCalculate)) != 0) continue;
                return;
            }
        }
    }

    private static int aggregateStatistics(List<AggregateResult> aggregateResultList, boolean[] isCalculatedArray, int remainingToCalculate, Statistics statistics) throws QueryProcessException {
        int newRemainingToCalculate = remainingToCalculate;
        for (int i = 0; i < aggregateResultList.size(); ++i) {
            if (isCalculatedArray[i]) continue;
            AggregateResult aggregateResult = aggregateResultList.get(i);
            aggregateResult.updateResultFromStatistics(statistics);
            if (!aggregateResult.isCalculatedAggregationResult()) continue;
            isCalculatedArray[i] = true;
            if (--newRemainingToCalculate != 0) continue;
            return newRemainingToCalculate;
        }
        return newRemainingToCalculate;
    }

    private static int aggregatePages(IAggregateReader seriesReader, List<AggregateResult> aggregateResultList, boolean[] isCalculatedArray, int remainingToCalculate) throws IOException, QueryProcessException {
        while (seriesReader.hasNextPage()) {
            if (seriesReader.canUseCurrentPageStatistics()) {
                Statistics pageStatistic = seriesReader.currentPageStatistics();
                if ((remainingToCalculate = AggregationExecutor.aggregateStatistics(aggregateResultList, isCalculatedArray, remainingToCalculate, pageStatistic)) == 0) {
                    return 0;
                }
                seriesReader.skipCurrentPage();
                continue;
            }
            BatchData nextOverlappedPageData = seriesReader.nextPage();
            for (int i = 0; i < aggregateResultList.size(); ++i) {
                if (isCalculatedArray[i]) continue;
                AggregateResult aggregateResult = aggregateResultList.get(i);
                aggregateResult.updateResultFromPageData(nextOverlappedPageData);
                nextOverlappedPageData.resetBatchData();
                if (!aggregateResult.isCalculatedAggregationResult()) continue;
                isCalculatedArray[i] = true;
                if (--remainingToCalculate != 0) continue;
                return 0;
            }
        }
        return remainingToCalculate;
    }

    public QueryDataSet executeWithValueFilter(QueryContext context, RawDataQueryPlan queryPlan) throws StorageEngineException, IOException, QueryProcessException {
        TimeGenerator timestampGenerator = this.getTimeGenerator(context, queryPlan);
        ArrayList<IReaderByTimestamp> readersOfSelectedSeries = new ArrayList<IReaderByTimestamp>();
        for (int i = 0; i < this.selectedSeries.size(); ++i) {
            Path path = this.selectedSeries.get(i);
            IReaderByTimestamp seriesReaderByTimestamp = this.getReaderByTime(path, queryPlan, this.dataTypes.get(i), context);
            readersOfSelectedSeries.add(seriesReaderByTimestamp);
        }
        ArrayList<AggregateResult> aggregateResults = new ArrayList<AggregateResult>();
        for (int i = 0; i < this.selectedSeries.size(); ++i) {
            TSDataType type = this.dataTypes.get(i);
            AggregateResult result = AggregateResultFactory.getAggrResultByName(this.aggregations.get(i), type);
            aggregateResults.add(result);
        }
        this.aggregateWithValueFilter(aggregateResults, timestampGenerator, readersOfSelectedSeries);
        return this.constructDataSet(aggregateResults);
    }

    protected TimeGenerator getTimeGenerator(QueryContext context, RawDataQueryPlan queryPlan) throws StorageEngineException {
        return new ServerTimeGenerator(this.expression, context, queryPlan);
    }

    protected IReaderByTimestamp getReaderByTime(Path path, RawDataQueryPlan queryPlan, TSDataType dataType, QueryContext context) throws StorageEngineException, QueryProcessException {
        return new SeriesReaderByTimestamp(path, queryPlan.getAllMeasurementsInDevice(path.getDevice()), dataType, context, QueryResourceManager.getInstance().getQueryDataSource(path, context, null), null);
    }

    private void aggregateWithValueFilter(List<AggregateResult> aggregateResults, TimeGenerator timestampGenerator, List<IReaderByTimestamp> readersOfSelectedSeries) throws IOException {
        while (timestampGenerator.hasNext()) {
            long[] timeArray = new long[this.aggregateFetchSize];
            int timeArrayLength = 0;
            for (int cnt = 0; cnt < this.aggregateFetchSize && timestampGenerator.hasNext(); ++cnt) {
                timeArray[timeArrayLength++] = timestampGenerator.next();
            }
            for (int i = 0; i < readersOfSelectedSeries.size(); ++i) {
                aggregateResults.get(i).updateResultUsingTimestamps(timeArray, timeArrayLength, readersOfSelectedSeries.get(i));
            }
        }
    }

    private QueryDataSet constructDataSet(List<AggregateResult> aggregateResultList) {
        RowRecord record = new RowRecord(0L);
        for (AggregateResult resultData : aggregateResultList) {
            TSDataType dataType = resultData.getResultDataType();
            record.addField(resultData.getResult(), dataType);
        }
        SingleDataSet dataSet = new SingleDataSet(this.selectedSeries, this.dataTypes);
        dataSet.setRecord(record);
        return dataSet;
    }

    private Map<Path, List<Integer>> groupAggregationsBySeries(List<Path> selectedSeries) {
        HashMap<Path, List<Integer>> pathToAggrIndexesMap = new HashMap<Path, List<Integer>>();
        for (int i = 0; i < selectedSeries.size(); ++i) {
            Path series = selectedSeries.get(i);
            List indexList = pathToAggrIndexesMap.computeIfAbsent(series, key -> new ArrayList());
            indexList.add(i);
        }
        return pathToAggrIndexesMap;
    }
}

