/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.executor;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.iotdb.db.engine.querycontext.QueryDataSource;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.MManager;
import org.apache.iotdb.db.metadata.mnode.LeafMNode;
import org.apache.iotdb.db.qp.physical.crud.LastQueryPlan;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.control.QueryResourceManager;
import org.apache.iotdb.db.query.dataset.ListDataSet;
import org.apache.iotdb.db.utils.FileLoaderUtils;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.common.Field;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;

public class LastQueryExecutor {
    private List<Path> selectedSeries;
    private List<TSDataType> dataTypes;

    public LastQueryExecutor(LastQueryPlan lastQueryPlan) {
        this.selectedSeries = lastQueryPlan.getDeduplicatedPaths();
        this.dataTypes = lastQueryPlan.getDeduplicatedDataTypes();
    }

    public LastQueryExecutor(List<Path> selectedSeries, List<TSDataType> dataTypes) {
        this.selectedSeries = selectedSeries;
        this.dataTypes = dataTypes;
    }

    public QueryDataSet execute(QueryContext context, LastQueryPlan lastQueryPlan) throws StorageEngineException, IOException, QueryProcessException {
        ListDataSet dataSet = new ListDataSet(Arrays.asList(new Path("timeseries"), new Path("value")), Arrays.asList(TSDataType.TEXT, TSDataType.TEXT));
        for (int i = 0; i < this.selectedSeries.size(); ++i) {
            TimeValuePair lastTimeValuePair = LastQueryExecutor.calculateLastPairForOneSeries(this.selectedSeries.get(i), this.dataTypes.get(i), context, lastQueryPlan.getAllMeasurementsInDevice(this.selectedSeries.get(i).getDevice()));
            if (lastTimeValuePair.getValue() == null) continue;
            RowRecord resultRecord = new RowRecord(lastTimeValuePair.getTimestamp());
            Field pathField = new Field(TSDataType.TEXT);
            if (this.selectedSeries.get(i).getAlias() != null) {
                pathField.setBinaryV(new Binary(this.selectedSeries.get(i).getFullPathWithAlias()));
            } else {
                pathField.setBinaryV(new Binary(this.selectedSeries.get(i).getFullPath()));
            }
            resultRecord.addField(pathField);
            Field valueField = new Field(TSDataType.TEXT);
            valueField.setBinaryV(new Binary(lastTimeValuePair.getValue().getStringValue()));
            resultRecord.addField(valueField);
            dataSet.putRecord(resultRecord);
        }
        return dataSet;
    }

    public static TimeValuePair calculateLastPairForOneSeries(Path seriesPath, TSDataType tsDataType, QueryContext context, Set<String> sensors) throws IOException, QueryProcessException, StorageEngineException {
        LeafMNode node;
        try {
            node = (LeafMNode)MManager.getInstance().getNodeByPath(seriesPath.toString());
        }
        catch (MetadataException e) {
            throw new QueryProcessException(e);
        }
        if (node.getCachedLast() != null) {
            return node.getCachedLast();
        }
        QueryDataSource dataSource = QueryResourceManager.getInstance().getQueryDataSource(seriesPath, context, null);
        List<TsFileResource> seqFileResources = dataSource.getSeqResources();
        List<TsFileResource> unseqFileResources = dataSource.getUnseqResources();
        TimeValuePair resultPair = new TimeValuePair(Long.MIN_VALUE, null);
        if (!seqFileResources.isEmpty()) {
            for (int i = seqFileResources.size() - 1; i >= 0; --i) {
                TimeseriesMetadata timeseriesMetadata = FileLoaderUtils.loadTimeSeriesMetadata(seqFileResources.get(i), seriesPath, context, null, sensors);
                if (timeseriesMetadata == null) continue;
                if (!timeseriesMetadata.isModified()) {
                    Statistics timeseriesMetadataStats = timeseriesMetadata.getStatistics();
                    resultPair = LastQueryExecutor.constructLastPair(timeseriesMetadataStats.getEndTime(), timeseriesMetadataStats.getLastValue(), tsDataType);
                    break;
                }
                List chunkMetadataList = timeseriesMetadata.loadChunkMetadataList();
                if (chunkMetadataList.isEmpty()) continue;
                ChunkMetadata lastChunkMetaData = (ChunkMetadata)chunkMetadataList.get(chunkMetadataList.size() - 1);
                Statistics chunkStatistics = lastChunkMetaData.getStatistics();
                resultPair = LastQueryExecutor.constructLastPair(chunkStatistics.getEndTime(), chunkStatistics.getLastValue(), tsDataType);
                break;
            }
        }
        long version = 0L;
        for (TsFileResource resource : unseqFileResources) {
            TimeseriesMetadata timeseriesMetadata;
            if (resource.getEndTime(seriesPath.getDevice()) < resultPair.getTimestamp() || (timeseriesMetadata = FileLoaderUtils.loadTimeSeriesMetadata(resource, seriesPath, context, null, sensors)) == null) continue;
            for (ChunkMetadata chunkMetaData : timeseriesMetadata.loadChunkMetadataList()) {
                if (chunkMetaData.getEndTime() <= resultPair.getTimestamp() && (chunkMetaData.getEndTime() != resultPair.getTimestamp() || chunkMetaData.getVersion() <= version)) continue;
                Statistics chunkStatistics = chunkMetaData.getStatistics();
                resultPair = LastQueryExecutor.constructLastPair(chunkStatistics.getEndTime(), chunkStatistics.getLastValue(), tsDataType);
                version = chunkMetaData.getVersion();
            }
        }
        node.updateCachedLast(resultPair, false, Long.MIN_VALUE);
        return resultPair;
    }

    private static TimeValuePair constructLastPair(long timestamp, Object value, TSDataType dataType) {
        return new TimeValuePair(timestamp, TsPrimitiveType.getByType((TSDataType)dataType, (Object)value));
    }
}

