/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.externalsort.serialize.impl;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.iotdb.db.query.externalsort.serialize.IExternalSortFileDeserializer;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.BytesUtils;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;

public class FixLengthIExternalSortFileDeserializer
implements IExternalSortFileDeserializer {
    private TimeValuePairReader reader;
    private InputStream inputStream;
    private String tmpFilePath;

    public FixLengthIExternalSortFileDeserializer(String tmpFilePath) throws IOException {
        this.tmpFilePath = tmpFilePath;
        this.inputStream = new BufferedInputStream(new FileInputStream(tmpFilePath));
        TSDataType dataType = this.readHeader();
        this.setReader(dataType);
    }

    public boolean hasNextTimeValuePair() throws IOException {
        return this.inputStream.available() > 0;
    }

    public TimeValuePair nextTimeValuePair() throws IOException {
        return this.reader.read(this.inputStream);
    }

    public void close() throws IOException {
        this.inputStream.close();
        File file = new File(this.tmpFilePath);
        if (!file.exists()) {
            return;
        }
        if (!file.delete()) {
            throw new IOException("Delete external sort tmp file error. FilePath:" + this.tmpFilePath);
        }
    }

    public String getTmpFilePath() {
        return this.tmpFilePath;
    }

    private TSDataType readHeader() throws IOException {
        return TSDataType.deserialize((short)ReadWriteIOUtils.readShort((InputStream)this.inputStream));
    }

    private void setReader(TSDataType type) {
        switch (type) {
            case BOOLEAN: {
                this.reader = new TimeValuePairReader.BooleanReader();
                break;
            }
            case INT32: {
                this.reader = new TimeValuePairReader.IntReader();
                break;
            }
            case INT64: {
                this.reader = new TimeValuePairReader.LongReader();
                break;
            }
            case FLOAT: {
                this.reader = new TimeValuePairReader.FloatReader();
                break;
            }
            case DOUBLE: {
                this.reader = new TimeValuePairReader.DoubleReader();
                break;
            }
            case TEXT: {
                this.reader = new TimeValuePairReader.BinaryReader();
                break;
            }
            default: {
                throw new RuntimeException("Unknown TSDataType in FixLengthTimeValuePairSerializer:" + type);
            }
        }
    }

    private static abstract class TimeValuePairReader {
        private TimeValuePairReader() {
        }

        public abstract TimeValuePair read(InputStream var1) throws IOException;

        private static class BinaryReader
        extends TimeValuePairReader {
            byte[] timestampBytes = new byte[8];
            byte[] valueLength = new byte[4];
            byte[] valueBytes;

            private BinaryReader() {
            }

            @Override
            public TimeValuePair read(InputStream inputStream) throws IOException {
                inputStream.read(this.timestampBytes);
                inputStream.read(this.valueLength);
                int length = BytesUtils.bytesToInt((byte[])this.valueLength);
                this.valueBytes = new byte[length];
                inputStream.read(this.valueBytes);
                return new TimeValuePair(BytesUtils.bytesToLong((byte[])this.timestampBytes), (TsPrimitiveType)new TsPrimitiveType.TsBinary(new Binary(BytesUtils.bytesToString((byte[])this.valueBytes))));
            }
        }

        private static class DoubleReader
        extends TimeValuePairReader {
            byte[] timestampBytes = new byte[8];
            byte[] valueBytes = new byte[8];

            private DoubleReader() {
            }

            @Override
            public TimeValuePair read(InputStream inputStream) throws IOException {
                inputStream.read(this.timestampBytes);
                inputStream.read(this.valueBytes);
                return new TimeValuePair(BytesUtils.bytesToLong((byte[])this.timestampBytes), (TsPrimitiveType)new TsPrimitiveType.TsDouble(BytesUtils.bytesToDouble((byte[])this.valueBytes)));
            }
        }

        private static class FloatReader
        extends TimeValuePairReader {
            byte[] timestampBytes = new byte[8];
            byte[] valueBytes = new byte[4];

            private FloatReader() {
            }

            @Override
            public TimeValuePair read(InputStream inputStream) throws IOException {
                inputStream.read(this.timestampBytes);
                inputStream.read(this.valueBytes);
                return new TimeValuePair(BytesUtils.bytesToLong((byte[])this.timestampBytes), (TsPrimitiveType)new TsPrimitiveType.TsFloat(BytesUtils.bytesToFloat((byte[])this.valueBytes)));
            }
        }

        private static class LongReader
        extends TimeValuePairReader {
            byte[] timestampBytes = new byte[8];
            byte[] valueBytes = new byte[8];

            private LongReader() {
            }

            @Override
            public TimeValuePair read(InputStream inputStream) throws IOException {
                inputStream.read(this.timestampBytes);
                inputStream.read(this.valueBytes);
                return new TimeValuePair(BytesUtils.bytesToLong((byte[])this.timestampBytes), (TsPrimitiveType)new TsPrimitiveType.TsLong(BytesUtils.bytesToLong((byte[])this.valueBytes)));
            }
        }

        private static class IntReader
        extends TimeValuePairReader {
            byte[] timestampBytes = new byte[8];
            byte[] valueBytes = new byte[4];

            private IntReader() {
            }

            @Override
            public TimeValuePair read(InputStream inputStream) throws IOException {
                inputStream.read(this.timestampBytes);
                inputStream.read(this.valueBytes);
                return new TimeValuePair(BytesUtils.bytesToLong((byte[])this.timestampBytes), (TsPrimitiveType)new TsPrimitiveType.TsInt(BytesUtils.bytesToInt((byte[])this.valueBytes)));
            }
        }

        private static class BooleanReader
        extends TimeValuePairReader {
            byte[] timestampBytes = new byte[8];
            byte[] valueBytes = new byte[1];

            private BooleanReader() {
            }

            @Override
            public TimeValuePair read(InputStream inputStream) throws IOException {
                inputStream.read(this.timestampBytes);
                inputStream.read(this.valueBytes);
                return new TimeValuePair(BytesUtils.bytesToLong((byte[])this.timestampBytes), (TsPrimitiveType)new TsPrimitiveType.TsBoolean(BytesUtils.bytesToBool((byte[])this.valueBytes)));
            }
        }
    }
}

