/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.reader.chunk;

import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.reader.IPageReader;

public class MemPageReader
implements IPageReader {
    private BatchData batchData;
    private Statistics statistics;
    private Filter valueFilter;

    public MemPageReader(BatchData batchData, Statistics statistics) {
        this.batchData = batchData;
        this.statistics = statistics;
    }

    public BatchData getAllSatisfiedPageData() {
        if (this.valueFilter == null) {
            return this.batchData;
        }
        BatchData filteredBatchData = new BatchData(this.batchData.getDataType());
        while (this.batchData.hasCurrent()) {
            if (this.valueFilter.satisfy(this.batchData.currentTime(), this.batchData.currentValue())) {
                filteredBatchData.putAnObject(this.batchData.currentTime(), this.batchData.currentValue());
            }
            this.batchData.next();
        }
        return filteredBatchData;
    }

    public Statistics getStatistics() {
        return this.statistics;
    }

    public void setFilter(Filter filter) {
        this.valueFilter = filter;
    }

    public boolean isModified() {
        return false;
    }
}

