/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.rescon;

import java.util.ArrayDeque;
import java.util.Deque;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.memtable.IMemTable;
import org.apache.iotdb.db.engine.memtable.PrimitiveMemTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemTablePool {
    private static final IoTDBConfig CONFIG = IoTDBDescriptor.getInstance().getConfig();
    private static final Logger logger = LoggerFactory.getLogger(MemTablePool.class);
    private static final Deque<IMemTable> availableMemTables = new ArrayDeque<IMemTable>();
    private static final int WAIT_TIME = 2000;
    private int size = 0;

    private MemTablePool() {
    }

    public static MemTablePool getInstance() {
        return InstanceHolder.INSTANCE;
    }

    public IMemTable getAvailableMemTable(Object applier) {
        Deque<IMemTable> deque = availableMemTables;
        synchronized (deque) {
            if (availableMemTables.isEmpty() && this.size < CONFIG.getMaxMemtableNumber()) {
                ++this.size;
                logger.info("generated a new memtable for {}, system memtable size: {}, stack size: {}", new Object[]{applier, this.size, availableMemTables.size()});
                return new PrimitiveMemTable();
            }
            if (!availableMemTables.isEmpty()) {
                logger.debug("system memtable size: {}, stack size: {}, then get a memtable from stack for {}", new Object[]{this.size, availableMemTables.size(), applier});
                return availableMemTables.pop();
            }
            int waitCount = 1;
            while (true) {
                if (!availableMemTables.isEmpty()) {
                    logger.debug("system memtable size: {}, stack size: {}, then get a memtable from stack for {}", new Object[]{this.size, availableMemTables.size(), applier});
                    return availableMemTables.pop();
                }
                try {
                    availableMemTables.wait(2000L);
                }
                catch (InterruptedException e) {
                    logger.error("{} fails to wait fot memtables {}, continue to wait", applier, (Object)e);
                    Thread.currentThread().interrupt();
                }
                logger.info("{} has waited for a memtable for {}ms", applier, (Object)(waitCount++ * 2000));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putBack(IMemTable memTable, String storageGroup) {
        if (memTable.isSignalMemTable()) {
            return;
        }
        Deque<IMemTable> deque = availableMemTables;
        synchronized (deque) {
            if (this.size > CONFIG.getMaxMemtableNumber()) {
                logger.debug("Currently the size of available MemTables is {}, the maxmin size of MemTables is {}, discard this MemTable.", (Object)CONFIG.getMaxMemtableNumber(), (Object)this.size);
                --this.size;
                return;
            }
            memTable.clear();
            availableMemTables.push(memTable);
            availableMemTables.notify();
            logger.debug("{} return a memtable, stack size {}", (Object)storageGroup, (Object)availableMemTables.size());
        }
    }

    public int getSize() {
        return this.size;
    }

    private static class InstanceHolder {
        private static final MemTablePool INSTANCE = new MemTablePool();

        private InstanceHolder() {
        }
    }
}

