/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service;

import com.google.common.collect.Lists;
import io.moquette.broker.Server;
import io.moquette.broker.config.IConfig;
import io.moquette.broker.config.MemoryConfig;
import io.moquette.broker.security.IAuthenticator;
import io.moquette.interception.InterceptHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.StartupException;
import org.apache.iotdb.db.mqtt.BrokerAuthenticator;
import org.apache.iotdb.db.mqtt.PublishHandler;
import org.apache.iotdb.db.service.IService;
import org.apache.iotdb.db.service.ServiceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MQTTService
implements IService {
    private static final Logger LOG = LoggerFactory.getLogger(MQTTService.class);
    private Server server = new Server();

    @Override
    public void start() throws StartupException {
        this.startup();
    }

    @Override
    public void stop() {
        this.shutdown();
    }

    public void startup() {
        IoTDBConfig iotDBConfig = IoTDBDescriptor.getInstance().getConfig();
        IConfig config = this.createBrokerConfig(iotDBConfig);
        ArrayList handlers = Lists.newArrayList((Object[])new InterceptHandler[]{new PublishHandler(iotDBConfig)});
        BrokerAuthenticator authenticator = new BrokerAuthenticator();
        this.server.startServer(config, (List)handlers, null, (IAuthenticator)authenticator, null);
        LOG.info("Start MQTT service successfully, listening on ip {} port {}", (Object)iotDBConfig.getMqttHost(), (Object)iotDBConfig.getMqttPort());
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            LOG.info("Stopping IoTDB MQTT service...");
            this.shutdown();
            LOG.info("IoTDB MQTT service stopped.");
        }));
    }

    private IConfig createBrokerConfig(IoTDBConfig iotDBConfig) {
        Properties properties = new Properties();
        properties.setProperty("host", iotDBConfig.getMqttHost());
        properties.setProperty("port", String.valueOf(iotDBConfig.getMqttPort()));
        properties.setProperty("intercept.thread_pool.size", String.valueOf(iotDBConfig.getMqttHandlerPoolSize()));
        properties.setProperty("immediate_buffer_flush", "true");
        properties.setProperty("netty.mqtt.message_size", String.valueOf(iotDBConfig.getMqttMaxMessageSize()));
        return new MemoryConfig(properties);
    }

    public void shutdown() {
        this.server.stopServer();
    }

    @Override
    public ServiceType getID() {
        return ServiceType.MQTT_SERVICE;
    }

    public static final MQTTService getInstance() {
        return MQTTServiceHolder.INSTANCE;
    }

    private static class MQTTServiceHolder {
        private static final MQTTService INSTANCE = new MQTTService();

        private MQTTServiceHolder() {
        }
    }
}

