/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.db.exception.StartupException;
import org.apache.iotdb.db.service.IService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegisterManager {
    private static final Logger logger = LoggerFactory.getLogger(RegisterManager.class);
    private List<IService> iServices = new ArrayList<IService>();

    public void register(IService service) throws StartupException {
        for (IService s : this.iServices) {
            if (s.getID() != service.getID()) continue;
            logger.info("{} has already been registered. skip", (Object)service.getID().getName());
            return;
        }
        this.iServices.add(service);
        service.start();
    }

    public void deregisterAll() {
        Collections.reverse(this.iServices);
        for (IService service : this.iServices) {
            try {
                service.waitAndStop(10000L);
            }
            catch (Exception e) {
                logger.error("Failed to stop {} because:", (Object)service.getID().getName(), (Object)e);
            }
        }
        this.iServices.clear();
        logger.info("deregister all service.");
    }
}

