/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.tools.memestimation;

import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import io.airlift.airline.Cli;
import io.airlift.airline.Help;
import io.airlift.airline.ParseArgumentsMissingException;
import io.airlift.airline.ParseArgumentsUnexpectedException;
import io.airlift.airline.ParseCommandMissingException;
import io.airlift.airline.ParseCommandUnrecognizedException;
import io.airlift.airline.ParseOptionConversionException;
import io.airlift.airline.ParseOptionMissingException;
import io.airlift.airline.ParseOptionMissingValueException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.fileSystem.SystemFileFactory;
import org.apache.iotdb.db.tools.memestimation.MemEstToolCmd;

public class MemEstTool {
    public static void main(String ... args) throws IOException {
        ArrayList commands = Lists.newArrayList((Object[])new Class[]{Help.class, MemEstToolCmd.class});
        Cli.CliBuilder builder = Cli.builder((String)"memory-tool");
        builder.withDescription("Estimate memory for writing").withDefaultCommand(Help.class).withCommands((Iterable)commands);
        Cli parser = builder.build();
        int status = 0;
        try {
            Runnable parse = (Runnable)parser.parse(args);
            parse.run();
        }
        catch (ParseArgumentsMissingException | ParseArgumentsUnexpectedException | ParseCommandMissingException | ParseCommandUnrecognizedException | ParseOptionConversionException | ParseOptionMissingException | ParseOptionMissingValueException | IllegalArgumentException | IllegalStateException e) {
            MemEstTool.badUse((Exception)e);
            status = 1;
        }
        catch (Exception e) {
            MemEstTool.err(Throwables.getRootCause((Throwable)e));
            status = 2;
        }
        FileUtils.deleteDirectory((File)SystemFileFactory.INSTANCE.getFile(IoTDBDescriptor.getInstance().getConfig().getBaseDir()));
        System.exit(status);
    }

    private static void badUse(Exception e) {
        System.out.println("memory-tool: " + e.getMessage());
        System.out.println("See 'memory-tool help' or 'memory-tool help <command>'.");
    }

    private static void err(Throwable e) {
        System.err.println("error: " + e.getMessage());
        System.err.println("-- StackTrace --");
        System.err.println(Throwables.getStackTraceAsString((Throwable)e));
    }
}

