/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils;

import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public class TypeInferenceUtils {
    private static TSDataType booleanStringInferType = IoTDBDescriptor.getInstance().getConfig().getBooleanStringInferType();
    private static TSDataType integerStringInferType = IoTDBDescriptor.getInstance().getConfig().getIntegerStringInferType();
    private static TSDataType floatingStringInferType = IoTDBDescriptor.getInstance().getConfig().getFloatingStringInferType();
    private static TSDataType nanStringInferType = IoTDBDescriptor.getInstance().getConfig().getNanStringInferType();

    private TypeInferenceUtils() {
    }

    static boolean isNumber(String s) {
        try {
            Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    private static boolean isBoolean(String s) {
        return s.equalsIgnoreCase("true") || s.equalsIgnoreCase("false");
    }

    public static TSDataType getPredictedDataType(Object value, boolean inferType) {
        if (inferType) {
            String strValue = value.toString();
            if (TypeInferenceUtils.isBoolean(strValue)) {
                return booleanStringInferType;
            }
            if (TypeInferenceUtils.isNumber(strValue)) {
                if (!strValue.contains(".")) {
                    return integerStringInferType;
                }
                return floatingStringInferType;
            }
            if ("NaN".equals(strValue)) {
                return nanStringInferType;
            }
            return TSDataType.TEXT;
        }
        if (value instanceof Boolean) {
            return TSDataType.BOOLEAN;
        }
        if (value instanceof Integer) {
            return TSDataType.INT32;
        }
        if (value instanceof Long) {
            return TSDataType.INT64;
        }
        if (value instanceof Float) {
            return TSDataType.FLOAT;
        }
        if (value instanceof Double) {
            return TSDataType.DOUBLE;
        }
        return TSDataType.TEXT;
    }
}

