/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils.datastructure;

import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.rescon.PrimitiveArrayPool;
import org.apache.iotdb.db.utils.datastructure.TVList;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;

public class LongTVList
extends TVList {
    private List<long[]> values = new ArrayList<long[]>();
    private long[][] sortedValues;
    private long pivotValue;

    LongTVList() {
    }

    @Override
    public void putLong(long timestamp, long value) {
        this.checkExpansion();
        int arrayIndex = this.size / PrimitiveArrayPool.ARRAY_SIZE;
        int elementIndex = this.size % PrimitiveArrayPool.ARRAY_SIZE;
        this.minTime = this.minTime <= timestamp ? this.minTime : timestamp;
        ((long[])this.timestamps.get((int)arrayIndex))[elementIndex] = timestamp;
        this.values.get((int)arrayIndex)[elementIndex] = value;
        ++this.size;
        if (this.sorted && this.size > 1 && timestamp < this.getTime(this.size - 2)) {
            this.sorted = false;
        }
    }

    @Override
    public long getLong(int index) {
        if (index >= this.size) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        int arrayIndex = index / PrimitiveArrayPool.ARRAY_SIZE;
        int elementIndex = index % PrimitiveArrayPool.ARRAY_SIZE;
        return this.values.get(arrayIndex)[elementIndex];
    }

    protected void set(int index, long timestamp, long value) {
        if (index >= this.size) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        int arrayIndex = index / PrimitiveArrayPool.ARRAY_SIZE;
        int elementIndex = index % PrimitiveArrayPool.ARRAY_SIZE;
        ((long[])this.timestamps.get((int)arrayIndex))[elementIndex] = timestamp;
        this.values.get((int)arrayIndex)[elementIndex] = value;
    }

    @Override
    public LongTVList clone() {
        LongTVList cloneList = new LongTVList();
        this.cloneAs(cloneList);
        for (long[] valueArray : this.values) {
            cloneList.values.add(this.cloneValue(valueArray));
        }
        return cloneList;
    }

    private long[] cloneValue(long[] array) {
        long[] cloneArray = new long[array.length];
        System.arraycopy(array, 0, cloneArray, 0, array.length);
        return cloneArray;
    }

    @Override
    public void sort() {
        if (this.sortedTimestamps == null || this.sortedTimestamps.length < this.size) {
            this.sortedTimestamps = (long[][])PrimitiveArrayPool.getInstance().getDataListsByType(TSDataType.INT64, this.size);
        }
        if (this.sortedValues == null || this.sortedValues.length < this.size) {
            this.sortedValues = (long[][])PrimitiveArrayPool.getInstance().getDataListsByType(TSDataType.INT64, this.size);
        }
        this.sort(0, this.size);
        this.clearSortedValue();
        this.clearSortedTime();
        this.sorted = true;
    }

    @Override
    void clearValue() {
        if (this.values != null) {
            for (long[] dataArray : this.values) {
                PrimitiveArrayPool.getInstance().release(dataArray);
            }
            this.values.clear();
        }
    }

    @Override
    void clearSortedValue() {
        if (this.sortedValues != null) {
            for (long[] dataArray : this.sortedValues) {
                PrimitiveArrayPool.getInstance().release(dataArray);
            }
            this.sortedValues = null;
        }
    }

    @Override
    protected void setFromSorted(int src, int dest) {
        this.set(dest, this.sortedTimestamps[src / PrimitiveArrayPool.ARRAY_SIZE][src % PrimitiveArrayPool.ARRAY_SIZE], this.sortedValues[src / PrimitiveArrayPool.ARRAY_SIZE][src % PrimitiveArrayPool.ARRAY_SIZE]);
    }

    @Override
    protected void set(int src, int dest) {
        long srcT = this.getTime(src);
        long srcV = this.getLong(src);
        this.set(dest, srcT, srcV);
    }

    @Override
    protected void setToSorted(int src, int dest) {
        this.sortedTimestamps[dest / PrimitiveArrayPool.ARRAY_SIZE][dest % PrimitiveArrayPool.ARRAY_SIZE] = this.getTime(src);
        this.sortedValues[dest / PrimitiveArrayPool.ARRAY_SIZE][dest % PrimitiveArrayPool.ARRAY_SIZE] = this.getLong(src);
    }

    @Override
    protected void reverseRange(int lo, int hi) {
        --hi;
        while (lo < hi) {
            long loT = this.getTime(lo);
            long loV = this.getLong(lo);
            long hiT = this.getTime(hi);
            long hiV = this.getLong(hi);
            this.set(lo++, hiT, hiV);
            this.set(hi--, loT, loV);
        }
    }

    @Override
    protected void expandValues() {
        this.values.add((long[])PrimitiveArrayPool.getInstance().getPrimitiveDataListByType(TSDataType.INT64));
    }

    @Override
    protected void saveAsPivot(int pos) {
        this.pivotTime = this.getTime(pos);
        this.pivotValue = this.getLong(pos);
    }

    @Override
    protected void setPivotTo(int pos) {
        this.set(pos, this.pivotTime, this.pivotValue);
    }

    @Override
    public TimeValuePair getTimeValuePair(int index) {
        return new TimeValuePair(this.getTime(index), TsPrimitiveType.getByType((TSDataType)TSDataType.INT64, (Object)this.getLong(index)));
    }

    @Override
    protected TimeValuePair getTimeValuePair(int index, long time, Integer floatPrecision, TSEncoding encoding) {
        return new TimeValuePair(time, TsPrimitiveType.getByType((TSDataType)TSDataType.INT64, (Object)this.getLong(index)));
    }

    @Override
    protected void releaseLastValueArray() {
        PrimitiveArrayPool.getInstance().release(this.values.remove(this.values.size() - 1));
    }

    @Override
    public void putLongs(long[] time, long[] value) {
        this.checkExpansion();
        int idx = 0;
        int length = time.length;
        this.updateMinTimeAndSorted(time);
        while (idx < length) {
            int inputRemaining = length - idx;
            int arrayIdx = this.size / PrimitiveArrayPool.ARRAY_SIZE;
            int elementIdx = this.size % PrimitiveArrayPool.ARRAY_SIZE;
            int internalRemaining = PrimitiveArrayPool.ARRAY_SIZE - elementIdx;
            if (internalRemaining >= inputRemaining) {
                System.arraycopy(time, idx, this.timestamps.get(arrayIdx), elementIdx, inputRemaining);
                System.arraycopy(value, idx, this.values.get(arrayIdx), elementIdx, inputRemaining);
                this.size += inputRemaining;
                break;
            }
            System.arraycopy(time, idx, this.timestamps.get(arrayIdx), elementIdx, internalRemaining);
            System.arraycopy(value, idx, this.values.get(arrayIdx), elementIdx, internalRemaining);
            idx += internalRemaining;
            this.size += internalRemaining;
            this.checkExpansion();
        }
    }

    @Override
    public void putLongs(long[] time, long[] value, int start, int end) {
        this.checkExpansion();
        int idx = start;
        this.updateMinTimeAndSorted(time, start, end);
        while (idx < end) {
            int inputRemaining = end - idx;
            int arrayIdx = this.size / PrimitiveArrayPool.ARRAY_SIZE;
            int elementIdx = this.size % PrimitiveArrayPool.ARRAY_SIZE;
            int internalRemaining = PrimitiveArrayPool.ARRAY_SIZE - elementIdx;
            if (internalRemaining >= inputRemaining) {
                System.arraycopy(time, idx, this.timestamps.get(arrayIdx), elementIdx, inputRemaining);
                System.arraycopy(value, idx, this.values.get(arrayIdx), elementIdx, inputRemaining);
                this.size += inputRemaining;
                break;
            }
            System.arraycopy(time, idx, this.timestamps.get(arrayIdx), elementIdx, internalRemaining);
            System.arraycopy(value, idx, this.values.get(arrayIdx), elementIdx, internalRemaining);
            idx += internalRemaining;
            this.size += internalRemaining;
            this.checkExpansion();
        }
    }
}

