/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.writelog.recover;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.engine.memtable.IMemTable;
import org.apache.iotdb.db.engine.modification.Deletion;
import org.apache.iotdb.db.engine.modification.ModificationFile;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.engine.version.VersionController;
import org.apache.iotdb.db.exception.WriteProcessException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.MManager;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.crud.DeletePlan;
import org.apache.iotdb.db.qp.physical.crud.InsertPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertTabletPlan;
import org.apache.iotdb.db.qp.physical.crud.UpdatePlan;
import org.apache.iotdb.db.writelog.io.ILogReader;
import org.apache.iotdb.db.writelog.manager.MultiFileLogNodeManager;
import org.apache.iotdb.db.writelog.node.WriteLogNode;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogReplayer {
    private Logger logger = LoggerFactory.getLogger(LogReplayer.class);
    private String logNodePrefix;
    private String insertFilePath;
    private ModificationFile modFile;
    private VersionController versionController;
    private TsFileResource currentTsFileResource;
    private IMemTable recoverMemTable;
    private boolean acceptDuplication;
    private Map<String, Long> tempStartTimeMap = new HashMap<String, Long>();
    private Map<String, Long> tempEndTimeMap = new HashMap<String, Long>();

    public LogReplayer(String logNodePrefix, String insertFilePath, ModificationFile modFile, VersionController versionController, TsFileResource currentTsFileResource, IMemTable memTable, boolean acceptDuplication) {
        this.logNodePrefix = logNodePrefix;
        this.insertFilePath = insertFilePath;
        this.modFile = modFile;
        this.versionController = versionController;
        this.currentTsFileResource = currentTsFileResource;
        this.recoverMemTable = memTable;
        this.acceptDuplication = acceptDuplication;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void replayLogs() {
        WriteLogNode logNode = MultiFileLogNodeManager.getInstance().getNode(this.logNodePrefix + FSFactoryProducer.getFSFactory().getFile(this.insertFilePath).getName());
        ILogReader logReader = logNode.getLogReader();
        try {
            while (logReader.hasNext()) {
                try {
                    PhysicalPlan plan = logReader.next();
                    if (plan instanceof InsertPlan) {
                        this.replayInsert((InsertPlan)plan);
                        continue;
                    }
                    if (plan instanceof DeletePlan) {
                        this.replayDelete((DeletePlan)plan);
                        continue;
                    }
                    if (plan instanceof UpdatePlan) {
                        this.replayUpdate((UpdatePlan)plan);
                        continue;
                    }
                    if (!(plan instanceof InsertTabletPlan)) continue;
                    this.replayBatchInsert((InsertTabletPlan)plan);
                }
                catch (Exception e) {
                    this.logger.error("recover wal of {} failed", (Object)this.insertFilePath, (Object)e);
                }
            }
        }
        catch (IOException e) {
            this.logger.error("meet error when redo wal of {}", (Object)this.insertFilePath, (Object)e);
        }
        finally {
            logReader.close();
            try {
                this.modFile.close();
            }
            catch (IOException e) {
                this.logger.error("Canno close the modifications file {}", (Object)this.modFile.getFilePath(), (Object)e);
            }
        }
        this.tempStartTimeMap.forEach((k, v) -> this.currentTsFileResource.updateStartTime((String)k, (long)v));
        this.tempEndTimeMap.forEach((k, v) -> this.currentTsFileResource.updateEndTime((String)k, (long)v));
    }

    private void replayDelete(DeletePlan deletePlan) throws IOException {
        List<Path> paths = deletePlan.getPaths();
        for (Path path : paths) {
            this.recoverMemTable.delete(path.getDevice(), path.getMeasurement(), deletePlan.getDeleteTime());
            this.modFile.write(new Deletion(path, this.versionController.nextVersion(), deletePlan.getDeleteTime()));
        }
    }

    private void replayBatchInsert(InsertTabletPlan insertTabletPlan) throws WriteProcessException, QueryProcessException {
        MeasurementSchema[] schemas;
        if (this.currentTsFileResource != null) {
            Long endTime;
            long lastEndTime = this.currentTsFileResource.getEndTime(insertTabletPlan.getDeviceId());
            if (lastEndTime != Long.MIN_VALUE && lastEndTime >= insertTabletPlan.getMinTime() && !this.acceptDuplication) {
                return;
            }
            Long startTime = this.tempStartTimeMap.get(insertTabletPlan.getDeviceId());
            if (startTime == null || startTime > insertTabletPlan.getMinTime()) {
                this.tempStartTimeMap.put(insertTabletPlan.getDeviceId(), insertTabletPlan.getMinTime());
            }
            if ((endTime = this.tempEndTimeMap.get(insertTabletPlan.getDeviceId())) == null || endTime < insertTabletPlan.getMaxTime()) {
                this.tempEndTimeMap.put(insertTabletPlan.getDeviceId(), insertTabletPlan.getMaxTime());
            }
        }
        try {
            schemas = MManager.getInstance().getSchemas(insertTabletPlan.getDeviceId(), insertTabletPlan.getMeasurements());
        }
        catch (MetadataException e) {
            throw new QueryProcessException(e);
        }
        insertTabletPlan.setSchemas(schemas);
        this.recoverMemTable.insertTablet(insertTabletPlan, 0, insertTabletPlan.getRowCount());
    }

    private void replayInsert(InsertPlan insertPlan) {
        if (this.currentTsFileResource != null) {
            Long endTime;
            long lastEndTime = this.currentTsFileResource.getEndTime(insertPlan.getDeviceId());
            if (lastEndTime != Long.MIN_VALUE && lastEndTime >= insertPlan.getTime() && !this.acceptDuplication) {
                return;
            }
            Long startTime = this.tempStartTimeMap.get(insertPlan.getDeviceId());
            if (startTime == null || startTime > insertPlan.getTime()) {
                this.tempStartTimeMap.put(insertPlan.getDeviceId(), insertPlan.getTime());
            }
            if ((endTime = this.tempEndTimeMap.get(insertPlan.getDeviceId())) == null || endTime < insertPlan.getTime()) {
                this.tempEndTimeMap.put(insertPlan.getDeviceId(), insertPlan.getTime());
            }
        }
        try {
            MeasurementSchema[] schemas = MManager.getInstance().getSchemas(insertPlan.getDeviceId(), insertPlan.getMeasurements());
            insertPlan.setSchemasAndTransferType(schemas);
            this.recoverMemTable.insert(insertPlan);
        }
        catch (Exception e) {
            this.logger.error("occurs exception when replaying the record {} at timestamp {}: {}.(Will ignore the record)", new Object[]{insertPlan.getPaths(), insertPlan.getTime(), e.getMessage()});
        }
    }

    private void replayUpdate(UpdatePlan updatePlan) {
        throw new UnsupportedOperationException("Update not supported");
    }
}

