/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.writelog.recover;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.iotdb.db.engine.fileSystem.SystemFileFactory;
import org.apache.iotdb.db.engine.flush.MemTableFlushTask;
import org.apache.iotdb.db.engine.memtable.PrimitiveMemTable;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.engine.version.VersionController;
import org.apache.iotdb.db.exception.StorageGroupProcessorException;
import org.apache.iotdb.db.utils.FileLoaderUtils;
import org.apache.iotdb.db.writelog.manager.MultiFileLogNodeManager;
import org.apache.iotdb.db.writelog.recover.LogReplayer;
import org.apache.iotdb.tsfile.exception.NotCompatibleTsFileException;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.write.writer.RestorableTsFileIOWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsFileRecoverPerformer {
    private static final Logger logger = LoggerFactory.getLogger(TsFileRecoverPerformer.class);
    private String filePath;
    private String logNodePrefix;
    private VersionController versionController;
    private TsFileResource resource;
    private boolean acceptUnseq;
    private boolean isLastFile;

    public TsFileRecoverPerformer(String logNodePrefix, VersionController versionController, TsFileResource currentTsFileResource, boolean acceptUnseq, boolean isLastFile) {
        this.filePath = currentTsFileResource.getPath();
        this.logNodePrefix = logNodePrefix;
        this.versionController = versionController;
        this.resource = currentTsFileResource;
        this.acceptUnseq = acceptUnseq;
        this.isLastFile = isLastFile;
    }

    public RestorableTsFileIOWriter recover() throws StorageGroupProcessorException {
        RestorableTsFileIOWriter restorableTsFileIOWriter;
        File file = FSFactoryProducer.getFSFactory().getFile(this.filePath);
        if (!file.exists()) {
            logger.error("TsFile {} is missing, will skip its recovery.", (Object)this.filePath);
            return null;
        }
        try {
            restorableTsFileIOWriter = new RestorableTsFileIOWriter(file);
        }
        catch (NotCompatibleTsFileException e) {
            boolean result = file.delete();
            logger.warn("TsFile {} is incompatible. Delete it successfully {}", (Object)this.filePath, (Object)result);
            throw new StorageGroupProcessorException((Exception)((Object)e));
        }
        catch (IOException e) {
            throw new StorageGroupProcessorException(e);
        }
        if (!restorableTsFileIOWriter.hasCrashed() && !restorableTsFileIOWriter.canWrite()) {
            try {
                if (this.resource.fileExists()) {
                    this.recoverResourceFromFile();
                } else {
                    try (TsFileSequenceReader reader = new TsFileSequenceReader(this.resource.getFile().getAbsolutePath());){
                        FileLoaderUtils.updateTsFileResource(reader, this.resource);
                    }
                    long fileVersion = Long.parseLong(this.resource.getFile().getName().split("-")[1]);
                    this.resource.setHistoricalVersions(Collections.singleton(fileVersion));
                    this.resource.serialize();
                }
                return restorableTsFileIOWriter;
            }
            catch (IOException e) {
                throw new StorageGroupProcessorException("recover the resource file failed: " + this.filePath + ".resource" + e);
            }
        }
        this.recoverResourceFromWriter(restorableTsFileIOWriter);
        this.redoLogs(restorableTsFileIOWriter);
        try {
            MultiFileLogNodeManager.getInstance().deleteNode(this.logNodePrefix + SystemFileFactory.INSTANCE.getFile(this.filePath).getName());
        }
        catch (IOException e) {
            throw new StorageGroupProcessorException(e);
        }
        return restorableTsFileIOWriter;
    }

    private void recoverResourceFromFile() throws IOException {
        try {
            this.resource.deserialize();
        }
        catch (IOException e) {
            logger.warn("Cannot deserialize TsFileResource {}, construct it using TsFileSequenceReader", (Object)this.resource.getFile(), (Object)e);
            this.recoverResourceFromReader();
        }
    }

    private void recoverResourceFromReader() throws IOException {
        try (TsFileSequenceReader reader = new TsFileSequenceReader(this.resource.getFile().getAbsolutePath(), true);){
            for (Map.Entry entry : reader.getAllTimeseriesMetadata().entrySet()) {
                for (TimeseriesMetadata timeseriesMetaData : (List)entry.getValue()) {
                    this.resource.updateStartTime((String)entry.getKey(), timeseriesMetaData.getStatistics().getStartTime());
                    this.resource.updateEndTime((String)entry.getKey(), timeseriesMetaData.getStatistics().getEndTime());
                }
            }
        }
        this.resource.serialize();
    }

    private void recoverResourceFromWriter(RestorableTsFileIOWriter restorableTsFileIOWriter) {
        Map deviceChunkMetaDataMap = restorableTsFileIOWriter.getDeviceChunkMetadataMap();
        for (Map.Entry entry : deviceChunkMetaDataMap.entrySet()) {
            String deviceId = (String)entry.getKey();
            List chunkMetadataList = (List)entry.getValue();
            for (ChunkMetadata chunkMetaData : chunkMetadataList) {
                this.resource.updateStartTime(deviceId, chunkMetaData.getStartTime());
                this.resource.updateEndTime(deviceId, chunkMetaData.getEndTime());
            }
        }
        long fileVersion = Long.parseLong(this.resource.getFile().getName().split("-")[1]);
        this.resource.setHistoricalVersions(Collections.singleton(fileVersion));
    }

    private void redoLogs(RestorableTsFileIOWriter restorableTsFileIOWriter) throws StorageGroupProcessorException {
        PrimitiveMemTable recoverMemTable = new PrimitiveMemTable();
        recoverMemTable.setVersion(this.versionController.nextVersion());
        LogReplayer logReplayer = new LogReplayer(this.logNodePrefix, this.filePath, this.resource.getModFile(), this.versionController, this.resource, recoverMemTable, this.acceptUnseq);
        logReplayer.replayLogs();
        try {
            if (!recoverMemTable.isEmpty()) {
                MemTableFlushTask tableFlushTask = new MemTableFlushTask(recoverMemTable, restorableTsFileIOWriter, this.resource.getFile().getParentFile().getParentFile().getName());
                tableFlushTask.syncFlushMemTable();
            }
            if (!this.isLastFile || this.resource.isCloseFlagSet()) {
                restorableTsFileIOWriter.endFile();
                this.resource.cleanCloseFlag();
                this.resource.serialize();
            }
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            throw new StorageGroupProcessorException(e);
        }
    }
}

