/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.level;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.cache.ChunkMetadataCache;
import org.apache.iotdb.db.engine.compaction.TsFileManagement;
import org.apache.iotdb.db.engine.compaction.no.NoCompactionTsFileManagement;
import org.apache.iotdb.db.engine.compaction.utils.CompactionLogAnalyzer;
import org.apache.iotdb.db.engine.compaction.utils.CompactionLogger;
import org.apache.iotdb.db.engine.compaction.utils.CompactionUtils;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.query.control.FileReaderManager;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.write.writer.RestorableTsFileIOWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LevelCompactionTsFileManagement
extends TsFileManagement {
    private static final Logger logger = LoggerFactory.getLogger(LevelCompactionTsFileManagement.class);
    private final int seqLevelNum = IoTDBDescriptor.getInstance().getConfig().getSeqLevelNum();
    private final int seqFileNumInEachLevel = IoTDBDescriptor.getInstance().getConfig().getSeqFileNumInEachLevel();
    private final int unseqLevelNum = IoTDBDescriptor.getInstance().getConfig().getUnseqLevelNum();
    private final int unseqFileNumInEachLevel = IoTDBDescriptor.getInstance().getConfig().getSeqFileNumInEachLevel();
    private final boolean enableUnseqCompaction = IoTDBDescriptor.getInstance().getConfig().isEnableUnseqCompaction();
    private final boolean isForceFullMerge = IoTDBDescriptor.getInstance().getConfig().isForceFullMerge();
    private final Map<Long, List<TreeSet<TsFileResource>>> sequenceTsFileResources = new ConcurrentSkipListMap<Long, List<TreeSet<TsFileResource>>>();
    private final Map<Long, List<List<TsFileResource>>> unSequenceTsFileResources = new ConcurrentSkipListMap<Long, List<List<TsFileResource>>>();
    private final List<List<TsFileResource>> forkedSequenceTsFileResources = new ArrayList<List<TsFileResource>>();
    private final List<List<TsFileResource>> forkedUnSequenceTsFileResources = new ArrayList<List<TsFileResource>>();

    public LevelCompactionTsFileManagement(String storageGroupName, String storageGroupDir) {
        super(storageGroupName, storageGroupDir);
        this.clear();
    }

    private void deleteLevelFilesInDisk(Collection<TsFileResource> mergeTsFiles) {
        logger.debug("{} [compaction] merge starts to delete real file", (Object)this.storageGroupName);
        for (TsFileResource mergeTsFile : mergeTsFiles) {
            this.deleteLevelFile(mergeTsFile);
            logger.info("{} [Compaction] delete TsFile {}", (Object)this.storageGroupName, (Object)mergeTsFile.getTsFilePath());
        }
    }

    private void deleteLevelFilesInList(long timePartitionId, Collection<TsFileResource> mergeTsFiles) {
        int i;
        logger.debug("{} [compaction] merge starts to delete file list", (Object)this.storageGroupName);
        for (i = 0; i < this.seqLevelNum; ++i) {
            if (!this.sequenceTsFileResources.containsKey(timePartitionId) || this.sequenceTsFileResources.get(timePartitionId).size() <= i) continue;
            this.sequenceTsFileResources.get(timePartitionId).get(i).removeAll(mergeTsFiles);
        }
        for (i = 0; i < this.unseqLevelNum; ++i) {
            if (!this.unSequenceTsFileResources.containsKey(timePartitionId) || this.unSequenceTsFileResources.get(timePartitionId).size() <= i) continue;
            this.unSequenceTsFileResources.get(timePartitionId).get(i).removeAll(mergeTsFiles);
        }
    }

    private void deleteLevelFile(TsFileResource seqFile) {
        seqFile.writeLock();
        try {
            ChunkMetadataCache.getInstance().remove(seqFile);
            FileReaderManager.getInstance().closeFileAndRemoveReader(seqFile.getTsFilePath());
            seqFile.setDeleted(true);
            seqFile.delete();
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            seqFile.writeUnlock();
        }
    }

    @Override
    public List<TsFileResource> getStableTsFileList(boolean sequence) {
        ArrayList<TsFileResource> result = new ArrayList<TsFileResource>();
        if (sequence) {
            for (List<TreeSet<TsFileResource>> sequenceTsFileList : this.sequenceTsFileResources.values()) {
                result.addAll((Collection<TsFileResource>)sequenceTsFileList.get(this.seqLevelNum - 1));
            }
        } else {
            for (List<List<TsFileResource>> unSequenceTsFileList : this.unSequenceTsFileResources.values()) {
                result.addAll((Collection<TsFileResource>)unSequenceTsFileList.get(this.unseqLevelNum - 1));
            }
        }
        return result;
    }

    @Override
    public List<TsFileResource> getTsFileList(boolean sequence) {
        ArrayList<TsFileResource> result = new ArrayList<TsFileResource>();
        if (sequence) {
            for (List<TreeSet<TsFileResource>> sequenceTsFileList : this.sequenceTsFileResources.values()) {
                for (int i = sequenceTsFileList.size() - 1; i >= 0; --i) {
                    result.addAll((Collection<TsFileResource>)sequenceTsFileList.get(i));
                }
            }
        } else {
            for (List<List<TsFileResource>> unSequenceTsFileList : this.unSequenceTsFileResources.values()) {
                for (int i = unSequenceTsFileList.size() - 1; i >= 0; --i) {
                    result.addAll((Collection<TsFileResource>)unSequenceTsFileList.get(i));
                }
            }
        }
        return result;
    }

    @Override
    public Iterator<TsFileResource> getIterator(boolean sequence) {
        return this.getTsFileList(sequence).iterator();
    }

    @Override
    public void remove(TsFileResource tsFileResource, boolean sequence) {
        if (sequence) {
            for (TreeSet<TsFileResource> sequenceTsFileResource : this.sequenceTsFileResources.get(tsFileResource.getTimePartition())) {
                sequenceTsFileResource.remove(tsFileResource);
            }
        } else {
            for (List<TsFileResource> unSequenceTsFileResource : this.unSequenceTsFileResources.get(tsFileResource.getTimePartition())) {
                unSequenceTsFileResource.remove(tsFileResource);
            }
        }
    }

    @Override
    public void removeAll(List<TsFileResource> tsFileResourceList, boolean sequence) {
        if (sequence) {
            for (List<TreeSet<TsFileResource>> partitionSequenceTsFileResource : this.sequenceTsFileResources.values()) {
                for (TreeSet<TsFileResource> levelTsFileResource : partitionSequenceTsFileResource) {
                    levelTsFileResource.removeAll(tsFileResourceList);
                }
            }
        } else {
            for (List<List<TsFileResource>> partitionUnSequenceTsFileResource : this.unSequenceTsFileResources.values()) {
                for (List<TsFileResource> levelTsFileResource : partitionUnSequenceTsFileResource) {
                    levelTsFileResource.removeAll(tsFileResourceList);
                }
            }
        }
    }

    @Override
    public void add(TsFileResource tsFileResource, boolean sequence) {
        long timePartitionId = tsFileResource.getTimePartition();
        int level = LevelCompactionTsFileManagement.getMergeLevel(tsFileResource.getTsFile());
        if (sequence) {
            if (level <= this.seqLevelNum - 1) {
                ((TreeSet)this.sequenceTsFileResources.computeIfAbsent(timePartitionId, this::newSequenceTsFileResources).get(level)).add(tsFileResource);
            } else {
                ((TreeSet)this.sequenceTsFileResources.computeIfAbsent(timePartitionId, this::newSequenceTsFileResources).get(this.seqLevelNum - 1)).add(tsFileResource);
            }
        } else if (level <= this.unseqLevelNum - 1) {
            ((List)this.unSequenceTsFileResources.computeIfAbsent(timePartitionId, this::newUnSequenceTsFileResources).get(level)).add(tsFileResource);
        } else {
            ((List)this.unSequenceTsFileResources.computeIfAbsent(timePartitionId, this::newUnSequenceTsFileResources).get(this.unseqLevelNum - 1)).add(tsFileResource);
        }
    }

    @Override
    public void addAll(List<TsFileResource> tsFileResourceList, boolean sequence) {
        for (TsFileResource tsFileResource : tsFileResourceList) {
            this.add(tsFileResource, sequence);
        }
    }

    @Override
    public boolean contains(TsFileResource tsFileResource, boolean sequence) {
        if (sequence) {
            for (TreeSet sequenceTsFileResource : this.sequenceTsFileResources.computeIfAbsent(tsFileResource.getTimePartition(), this::newSequenceTsFileResources)) {
                if (!sequenceTsFileResource.contains(tsFileResource)) continue;
                return true;
            }
        } else {
            for (List unSequenceTsFileResource : this.unSequenceTsFileResources.computeIfAbsent(tsFileResource.getTimePartition(), this::newUnSequenceTsFileResources)) {
                if (!unSequenceTsFileResource.contains(tsFileResource)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void clear() {
        this.sequenceTsFileResources.clear();
        this.unSequenceTsFileResources.clear();
    }

    @Override
    public boolean isEmpty(boolean sequence) {
        if (sequence) {
            for (List<TreeSet<TsFileResource>> partitionSequenceTsFileResource : this.sequenceTsFileResources.values()) {
                for (TreeSet<TsFileResource> sequenceTsFileResource : partitionSequenceTsFileResource) {
                    if (sequenceTsFileResource.isEmpty()) continue;
                    return false;
                }
            }
        } else {
            for (List<List<TsFileResource>> partitionUnSequenceTsFileResource : this.unSequenceTsFileResources.values()) {
                for (List<TsFileResource> unSequenceTsFileResource : partitionUnSequenceTsFileResource) {
                    if (unSequenceTsFileResource.isEmpty()) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public int size(boolean sequence) {
        int result = 0;
        if (sequence) {
            for (List<TreeSet<TsFileResource>> partitionSequenceTsFileResource : this.sequenceTsFileResources.values()) {
                for (int i = this.seqLevelNum - 1; i >= 0; --i) {
                    result += partitionSequenceTsFileResource.get(i).size();
                }
            }
        } else {
            for (List<List<TsFileResource>> partitionUnSequenceTsFileResource : this.unSequenceTsFileResources.values()) {
                for (int i = this.unseqLevelNum - 1; i >= 0; --i) {
                    result += partitionUnSequenceTsFileResource.get(i).size();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recover() {
        File logFile = FSFactoryProducer.getFSFactory().getFile(this.storageGroupDir, this.storageGroupName + ".compaction.log");
        try {
            if (logFile.exists()) {
                CompactionLogAnalyzer logAnalyzer = new CompactionLogAnalyzer(logFile);
                logAnalyzer.analyze();
                Set<String> deviceSet = logAnalyzer.getDeviceSet();
                List<String> sourceFileList = logAnalyzer.getSourceFiles();
                long offset = logAnalyzer.getOffset();
                String targetFile = logAnalyzer.getTargetFile();
                boolean isMergeFinished = logAnalyzer.isMergeFinished();
                boolean fullMerge = logAnalyzer.isFullMerge();
                boolean isSeq = logAnalyzer.isSeq();
                if (targetFile == null) {
                    return;
                }
                if (fullMerge) {
                    if (!isMergeFinished) {
                        RestorableTsFileIOWriter writer = new RestorableTsFileIOWriter(new File(targetFile));
                        writer.getIOWriterOut().truncate(offset - 1L);
                        writer.close();
                        TsFileResource targetTsFileResource = this.getTsFileResource(targetFile, isSeq);
                        long timePartition = targetTsFileResource.getTimePartition();
                        CompactionUtils.merge(targetTsFileResource, this.getTsFileList(isSeq), this.storageGroupName, new CompactionLogger(this.storageGroupDir, this.storageGroupName), deviceSet, isSeq);
                        if (isSeq) {
                            for (TreeSet<TsFileResource> currMergeFile : this.sequenceTsFileResources.get(timePartition)) {
                                this.deleteLevelFilesInDisk(currMergeFile);
                                this.deleteLevelFilesInList(timePartition, currMergeFile);
                            }
                        } else {
                            for (List<TsFileResource> currMergeFile : this.unSequenceTsFileResources.get(timePartition)) {
                                this.deleteLevelFilesInDisk(currMergeFile);
                                this.deleteLevelFilesInList(timePartition, currMergeFile);
                            }
                        }
                    }
                } else {
                    TsFileResource targetResource = this.getTsFileResource(targetFile, isSeq);
                    long timePartition = targetResource.getTimePartition();
                    RestorableTsFileIOWriter writer = new RestorableTsFileIOWriter(new File(targetFile));
                    ArrayList<TsFileResource> sourceTsFileResources = new ArrayList<TsFileResource>();
                    for (String file : sourceFileList) {
                        sourceTsFileResources.add(this.getTsFileResource(file, isSeq));
                    }
                    if (sourceFileList.isEmpty()) {
                        return;
                    }
                    int level = LevelCompactionTsFileManagement.getMergeLevel(new File(sourceFileList.get(0)));
                    if (!isMergeFinished) {
                        if (deviceSet.isEmpty()) {
                            Files.delete(new File(targetFile).toPath());
                        } else {
                            writer.getIOWriterOut().truncate(offset - 1L);
                            writer.close();
                            if (isSeq) {
                                CompactionUtils.merge(targetResource, sourceTsFileResources, this.storageGroupName, new CompactionLogger(this.storageGroupDir, this.storageGroupName), deviceSet, true);
                                this.deleteLevelFilesInDisk(sourceTsFileResources);
                                this.deleteLevelFilesInList(timePartition, sourceTsFileResources);
                                this.sequenceTsFileResources.get(timePartition).get(level + 1).add(targetResource);
                            } else {
                                CompactionUtils.merge(targetResource, sourceTsFileResources, this.storageGroupName, new CompactionLogger(this.storageGroupDir, this.storageGroupName), deviceSet, false);
                                this.deleteLevelFilesInDisk(sourceTsFileResources);
                                this.deleteLevelFilesInList(timePartition, sourceTsFileResources);
                                this.unSequenceTsFileResources.get(timePartition).get(level + 1).add(targetResource);
                            }
                        }
                    }
                }
            }
        }
        catch (IOException e) {
            logger.error("recover level tsfile management error ", (Throwable)e);
        }
        finally {
            if (logFile.exists()) {
                try {
                    Files.delete(logFile.toPath());
                }
                catch (IOException e) {
                    logger.error("delete level tsfile management log file error ", (Throwable)e);
                }
            }
        }
    }

    @Override
    public void forkCurrentFileList(long timePartition) {
        this.forkTsFileList(this.forkedSequenceTsFileResources, this.sequenceTsFileResources.computeIfAbsent(timePartition, this::newSequenceTsFileResources), this.seqLevelNum, this.seqFileNumInEachLevel);
        this.forkTsFileList(this.forkedUnSequenceTsFileResources, this.unSequenceTsFileResources.computeIfAbsent(timePartition, this::newUnSequenceTsFileResources), this.unseqLevelNum + 1, this.unseqFileNumInEachLevel);
    }

    private void forkTsFileList(List<List<TsFileResource>> forkedTsFileResources, List rawTsFileResources, int currMaxLevel, int currFileNumInEachLevel) {
        forkedTsFileResources.clear();
        for (int i = 0; i < currMaxLevel - 1; ++i) {
            ArrayList<TsFileResource> forkedLevelTsFileResources = new ArrayList<TsFileResource>();
            Collection levelRawTsFileResources = (Collection)rawTsFileResources.get(i);
            for (TsFileResource tsFileResource : levelRawTsFileResources) {
                if (!tsFileResource.isClosed()) continue;
                forkedLevelTsFileResources.add(tsFileResource);
                if (forkedLevelTsFileResources.size() <= currFileNumInEachLevel) continue;
                break;
            }
            forkedTsFileResources.add(forkedLevelTsFileResources);
        }
    }

    @Override
    protected void merge(long timePartition) {
        this.merge(this.forkedSequenceTsFileResources, true, timePartition, this.seqLevelNum, this.seqFileNumInEachLevel);
        if (this.enableUnseqCompaction && this.unseqLevelNum <= 1 && this.forkedUnSequenceTsFileResources.size() > 0) {
            this.merge(this.isForceFullMerge, this.getTsFileList(true), this.forkedUnSequenceTsFileResources.get(0), Long.MAX_VALUE);
        } else {
            this.merge(this.forkedUnSequenceTsFileResources, false, timePartition, this.unseqLevelNum, this.unseqFileNumInEachLevel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void merge(List<List<TsFileResource>> mergeResources, boolean sequence, long timePartition, int currMaxLevel, int currMaxFileNumInEachLevel) {
        while (this.isUnseqMerging) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                logger.error("{} [Compaction] shutdown", (Object)this.storageGroupName, (Object)e);
                Thread.currentThread().interrupt();
                return;
            }
        }
        long startTimeMillis = System.currentTimeMillis();
        try {
            logger.info("{} start to filter compaction condition", (Object)this.storageGroupName);
            for (int i = 0; i < currMaxLevel - 1; ++i) {
                if (currMaxFileNumInEachLevel > mergeResources.get(i).size()) continue;
                if (this.enableUnseqCompaction && !sequence && i == currMaxLevel - 2) {
                    this.merge(this.isForceFullMerge, this.getTsFileList(true), mergeResources.get(i), Long.MAX_VALUE);
                    continue;
                }
                CompactionLogger compactionLogger = new CompactionLogger(this.storageGroupDir, this.storageGroupName);
                for (TsFileResource mergeResource : mergeResources.get(i)) {
                    compactionLogger.logFile("source", mergeResource.getTsFile());
                }
                File newLevelFile = this.createNewTsFileName(mergeResources.get(i).get(0).getTsFile(), i + 1);
                compactionLogger.logSequence(sequence);
                compactionLogger.logFile("target", newLevelFile);
                List<TsFileResource> toMergeTsFiles = mergeResources.get(i);
                logger.info("{} [Compaction] merge level-{}'s {} TsFiles to next level", new Object[]{this.storageGroupName, i, toMergeTsFiles.size()});
                for (TsFileResource toMergeTsFile : toMergeTsFiles) {
                    logger.info("{} [Compaction] start to merge TsFile {}", (Object)this.storageGroupName, (Object)toMergeTsFile);
                }
                TsFileResource newResource = new TsFileResource(newLevelFile);
                CompactionUtils.merge(newResource, toMergeTsFiles, this.storageGroupName, compactionLogger, new HashSet<String>(), sequence);
                logger.info("{} [Compaction] merged level-{}'s {} TsFiles to next level, and start to delete old files", new Object[]{this.storageGroupName, i, toMergeTsFiles.size()});
                this.writeLock();
                try {
                    compactionLogger.logMergeFinish();
                    if (sequence) {
                        this.sequenceTsFileResources.get(timePartition).get(i + 1).add(newResource);
                    } else {
                        this.unSequenceTsFileResources.get(timePartition).get(i + 1).add(newResource);
                    }
                    this.deleteLevelFilesInList(timePartition, toMergeTsFiles);
                    if (mergeResources.size() > i + 1) {
                        mergeResources.get(i + 1).add(newResource);
                    }
                }
                finally {
                    this.writeUnlock();
                }
                this.deleteLevelFilesInDisk(toMergeTsFiles);
                compactionLogger.close();
                File logFile = FSFactoryProducer.getFSFactory().getFile(this.storageGroupDir, this.storageGroupName + ".compaction.log");
                if (!logFile.exists()) continue;
                Files.delete(logFile.toPath());
            }
        }
        catch (Exception e) {
            try {
                logger.error("Error occurred in Compaction Merge thread", (Throwable)e);
            }
            catch (Throwable throwable) {
                logger.info("{} [Compaction] merge end time isSeq = {}, consumption: {} ms", new Object[]{this.storageGroupName, sequence, System.currentTimeMillis() - startTimeMillis});
                throw throwable;
            }
            logger.info("{} [Compaction] merge end time isSeq = {}, consumption: {} ms", new Object[]{this.storageGroupName, sequence, System.currentTimeMillis() - startTimeMillis});
        }
        logger.info("{} [Compaction] merge end time isSeq = {}, consumption: {} ms", new Object[]{this.storageGroupName, sequence, System.currentTimeMillis() - startTimeMillis});
    }

    private File createNewTsFileName(File sourceFile, int level) {
        String path = sourceFile.getAbsolutePath();
        String prefixPath = path.substring(0, path.lastIndexOf("-") + 1);
        return new File(prefixPath + level + ".tsfile");
    }

    private List<TreeSet<TsFileResource>> newSequenceTsFileResources(Long k) {
        CopyOnWriteArrayList<TreeSet<TsFileResource>> newSequenceTsFileResources = new CopyOnWriteArrayList<TreeSet<TsFileResource>>();
        for (int i = 0; i < this.seqLevelNum; ++i) {
            newSequenceTsFileResources.add(new TreeSet((o1, o2) -> {
                int rangeCompare = Long.compare(Long.parseLong(o1.getTsFile().getParentFile().getName()), Long.parseLong(o2.getTsFile().getParentFile().getName()));
                return rangeCompare == 0 ? NoCompactionTsFileManagement.compareFileName(o1.getTsFile(), o2.getTsFile()) : rangeCompare;
            }));
        }
        return newSequenceTsFileResources;
    }

    private List<List<TsFileResource>> newUnSequenceTsFileResources(Long k) {
        CopyOnWriteArrayList<List<TsFileResource>> newUnSequenceTsFileResources = new CopyOnWriteArrayList<List<TsFileResource>>();
        for (int i = 0; i < this.unseqLevelNum; ++i) {
            newUnSequenceTsFileResources.add(new CopyOnWriteArrayList());
        }
        return newUnSequenceTsFileResources;
    }

    public static int getMergeLevel(File file) {
        String mergeLevelStr = file.getPath().substring(file.getPath().lastIndexOf("-") + 1).replaceAll(".tsfile", "");
        return Integer.parseInt(mergeLevelStr);
    }

    private TsFileResource getTsFileResource(String filePath, boolean isSeq) throws IOException {
        if (isSeq) {
            for (List<TreeSet<TsFileResource>> tsFileResourcesWithLevel : this.sequenceTsFileResources.values()) {
                for (TreeSet<TsFileResource> tsFileResources : tsFileResourcesWithLevel) {
                    for (TsFileResource tsFileResource : tsFileResources) {
                        if (!tsFileResource.getTsFile().getAbsolutePath().equals(filePath)) continue;
                        return tsFileResource;
                    }
                }
            }
        } else {
            for (List<List<TsFileResource>> tsFileResourcesWithLevel : this.unSequenceTsFileResources.values()) {
                for (List<TsFileResource> tsFileResources : tsFileResourcesWithLevel) {
                    for (TsFileResource tsFileResource : tsFileResources) {
                        if (!tsFileResource.getTsFile().getAbsolutePath().equals(filePath)) continue;
                        return tsFileResource;
                    }
                }
            }
        }
        logger.error("cannot get tsfile resource path: {}", (Object)filePath);
        throw new IOException();
    }
}

