/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CompactionLogAnalyzer {
    public static final String STR_DEVICE_OFFSET_SEPERATOR = " ";
    private File logFile;
    private boolean isMergeFinished = false;
    private Set<String> deviceSet = new HashSet<String>();
    private long offset = 0L;
    private List<String> sourceFiles = new ArrayList<String>();
    private String targetFile = null;
    private boolean isSeq = false;
    private boolean fullMerge = false;

    public CompactionLogAnalyzer(File logFile) {
        this.logFile = logFile;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void analyze() throws IOException {
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(this.logFile));){
            String currLine;
            block25: while ((currLine = bufferedReader.readLine()) != null) {
                switch (currLine) {
                    case "source": {
                        currLine = bufferedReader.readLine();
                        this.sourceFiles.add(currLine);
                        continue block25;
                    }
                    case "target": {
                        this.targetFile = currLine = bufferedReader.readLine();
                        continue block25;
                    }
                    case "merge finished": {
                        this.isMergeFinished = true;
                        continue block25;
                    }
                    case "full merge": {
                        this.fullMerge = true;
                        continue block25;
                    }
                    case "sequence": {
                        this.isSeq = true;
                        continue block25;
                    }
                    case "unsequence": {
                        this.isSeq = false;
                        continue block25;
                    }
                }
                if (!currLine.contains(STR_DEVICE_OFFSET_SEPERATOR)) continue;
                String[] resultList = currLine.split(STR_DEVICE_OFFSET_SEPERATOR);
                this.deviceSet.add(resultList[0]);
                this.offset = Long.parseLong(resultList[1]);
            }
            return;
        }
    }

    public boolean isMergeFinished() {
        return this.isMergeFinished;
    }

    public Set<String> getDeviceSet() {
        return this.deviceSet;
    }

    public long getOffset() {
        return this.offset;
    }

    public List<String> getSourceFiles() {
        return this.sourceFiles;
    }

    public String getTargetFile() {
        return this.targetFile;
    }

    public boolean isSeq() {
        return this.isSeq;
    }

    public boolean isFullMerge() {
        return this.fullMerge;
    }
}

