/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.utils;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.iotdb.db.engine.fileSystem.SystemFileFactory;

public class CompactionLogger {
    public static final String COMPACTION_LOG_NAME = ".compaction.log";
    public static final String SOURCE_NAME = "source";
    public static final String TARGET_NAME = "target";
    public static final String SEQUENCE_NAME = "sequence";
    public static final String UNSEQUENCE_NAME = "unsequence";
    public static final String FULL_MERGE = "full merge";
    public static final String MERGE_FINISHED = "merge finished";
    private BufferedWriter logStream;

    public CompactionLogger(String storageGroupDir, String storageGroupName) throws IOException {
        this.logStream = new BufferedWriter(new FileWriter(SystemFileFactory.INSTANCE.getFile(storageGroupDir, storageGroupName + COMPACTION_LOG_NAME), true));
    }

    public void close() throws IOException {
        this.logStream.close();
    }

    public void logDevice(String device, long offset) throws IOException {
        this.logStream.write(device + " " + offset);
        this.logStream.newLine();
        this.logStream.flush();
    }

    public void logFile(String prefix, File file) throws IOException {
        this.logStream.write(prefix);
        this.logStream.newLine();
        this.logStream.write(file.getAbsolutePath());
        this.logStream.newLine();
        this.logStream.flush();
    }

    public void logMergeFinish() throws IOException {
        this.logStream.write(MERGE_FINISHED);
        this.logStream.newLine();
        this.logStream.flush();
    }

    public void logFullMerge() throws IOException {
        this.logStream.write(FULL_MERGE);
        this.logStream.newLine();
        this.logStream.flush();
    }

    public void logSequence(boolean isSeq) throws IOException {
        if (isSeq) {
            this.logStream.write(SEQUENCE_NAME);
        } else {
            this.logStream.write(UNSEQUENCE_NAME);
        }
        this.logStream.newLine();
        this.logStream.flush();
    }
}

