/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.merge.recover;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.engine.fileSystem.SystemFileFactory;
import org.apache.iotdb.db.engine.merge.manage.MergeResource;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.service.IoTDB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogAnalyzer {
    private static final Logger logger = LoggerFactory.getLogger(LogAnalyzer.class);
    private MergeResource resource;
    private String taskName;
    private File logFile;
    private String storageGroupName;
    private Map<File, Long> fileLastPositions = new HashMap<File, Long>();
    private Map<File, Long> tempFileLastPositions = new HashMap<File, Long>();
    private List<PartialPath> mergedPaths = new ArrayList<PartialPath>();
    private List<PartialPath> unmergedPaths;
    private List<TsFileResource> unmergedFiles;
    private String currLine;
    private Status status;

    public LogAnalyzer(MergeResource resource, String taskName, File logFile, String storageGroupName) {
        this.resource = resource;
        this.taskName = taskName;
        this.logFile = logFile;
        this.storageGroupName = storageGroupName;
    }

    public Status analyze() throws IOException, MetadataException {
        this.status = Status.NONE;
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(this.logFile));){
            this.currLine = bufferedReader.readLine();
            if (this.currLine != null) {
                this.analyzeSeqFiles(bufferedReader);
                this.analyzeUnseqFiles(bufferedReader);
                List<PartialPath> storageGroupPaths = IoTDB.metaManager.getAllTimeseriesPath(new PartialPath(this.storageGroupName + ".*"));
                this.unmergedPaths = new ArrayList<PartialPath>();
                this.unmergedPaths.addAll(storageGroupPaths);
                this.analyzeMergedSeries(bufferedReader, this.unmergedPaths);
                this.analyzeMergedFiles(bufferedReader);
            }
        }
        return this.status;
    }

    private void analyzeSeqFiles(BufferedReader bufferedReader) throws IOException {
        if (!"seqFiles".equals(this.currLine)) {
            return;
        }
        long startTime = System.currentTimeMillis();
        ArrayList<TsFileResource> mergeSeqFiles = new ArrayList<TsFileResource>();
        block0: while ((this.currLine = bufferedReader.readLine()) != null && !"unseqFiles".equals(this.currLine)) {
            Iterator<TsFileResource> iterator = this.resource.getSeqFiles().iterator();
            while (iterator.hasNext()) {
                TsFileResource seqFile = iterator.next();
                if (!seqFile.getTsFile().getAbsolutePath().equals(this.currLine)) continue;
                mergeSeqFiles.add(seqFile);
                iterator.remove();
                continue block0;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{} found {} seq files after {}ms", new Object[]{this.taskName, mergeSeqFiles.size(), System.currentTimeMillis() - startTime});
        }
        this.resource.setSeqFiles(mergeSeqFiles);
    }

    private void analyzeUnseqFiles(BufferedReader bufferedReader) throws IOException {
        if (!"unseqFiles".equals(this.currLine)) {
            return;
        }
        long startTime = System.currentTimeMillis();
        ArrayList<TsFileResource> mergeUnseqFiles = new ArrayList<TsFileResource>();
        block0: while ((this.currLine = bufferedReader.readLine()) != null && !this.currLine.equals("timeseries")) {
            Iterator<TsFileResource> iterator = this.resource.getUnseqFiles().iterator();
            while (iterator.hasNext()) {
                TsFileResource unseqFile = iterator.next();
                if (!unseqFile.getTsFile().getAbsolutePath().equals(this.currLine)) continue;
                mergeUnseqFiles.add(unseqFile);
                iterator.remove();
                continue block0;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{} found {} unseq files after {}ms", new Object[]{this.taskName, mergeUnseqFiles.size(), System.currentTimeMillis() - startTime});
        }
        this.resource.setUnseqFiles(mergeUnseqFiles);
    }

    private void analyzeMergedSeries(BufferedReader bufferedReader, List<PartialPath> unmergedPaths) throws IOException {
        if (!"merge start".equals(this.currLine)) {
            return;
        }
        this.status = Status.MERGE_START;
        for (TsFileResource seqFile : this.resource.getSeqFiles()) {
            File mergeFile = SystemFileFactory.INSTANCE.getFile(seqFile.getTsFilePath() + ".merge");
            this.fileLastPositions.put(mergeFile, 0L);
        }
        ArrayList<PartialPath> currTSList = new ArrayList<PartialPath>();
        long startTime = System.currentTimeMillis();
        while ((this.currLine = bufferedReader.readLine()) != null && !"all ts end".equals(this.currLine)) {
            String[] splits;
            if (this.currLine.contains("start")) {
                splits = this.currLine.split(" ");
                for (int i = 1; i < splits.length; ++i) {
                    try {
                        currTSList.add(new PartialPath(splits[i]));
                        continue;
                    }
                    catch (IllegalPathException e) {
                        throw new IOException(e.getMessage());
                    }
                }
                this.tempFileLastPositions.clear();
                continue;
            }
            if (!this.currLine.contains("end")) {
                splits = this.currLine.split(" ");
                File file = SystemFileFactory.INSTANCE.getFile(splits[0]);
                Long position = Long.parseLong(splits[1]);
                this.tempFileLastPositions.put(file, position);
                continue;
            }
            unmergedPaths.removeAll(currTSList);
            for (Map.Entry<File, Long> entry : this.tempFileLastPositions.entrySet()) {
                this.fileLastPositions.put(entry.getKey(), entry.getValue());
            }
            this.mergedPaths.addAll(currTSList);
        }
        this.tempFileLastPositions = null;
        if (logger.isDebugEnabled()) {
            logger.debug("{} found {} series have already been merged after {}ms", new Object[]{this.taskName, this.mergedPaths.size(), System.currentTimeMillis() - startTime});
        }
    }

    private void analyzeMergedFiles(BufferedReader bufferedReader) throws IOException {
        if (!"all ts end".equals(this.currLine)) {
            return;
        }
        this.status = Status.ALL_TS_MERGED;
        this.unmergedFiles = this.resource.getSeqFiles();
        File currFile = null;
        long startTime = System.currentTimeMillis();
        int mergedCnt = 0;
        block0: while ((this.currLine = bufferedReader.readLine()) != null) {
            if ("merge end".equals(this.currLine)) {
                this.status = Status.MERGE_END;
                break;
            }
            if (!this.currLine.contains("end")) {
                String[] splits = this.currLine.split(" ");
                currFile = SystemFileFactory.INSTANCE.getFile(splits[0]);
                Long lastPost = Long.parseLong(splits[1]);
                this.fileLastPositions.put(currFile, lastPost);
                continue;
            }
            if (currFile == null) {
                throw new IOException("Illegal merge files");
            }
            this.fileLastPositions.remove(currFile);
            String seqFilePath = currFile.getAbsolutePath().replace(".merge", "");
            Iterator<TsFileResource> unmergedFileIter = this.unmergedFiles.iterator();
            while (unmergedFileIter.hasNext()) {
                TsFileResource seqFile = unmergedFileIter.next();
                if (!seqFile.getTsFile().getAbsolutePath().equals(seqFilePath)) continue;
                ++mergedCnt;
                unmergedFileIter.remove();
                continue block0;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{} found {} files have already been merged after {}ms", new Object[]{this.taskName, mergedCnt, System.currentTimeMillis() - startTime});
        }
    }

    public List<PartialPath> getUnmergedPaths() {
        return this.unmergedPaths;
    }

    public void setUnmergedPaths(List<PartialPath> unmergedPaths) {
        this.unmergedPaths = unmergedPaths;
    }

    public List<TsFileResource> getUnmergedFiles() {
        return this.unmergedFiles;
    }

    public void setUnmergedFiles(List<TsFileResource> unmergedFiles) {
        this.unmergedFiles = unmergedFiles;
    }

    public List<PartialPath> getMergedPaths() {
        return this.mergedPaths;
    }

    public void setMergedPaths(List<PartialPath> mergedPaths) {
        this.mergedPaths = mergedPaths;
    }

    public Map<File, Long> getFileLastPositions() {
        return this.fileLastPositions;
    }

    public void setFileLastPositions(Map<File, Long> fileLastPositions) {
        this.fileLastPositions = fileLastPositions;
    }

    public static enum Status {
        NONE,
        MERGE_START,
        ALL_TS_MERGED,
        MERGE_END;

    }
}

