/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metrics.server;

import com.sun.management.OperatingSystemMXBean;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerArgument {
    private static final Logger logger = LoggerFactory.getLogger(ServerArgument.class);
    private static final int CPUTIME = 1000;
    private String host;
    private int port;
    private int cores;
    private long totalMemory;
    private long freeMemory;
    private long maxMemory;
    private String osName;
    private long totalPhysicalMemory;
    private long freePhysicalMemory;
    private long usedPhysicalMemory;
    private int cpuRatio;

    public ServerArgument(int port) {
        this.port = port;
        this.host = this.inferHostname();
        this.cores = this.totalCores();
        this.osName = this.osName();
        this.totalPhysicalMemory = this.totalPhysicalMemory();
        this.usedPhysicalMemory = this.usedPhysicalMemory();
        this.freePhysicalMemory = this.freePhysicalMemory();
        this.totalMemory = this.totalMemory();
        this.freeMemory = this.freeMemory();
        this.maxMemory = this.maxMemory();
        this.cpuRatio = this.getCpuRatio();
    }

    private String inferHostname() {
        try {
            InetAddress ia = InetAddress.getLocalHost();
            return ia.getHostName();
        }
        catch (UnknownHostException e) {
            logger.error("The host is unknow", (Throwable)e);
            return "";
        }
    }

    private String osName() {
        return System.getProperty("os.name");
    }

    private int totalCores() {
        OperatingSystemMXBean osmxb = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        int freeCores = osmxb.getAvailableProcessors();
        return freeCores;
    }

    private long totalMemory() {
        return Runtime.getRuntime().totalMemory() / 1024L / 1024L;
    }

    private long freeMemory() {
        return Runtime.getRuntime().freeMemory() / 1024L / 1024L;
    }

    private long maxMemory() {
        return Runtime.getRuntime().maxMemory() / 1024L / 1024L;
    }

    private long totalPhysicalMemory() {
        OperatingSystemMXBean osmxb = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        long totalMemorySize = osmxb.getTotalPhysicalMemorySize() / 1024L / 1024L;
        return totalMemorySize;
    }

    private long usedPhysicalMemory() {
        OperatingSystemMXBean osmxb = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        long usedMemorySize = (osmxb.getTotalPhysicalMemorySize() - osmxb.getFreePhysicalMemorySize()) / 1024L / 1024L;
        return usedMemorySize;
    }

    private long freePhysicalMemory() {
        OperatingSystemMXBean osmxb = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        long freeMemorySize = osmxb.getFreePhysicalMemorySize() / 1024L / 1024L;
        return freeMemorySize;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getHost() {
        return this.host;
    }

    public int getCores() {
        return this.cores;
    }

    public long getTotalMemory() {
        return this.totalMemory;
    }

    public long getFreeMemory() {
        return this.freeMemory;
    }

    public long getMaxMemory() {
        return this.maxMemory;
    }

    public String getOsName() {
        return this.osName;
    }

    public long getTotalPhysicalMemory() {
        return this.totalPhysicalMemory;
    }

    public long getFreePhysicalMemory() {
        return this.freePhysicalMemory;
    }

    public long getUsedPhysicalMemory() {
        return this.usedPhysicalMemory;
    }

    public int getCpuRatio() {
        String osName = System.getProperty("os.name").toLowerCase();
        this.cpuRatio = 0;
        if (osName.indexOf("windows") >= 0) {
            this.cpuRatio = this.getCpuRatioForWindows();
        } else if (osName.indexOf("linux") >= 0) {
            this.cpuRatio = this.getCpuRateForLinux();
        } else {
            this.cpuRatio = 500;
            logger.warn("Can't get the cpu ratio,because this OS:{} is not support", (Object)osName);
        }
        return this.cpuRatio;
    }

    private int getCpuRateForLinux() {
        try {
            long[] c0 = this.readLinuxCpu();
            Thread.sleep(1000L);
            long[] c1 = this.readLinuxCpu();
            if (c0 != null && c1 != null) {
                long idleCpuTime = c1[0] - c0[0];
                long totalCpuTime = c1[1] - c0[1];
                if (totalCpuTime == 0L) {
                    return 100;
                }
                return (int)(100.0 * (1.0 - (double)idleCpuTime / (double)totalCpuTime));
            }
            return 0;
        }
        catch (Exception e) {
            logger.error("Get CPU Ratio failed", (Throwable)e);
            return 0;
        }
    }

    private int getCpuRatioForWindows() {
        try {
            String procCmd = System.getenv("windir") + "\\system32\\wbem\\wmic.exe process get Caption,CommandLine,KernelModeTime,ReadOperationCount,ThreadCount,UserModeTime,WriteOperationCount";
            long[] c0 = this.readWinCpu(Runtime.getRuntime().exec(procCmd));
            Thread.sleep(1000L);
            long[] c1 = this.readWinCpu(Runtime.getRuntime().exec(procCmd));
            if (c0 != null && c1 != null) {
                long busytime = c1[1] - c0[1];
                long idletime = c1[0] - c0[0];
                if (busytime + idletime == 0L) {
                    return 100;
                }
                return (int)(100.0 * ((double)busytime / (double)(busytime + idletime)));
            }
            return 0;
        }
        catch (Exception e) {
            logger.error("Get CPU Ratio failed", (Throwable)e);
            return 0;
        }
    }

    private long[] readWinCpu(Process proc) throws Exception {
        long[] retn = new long[2];
        proc.getOutputStream().close();
        InputStreamReader ir = new InputStreamReader(proc.getInputStream());
        LineNumberReader input = new LineNumberReader(ir);
        String line = input.readLine();
        if (line == null || line.length() < 10) {
            return null;
        }
        int capidx = line.indexOf("Caption");
        int cmdidx = line.indexOf("CommandLine");
        int rocidx = line.indexOf("ReadOperationCount");
        int umtidx = line.indexOf("UserModeTime");
        int kmtidx = line.indexOf("KernelModeTime");
        int wocidx = line.indexOf("WriteOperationCount");
        long idletime = 0L;
        long kneltime = 0L;
        long usertime = 0L;
        while ((line = input.readLine()) != null) {
            String cmd;
            if (line.length() < wocidx || (cmd = line.substring(cmdidx, kmtidx).trim()).indexOf("wmic.exe") >= 0) continue;
            String caption = line.substring(capidx, cmdidx).trim();
            String s1 = line.substring(kmtidx, rocidx).trim();
            String s2 = line.substring(umtidx, wocidx).trim();
            ArrayList<String> digitS1 = new ArrayList<String>();
            ArrayList<String> digitS2 = new ArrayList<String>();
            digitS1.add(s1.replaceAll("\\D", ""));
            digitS2.add(s2.replaceAll("\\D", ""));
            if (caption.equals("System Idle Process") || caption.equals("System")) {
                if (s1.length() > 0 && !((String)digitS1.get(0)).equals("") && digitS1.get(0) != null) {
                    idletime += Long.valueOf((String)digitS1.get(0)).longValue();
                }
                if (s2.length() <= 0 || ((String)digitS2.get(0)).equals("") || digitS2.get(0) == null) continue;
                idletime += Long.valueOf((String)digitS2.get(0)).longValue();
                continue;
            }
            if (s1.length() > 0 && !((String)digitS1.get(0)).equals("") && digitS1.get(0) != null) {
                kneltime += Long.valueOf((String)digitS1.get(0)).longValue();
            }
            if (s2.length() <= 0 || ((String)digitS2.get(0)).equals("") || digitS2.get(0) == null) continue;
            kneltime += Long.valueOf((String)digitS2.get(0)).longValue();
        }
        retn[0] = idletime;
        retn[1] = kneltime + usertime;
        proc.getInputStream().close();
        return retn;
    }

    private long[] readLinuxCpu() throws Exception {
        long[] retn = new long[2];
        long idleCpuTime = 0L;
        long totalCpuTime = 0L;
        String line = null;
        try (BufferedReader buffer = new BufferedReader(new InputStreamReader(new FileInputStream("/proc/stat")));){
            while ((line = buffer.readLine()) != null) {
                if (!line.startsWith("cpu")) continue;
                StringTokenizer tokenizer = new StringTokenizer(line);
                ArrayList<String> temp = new ArrayList<String>();
                while (tokenizer.hasMoreElements()) {
                    temp.add(tokenizer.nextToken());
                }
                idleCpuTime = Long.parseLong((String)temp.get(4));
                totalCpuTime = Long.parseLong((String)temp.get(1)) + Long.parseLong((String)temp.get(2)) + Long.parseLong((String)temp.get(3)) + Long.parseLong((String)temp.get(4));
                break;
            }
            retn[0] = idleCpuTime;
            retn[1] = totalCpuTime;
        }
        return retn;
    }
}

