/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.exception.metadata.PathAlreadyExistException;
import org.apache.iotdb.db.exception.metadata.PathNotExistException;
import org.apache.iotdb.db.exception.metadata.StorageGroupNotSetException;
import org.apache.iotdb.db.metadata.MeasurementMeta;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.TimeseriesSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaUtils {
    private static final Map<TSDataType, Set<TSEncoding>> schemaChecker = new EnumMap<TSDataType, Set<TSEncoding>>(TSDataType.class);
    private static final Logger logger;

    private SchemaUtils() {
    }

    public static void registerTimeseries(TimeseriesSchema schema) {
        try {
            logger.debug("Registering timeseries {}", (Object)schema);
            PartialPath path = new PartialPath(schema.getFullPath());
            TSDataType dataType = schema.getType();
            TSEncoding encoding = schema.getEncodingType();
            CompressionType compressionType = schema.getCompressor();
            IoTDB.metaManager.createTimeseries(path, dataType, encoding, compressionType, Collections.emptyMap());
        }
        catch (PathAlreadyExistException path) {
        }
        catch (MetadataException e) {
            logger.error("Cannot create timeseries {} in snapshot, ignored", (Object)schema.getFullPath(), (Object)e);
        }
    }

    public static void cacheTimeseriesSchema(TimeseriesSchema schema) {
        PartialPath path;
        try {
            path = new PartialPath(schema.getFullPath());
        }
        catch (IllegalPathException e) {
            logger.error("Cannot cache an illegal path {}", (Object)schema.getFullPath());
            return;
        }
        TSDataType dataType = schema.getType();
        TSEncoding encoding = schema.getEncodingType();
        CompressionType compressionType = schema.getCompressor();
        IoTDB.metaManager.cacheMeta(path, new MeasurementMeta(new MeasurementSchema(path.getMeasurement(), dataType, encoding, compressionType)));
    }

    public static List<TSDataType> getSeriesTypesByPath(Collection<PartialPath> paths) throws MetadataException {
        ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
        for (PartialPath path : paths) {
            dataTypes.add(IoTDB.metaManager.getSeriesType(path));
        }
        return dataTypes;
    }

    public static List<TSDataType> getSeriesTypesByPaths(Collection<PartialPath> paths, String aggregation) throws MetadataException {
        TSDataType dataType = SchemaUtils.getAggregationType(aggregation);
        if (dataType != null) {
            return Collections.nCopies(paths.size(), dataType);
        }
        ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
        for (PartialPath path : paths) {
            dataTypes.add(IoTDB.metaManager.getSeriesType(path));
        }
        return dataTypes;
    }

    public static List<TSDataType> getAggregatedDataTypes(List<TSDataType> measurementDataType, String aggregation) throws MetadataException {
        TSDataType dataType = SchemaUtils.getAggregationType(aggregation);
        if (dataType != null) {
            return Collections.nCopies(measurementDataType.size(), dataType);
        }
        return measurementDataType;
    }

    public static TSDataType getSeriesTypeByPaths(PartialPath path) throws MetadataException {
        return IoTDB.metaManager.getSeriesType(path);
    }

    public static List<TSDataType> getSeriesTypesByPaths(List<PartialPath> paths, List<String> aggregations) throws MetadataException {
        ArrayList<TSDataType> tsDataTypes = new ArrayList<TSDataType>();
        for (int i = 0; i < paths.size(); ++i) {
            String aggrStr = aggregations != null ? aggregations.get(i) : null;
            TSDataType dataType = SchemaUtils.getAggregationType(aggrStr);
            if (dataType != null) {
                tsDataTypes.add(dataType);
                continue;
            }
            tsDataTypes.add(IoTDB.metaManager.getSeriesType(paths.get(i)));
        }
        return tsDataTypes;
    }

    public static TSDataType getAggregationType(String aggregation) throws MetadataException {
        if (aggregation == null) {
            return null;
        }
        switch (aggregation.toLowerCase()) {
            case "min_time": 
            case "max_time": 
            case "count": {
                return TSDataType.INT64;
            }
            case "last_value": 
            case "first_value": 
            case "min_value": 
            case "max_value": {
                return null;
            }
            case "avg": 
            case "sum": {
                return TSDataType.DOUBLE;
            }
        }
        throw new MetadataException("aggregate does not support " + aggregation + " function.");
    }

    public static Throwable findMetaMissingException(Throwable currEx) {
        while (true) {
            if (currEx instanceof PathNotExistException || currEx instanceof StorageGroupNotSetException) {
                return currEx;
            }
            if (currEx.getCause() == null) break;
            currEx = currEx.getCause();
        }
        return null;
    }

    public static void checkDataTypeWithEncoding(TSDataType dataType, TSEncoding encoding) throws MetadataException {
        if (!schemaChecker.get(dataType).contains(encoding)) {
            throw new MetadataException(String.format("encoding %s does not support %s", dataType.toString(), encoding.toString()));
        }
    }

    static {
        HashSet<TSEncoding> booleanSet = new HashSet<TSEncoding>();
        booleanSet.add(TSEncoding.PLAIN);
        booleanSet.add(TSEncoding.RLE);
        schemaChecker.put(TSDataType.BOOLEAN, booleanSet);
        HashSet<TSEncoding> intSet = new HashSet<TSEncoding>();
        intSet.add(TSEncoding.PLAIN);
        intSet.add(TSEncoding.RLE);
        intSet.add(TSEncoding.TS_2DIFF);
        intSet.add(TSEncoding.REGULAR);
        intSet.add(TSEncoding.GORILLA);
        schemaChecker.put(TSDataType.INT32, intSet);
        schemaChecker.put(TSDataType.INT64, intSet);
        HashSet<TSEncoding> floatSet = new HashSet<TSEncoding>();
        floatSet.add(TSEncoding.PLAIN);
        floatSet.add(TSEncoding.RLE);
        floatSet.add(TSEncoding.TS_2DIFF);
        floatSet.add(TSEncoding.GORILLA_V1);
        floatSet.add(TSEncoding.GORILLA);
        schemaChecker.put(TSDataType.FLOAT, floatSet);
        schemaChecker.put(TSDataType.DOUBLE, floatSet);
        HashSet<TSEncoding> textSet = new HashSet<TSEncoding>();
        textSet.add(TSEncoding.PLAIN);
        schemaChecker.put(TSDataType.TEXT, textSet);
        logger = LoggerFactory.getLogger(SchemaUtils.class);
    }
}

