/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp;

import java.time.ZoneId;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.exception.query.LogicalOperatorException;
import org.apache.iotdb.db.exception.query.PathNumOverLimitException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.logical.crud.BasicFunctionOperator;
import org.apache.iotdb.db.qp.logical.crud.FilterOperator;
import org.apache.iotdb.db.qp.logical.crud.FromOperator;
import org.apache.iotdb.db.qp.logical.crud.QueryOperator;
import org.apache.iotdb.db.qp.logical.crud.SFWOperator;
import org.apache.iotdb.db.qp.logical.crud.SelectOperator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.strategy.LogicalGenerator;
import org.apache.iotdb.db.qp.strategy.PhysicalGenerator;
import org.apache.iotdb.db.qp.strategy.optimizer.ConcatPathOptimizer;
import org.apache.iotdb.db.qp.strategy.optimizer.DnfFilterOptimizer;
import org.apache.iotdb.db.qp.strategy.optimizer.MergeSingleFilterOptimizer;
import org.apache.iotdb.db.qp.strategy.optimizer.RemoveNotOptimizer;
import org.apache.iotdb.db.query.control.QueryResourceManager;
import org.apache.iotdb.service.rpc.thrift.TSRawDataQueryReq;

public class Planner {
    protected LogicalGenerator logicalGenerator = new LogicalGenerator();

    public PhysicalPlan parseSQLToPhysicalPlan(String sqlStr) throws QueryProcessException {
        return this.parseSQLToPhysicalPlan(sqlStr, ZoneId.systemDefault(), 1024);
    }

    public PhysicalPlan parseSQLToPhysicalPlan(String sqlStr, ZoneId zoneId, int fetchSize) throws QueryProcessException {
        Operator operator = this.logicalGenerator.generate(sqlStr, zoneId);
        int maxDeduplicatedPathNum = QueryResourceManager.getInstance().getMaxDeduplicatedPathNum(fetchSize);
        if (operator instanceof SFWOperator && ((SFWOperator)operator).isLastQuery()) {
            maxDeduplicatedPathNum = 0x7FFFFFFE;
        }
        operator = this.logicalOptimize(operator, maxDeduplicatedPathNum);
        PhysicalGenerator physicalGenerator = new PhysicalGenerator();
        return physicalGenerator.transformToPhysicalPlan(operator, fetchSize);
    }

    public PhysicalPlan rawDataQueryReqToPhysicalPlan(TSRawDataQueryReq rawDataQueryReq) throws QueryProcessException, IllegalPathException {
        List paths = rawDataQueryReq.getPaths();
        long startTime = rawDataQueryReq.getStartTime();
        long endTime = rawDataQueryReq.getEndTime();
        QueryOperator queryOp = new QueryOperator(27);
        FromOperator fromOp = new FromOperator(22);
        SelectOperator selectOp = new SelectOperator(21);
        for (String p : paths) {
            PartialPath path = new PartialPath(p);
            fromOp.addPrefixTablePath(path);
        }
        selectOp.addSelectPath(new PartialPath(""));
        queryOp.setSelectOperator(selectOp);
        queryOp.setFromOperator(fromOp);
        FilterOperator filterOp = new FilterOperator(1);
        PartialPath timePath = new PartialPath("time");
        filterOp.setSinglePath(timePath);
        HashSet<PartialPath> pathSet = new HashSet<PartialPath>();
        pathSet.add(timePath);
        filterOp.setIsSingle(true);
        filterOp.setPathSet(pathSet);
        BasicFunctionOperator left = new BasicFunctionOperator(133, timePath, Long.toString(startTime));
        BasicFunctionOperator right = new BasicFunctionOperator(134, timePath, Long.toString(endTime));
        filterOp.addChildOperator(left);
        filterOp.addChildOperator(right);
        queryOp.setFilterOperator(filterOp);
        int maxDeduplicatedPathNum = QueryResourceManager.getInstance().getMaxDeduplicatedPathNum(rawDataQueryReq.fetchSize);
        if (queryOp.isLastQuery()) {
            maxDeduplicatedPathNum = 0x7FFFFFFE;
        }
        SFWOperator op = (SFWOperator)this.logicalOptimize(queryOp, maxDeduplicatedPathNum);
        PhysicalGenerator physicalGenerator = new PhysicalGenerator();
        return physicalGenerator.transformToPhysicalPlan(op, rawDataQueryReq.fetchSize);
    }

    protected Operator logicalOptimize(Operator operator, int maxDeduplicatedPathNum) throws LogicalOperatorException, PathNumOverLimitException {
        switch (operator.getType()) {
            case AUTHOR: 
            case METADATA: 
            case SET_STORAGE_GROUP: 
            case DELETE_STORAGE_GROUP: 
            case CREATE_TIMESERIES: 
            case DELETE_TIMESERIES: 
            case ALTER_TIMESERIES: 
            case LOADDATA: 
            case INSERT: 
            case INDEX: 
            case INDEXQUERY: 
            case GRANT_WATERMARK_EMBEDDING: 
            case REVOKE_WATERMARK_EMBEDDING: 
            case TTL: 
            case LOAD_CONFIGURATION: 
            case SHOW: 
            case LOAD_FILES: 
            case REMOVE_FILE: 
            case MOVE_FILE: 
            case FLUSH: 
            case MERGE: 
            case TRACING: 
            case CLEAR_CACHE: 
            case NULL: 
            case SHOW_MERGE_STATUS: 
            case DELETE_PARTITION: 
            case CREATE_SCHEMA_SNAPSHOT: {
                return operator;
            }
            case QUERY: 
            case UPDATE: 
            case DELETE: {
                SFWOperator root = (SFWOperator)operator;
                return this.optimizeSFWOperator(root, maxDeduplicatedPathNum);
            }
        }
        throw new LogicalOperatorException(operator.getType().toString(), "");
    }

    private SFWOperator optimizeSFWOperator(SFWOperator root, int maxDeduplicatedPathNum) throws LogicalOperatorException, PathNumOverLimitException {
        ConcatPathOptimizer concatPathOptimizer = this.getConcatPathOptimizer();
        root = (SFWOperator)concatPathOptimizer.transform(root, maxDeduplicatedPathNum);
        FilterOperator filter = root.getFilterOperator();
        if (filter == null) {
            return root;
        }
        Set<PartialPath> pathSet = filter.getPathSet();
        RemoveNotOptimizer removeNot = new RemoveNotOptimizer();
        filter = removeNot.optimize(filter);
        DnfFilterOptimizer dnf = new DnfFilterOptimizer();
        filter = dnf.optimize(filter);
        MergeSingleFilterOptimizer merge = new MergeSingleFilterOptimizer();
        filter = merge.optimize(filter);
        root.setFilterOperator(filter);
        filter.setPathSet(pathSet);
        return root;
    }

    protected ConcatPathOptimizer getConcatPathOptimizer() {
        return new ConcatPathOptimizer();
    }
}

