/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.control;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.db.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.service.IService;
import org.apache.iotdb.db.service.ServiceType;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.UnClosedTsFileReader;
import org.apache.iotdb.tsfile.v1.read.TsFileSequenceReaderForV1;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileReaderManager
implements IService {
    private static final Logger logger = LoggerFactory.getLogger(FileReaderManager.class);
    private static final Logger resourceLogger = LoggerFactory.getLogger((String)"FileMonitor");
    private static final int MAX_CACHED_FILE_SIZE = 30000;
    private Map<String, TsFileSequenceReader> closedFileReaderMap = new ConcurrentHashMap<String, TsFileSequenceReader>();
    private Map<String, TsFileSequenceReader> unclosedFileReaderMap = new ConcurrentHashMap<String, TsFileSequenceReader>();
    private Map<String, AtomicInteger> closedReferenceMap = new ConcurrentHashMap<String, AtomicInteger>();
    private Map<String, AtomicInteger> unclosedReferenceMap = new ConcurrentHashMap<String, AtomicInteger>();
    private ScheduledExecutorService executorService = IoTDBThreadPoolFactory.newScheduledThreadPool(1, "open-files-manager");

    private FileReaderManager() {
        this.clearUnUsedFilesInFixTime();
    }

    public static FileReaderManager getInstance() {
        return FileReaderManagerHelper.INSTANCE;
    }

    public synchronized void closeFileAndRemoveReader(String filePath) throws IOException {
        this.closedReferenceMap.remove(filePath);
        TsFileSequenceReader reader = this.closedFileReaderMap.remove(filePath);
        if (reader != null) {
            reader.close();
        }
        this.unclosedReferenceMap.remove(filePath);
        reader = this.unclosedFileReaderMap.remove(filePath);
        if (reader != null) {
            reader.close();
        }
    }

    private void clearUnUsedFilesInFixTime() {
        long examinePeriod = IoTDBDescriptor.getInstance().getConfig().getCacheFileReaderClearPeriod();
        this.executorService.scheduleAtFixedRate(() -> {
            FileReaderManager fileReaderManager = this;
            synchronized (fileReaderManager) {
                this.clearMap(this.closedFileReaderMap, this.closedReferenceMap);
                this.clearMap(this.unclosedFileReaderMap, this.unclosedReferenceMap);
            }
        }, 0L, examinePeriod, TimeUnit.MILLISECONDS);
    }

    private void clearMap(Map<String, TsFileSequenceReader> readerMap, Map<String, AtomicInteger> refMap) {
        Iterator<Map.Entry<String, TsFileSequenceReader>> iterator = readerMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, TsFileSequenceReader> entry = iterator.next();
            TsFileSequenceReader reader = entry.getValue();
            AtomicInteger refAtom = refMap.get(entry.getKey());
            if (refAtom == null || refAtom.get() != 0) continue;
            try {
                reader.close();
            }
            catch (IOException e) {
                logger.error("Can not close TsFileSequenceReader {} !", (Object)reader.getFileName(), (Object)e);
            }
            iterator.remove();
            refMap.remove(entry.getKey());
            if (!resourceLogger.isDebugEnabled()) continue;
            resourceLogger.debug("{} TsFileReader is closed because of no reference.", (Object)entry.getKey());
        }
    }

    public synchronized TsFileSequenceReader get(String filePath, boolean isClosed) throws IOException {
        Map<String, TsFileSequenceReader> readerMap;
        Map<String, TsFileSequenceReader> map = readerMap = !isClosed ? this.unclosedFileReaderMap : this.closedFileReaderMap;
        if (!readerMap.containsKey(filePath)) {
            if (readerMap.size() >= 30000) {
                logger.warn("Query has opened {} files !", (Object)readerMap.size());
            }
            UnClosedTsFileReader tsFileReader = null;
            if (!isClosed) {
                tsFileReader = new UnClosedTsFileReader(filePath);
            } else {
                tsFileReader = new TsFileSequenceReader(filePath);
                switch (tsFileReader.readVersionNumber()) {
                    case "000001": {
                        tsFileReader.close();
                        tsFileReader = new TsFileSequenceReaderForV1(filePath);
                        break;
                    }
                    case "000002": {
                        break;
                    }
                    default: {
                        throw new IOException("The version of this TsFile is not corrent. ");
                    }
                }
            }
            readerMap.put(filePath, (TsFileSequenceReader)tsFileReader);
            return tsFileReader;
        }
        return readerMap.get(filePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void increaseFileReaderReference(TsFileResource tsFile, boolean isClosed) {
        tsFile.readLock();
        FileReaderManager fileReaderManager = this;
        synchronized (fileReaderManager) {
            if (!isClosed) {
                this.unclosedReferenceMap.computeIfAbsent(tsFile.getTsFilePath(), k -> new AtomicInteger()).getAndIncrement();
            } else {
                this.closedReferenceMap.computeIfAbsent(tsFile.getTsFilePath(), k -> new AtomicInteger()).getAndIncrement();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void decreaseFileReaderReference(TsFileResource tsFile, boolean isClosed) {
        FileReaderManager fileReaderManager = this;
        synchronized (fileReaderManager) {
            if (!isClosed && this.unclosedReferenceMap.containsKey(tsFile.getTsFilePath())) {
                this.unclosedReferenceMap.get(tsFile.getTsFilePath()).decrementAndGet();
            } else if (this.closedReferenceMap.containsKey(tsFile.getTsFilePath())) {
                this.closedReferenceMap.get(tsFile.getTsFilePath()).decrementAndGet();
            }
        }
        tsFile.readUnlock();
    }

    public synchronized void closeAndRemoveAllOpenedReaders() throws IOException {
        Map.Entry<String, TsFileSequenceReader> entry;
        Iterator<Map.Entry<String, TsFileSequenceReader>> iterator = this.closedFileReaderMap.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            entry.getValue().close();
            if (resourceLogger.isDebugEnabled()) {
                resourceLogger.debug("{} closedTsFileReader is closed.", (Object)entry.getKey());
            }
            this.closedReferenceMap.remove(entry.getKey());
            iterator.remove();
        }
        iterator = this.unclosedFileReaderMap.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            entry.getValue().close();
            if (resourceLogger.isDebugEnabled()) {
                resourceLogger.debug("{} unclosedTsFileReader is closed.", (Object)entry.getKey());
            }
            this.unclosedReferenceMap.remove(entry.getKey());
            iterator.remove();
        }
    }

    public synchronized boolean contains(TsFileResource tsFile, boolean isClosed) {
        return isClosed && this.closedFileReaderMap.containsKey(tsFile.getTsFilePath()) || !isClosed && this.unclosedFileReaderMap.containsKey(tsFile.getTsFilePath());
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
        if (this.executorService == null || this.executorService.isShutdown()) {
            return;
        }
        this.executorService.shutdown();
        try {
            this.executorService.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            logger.error("StatMonitor timing service could not be shutdown.", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public ServiceType getID() {
        return ServiceType.FILE_READER_MANAGER_SERVICE;
    }

    private static class FileReaderManagerHelper {
        private static final FileReaderManager INSTANCE = new FileReaderManager();

        private FileReaderManagerHelper() {
        }
    }
}

