/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.executor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.engine.querycontext.QueryDataSource;
import org.apache.iotdb.db.engine.storagegroup.StorageGroupProcessor;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.metadata.mnode.MeasurementMNode;
import org.apache.iotdb.db.qp.physical.crud.LastQueryPlan;
import org.apache.iotdb.db.qp.physical.crud.RawDataQueryPlan;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.control.QueryResourceManager;
import org.apache.iotdb.db.query.dataset.ListDataSet;
import org.apache.iotdb.db.query.executor.fill.LastPointReader;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.common.Field;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.iotdb.tsfile.read.expression.IExpression;
import org.apache.iotdb.tsfile.read.expression.impl.GlobalTimeExpression;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.Pair;

public class LastQueryExecutor {
    private List<PartialPath> selectedSeries;
    private List<TSDataType> dataTypes;
    private IExpression expression;
    private static final boolean lastCacheEnabled = IoTDBDescriptor.getInstance().getConfig().isLastCacheEnabled();

    public LastQueryExecutor(LastQueryPlan lastQueryPlan) {
        this.selectedSeries = lastQueryPlan.getDeduplicatedPaths();
        this.dataTypes = lastQueryPlan.getDeduplicatedDataTypes();
        this.expression = lastQueryPlan.getExpression();
    }

    public LastQueryExecutor(List<PartialPath> selectedSeries, List<TSDataType> dataTypes) {
        this.selectedSeries = selectedSeries;
        this.dataTypes = dataTypes;
    }

    public QueryDataSet execute(QueryContext context, LastQueryPlan lastQueryPlan) throws StorageEngineException, IOException, QueryProcessException {
        ListDataSet dataSet = new ListDataSet(Arrays.asList(new PartialPath("timeseries", false), new PartialPath("value", false)), Arrays.asList(TSDataType.TEXT, TSDataType.TEXT));
        List<Pair<Boolean, TimeValuePair>> lastPairList = LastQueryExecutor.calculateLastPairForSeriesLocally(this.selectedSeries, this.dataTypes, context, this.expression, lastQueryPlan);
        for (int i = 0; i < lastPairList.size(); ++i) {
            if (lastPairList.get((int)i).right == null || ((TimeValuePair)lastPairList.get((int)i).right).getValue() == null) continue;
            TimeValuePair lastTimeValuePair = (TimeValuePair)lastPairList.get((int)i).right;
            RowRecord resultRecord = new RowRecord(lastTimeValuePair.getTimestamp());
            Field pathField = new Field(TSDataType.TEXT);
            if (this.selectedSeries.get(i).getTsAlias() != null) {
                pathField.setBinaryV(new Binary(this.selectedSeries.get(i).getTsAlias()));
            } else if (this.selectedSeries.get(i).getMeasurementAlias() != null) {
                pathField.setBinaryV(new Binary(this.selectedSeries.get(i).getFullPathWithAlias()));
            } else {
                pathField.setBinaryV(new Binary(this.selectedSeries.get(i).getFullPath()));
            }
            resultRecord.addField(pathField);
            Field valueField = new Field(TSDataType.TEXT);
            valueField.setBinaryV(new Binary(lastTimeValuePair.getValue().getStringValue()));
            resultRecord.addField(valueField);
            dataSet.putRecord(resultRecord);
        }
        if (!lastQueryPlan.isAscending()) {
            dataSet.sortByTime();
        }
        return dataSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Pair<Boolean, TimeValuePair>> calculateLastPairForSeriesLocally(List<PartialPath> seriesPaths, List<TSDataType> dataTypes, QueryContext context, IExpression expression, RawDataQueryPlan lastQueryPlan) throws QueryProcessException, StorageEngineException, IOException {
        ArrayList<LastCacheAccessor> cacheAccessors = new ArrayList<LastCacheAccessor>();
        Filter filter = expression == null ? null : ((GlobalTimeExpression)expression).getFilter();
        ArrayList<PartialPath> restPaths = new ArrayList<PartialPath>();
        List<Pair<Boolean, TimeValuePair>> resultContainer = LastQueryExecutor.readLastPairsFromCache(seriesPaths, filter, cacheAccessors, restPaths);
        if (filter != null || restPaths.isEmpty()) {
            return resultContainer;
        }
        ArrayList<LastPointReader> readerList = new ArrayList<LastPointReader>();
        List<StorageGroupProcessor> list = StorageEngine.getInstance().mergeLock(restPaths);
        try {
            for (int i = 0; i < restPaths.size(); ++i) {
                QueryDataSource dataSource = QueryResourceManager.getInstance().getQueryDataSource(seriesPaths.get(i), context, null);
                LastPointReader lastReader = new LastPointReader(seriesPaths.get(i), dataTypes.get(i), lastQueryPlan.getAllMeasurementsInDevice(seriesPaths.get(i).getDevice()), context, dataSource, Long.MAX_VALUE, null);
                readerList.add(lastReader);
            }
        }
        finally {
            StorageEngine.getInstance().mergeUnLock(list);
        }
        int index = 0;
        for (int i = 0; i < resultContainer.size(); ++i) {
            if (!Boolean.FALSE.equals(resultContainer.get((int)i).left)) continue;
            resultContainer.get((int)i).right = ((LastPointReader)readerList.get(index++)).readLastPoint();
            if (((TimeValuePair)resultContainer.get((int)i).right).getValue() == null) continue;
            resultContainer.get((int)i).left = true;
            if (!lastCacheEnabled) continue;
            ((LastCacheAccessor)cacheAccessors.get(i)).write((TimeValuePair)resultContainer.get((int)i).right);
        }
        return resultContainer;
    }

    private static List<Pair<Boolean, TimeValuePair>> readLastPairsFromCache(List<PartialPath> seriesPaths, Filter filter, List<LastCacheAccessor> cacheAccessors, List<PartialPath> restPaths) {
        ArrayList<Pair<Boolean, TimeValuePair>> resultContainer = new ArrayList<Pair<Boolean, TimeValuePair>>();
        if (lastCacheEnabled) {
            for (PartialPath path : seriesPaths) {
                cacheAccessors.add(new LastCacheAccessor(path, filter));
            }
        } else {
            restPaths.addAll(seriesPaths);
        }
        for (int i = 0; i < cacheAccessors.size(); ++i) {
            TimeValuePair tvPair = cacheAccessors.get(i).read();
            if (tvPair != null) {
                resultContainer.add((Pair<Boolean, TimeValuePair>)new Pair((Object)true, (Object)tvPair));
                continue;
            }
            resultContainer.add((Pair<Boolean, TimeValuePair>)new Pair((Object)false, null));
            restPaths.add(seriesPaths.get(i));
        }
        return resultContainer;
    }

    private static boolean satisfyFilter(Filter filter, TimeValuePair tvPair) {
        return filter == null || filter.satisfy(tvPair.getTimestamp(), tvPair.getValue().getValue());
    }

    private static class LastCacheAccessor {
        private PartialPath path;
        private Filter filter;
        private MeasurementMNode node;

        LastCacheAccessor(PartialPath seriesPath) {
            this.path = seriesPath;
        }

        LastCacheAccessor(PartialPath seriesPath, Filter filter) {
            this.path = seriesPath;
            this.filter = filter;
        }

        public TimeValuePair read() {
            block6: {
                try {
                    this.node = (MeasurementMNode)IoTDB.metaManager.getNodeByPath(this.path);
                }
                catch (MetadataException e) {
                    TimeValuePair timeValuePair = IoTDB.metaManager.getLastCache(this.path);
                    if (timeValuePair != null && LastQueryExecutor.satisfyFilter(this.filter, timeValuePair)) {
                        return timeValuePair;
                    }
                    if (timeValuePair == null) break block6;
                    return null;
                }
            }
            if (this.node != null && this.node.getCachedLast() != null) {
                TimeValuePair timeValuePair = this.node.getCachedLast();
                if (timeValuePair != null && LastQueryExecutor.satisfyFilter(this.filter, timeValuePair)) {
                    return timeValuePair;
                }
                if (timeValuePair != null) {
                    return null;
                }
            }
            return null;
        }

        public void write(TimeValuePair pair) {
            IoTDB.metaManager.updateLastCache(this.path, pair, false, Long.MIN_VALUE, this.node);
        }
    }
}

