/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.reader.universal;

import java.io.IOException;
import java.util.List;
import java.util.PriorityQueue;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.reader.IPointReader;

public class PriorityMergeReader
implements IPointReader {
    protected long currentReadStopTime;
    protected PriorityQueue<Element> heap;

    public PriorityMergeReader() {
        this.heap = new PriorityQueue((o1, o2) -> {
            int timeCompare = Long.compare(o1.timeValuePair.getTimestamp(), o2.timeValuePair.getTimestamp());
            return timeCompare != 0 ? timeCompare : Long.compare(o2.priority, o1.priority);
        });
    }

    public PriorityMergeReader(List<IPointReader> prioritySeriesReaders, int startPriority) throws IOException {
        this.heap = new PriorityQueue((o1, o2) -> {
            int timeCompare = Long.compare(o1.timeValuePair.getTimestamp(), o2.timeValuePair.getTimestamp());
            return timeCompare != 0 ? timeCompare : Long.compare(o2.priority, o1.priority);
        });
        for (IPointReader reader : prioritySeriesReaders) {
            this.addReader(reader, startPriority++);
        }
    }

    public void addReader(IPointReader reader, long priority) throws IOException {
        if (reader.hasNextTimeValuePair()) {
            this.heap.add(new Element(reader, reader.nextTimeValuePair(), priority));
        } else {
            reader.close();
        }
    }

    public void addReader(IPointReader reader, long priority, long endTime) throws IOException {
        if (reader.hasNextTimeValuePair()) {
            this.heap.add(new Element(reader, reader.nextTimeValuePair(), priority));
            this.currentReadStopTime = Math.max(this.currentReadStopTime, endTime);
        } else {
            reader.close();
        }
    }

    public long getCurrentReadStopTime() {
        return this.currentReadStopTime;
    }

    public boolean hasNextTimeValuePair() {
        return !this.heap.isEmpty();
    }

    public TimeValuePair nextTimeValuePair() throws IOException {
        Element top = this.heap.poll();
        TimeValuePair ret = top.timeValuePair;
        TimeValuePair topNext = null;
        if (top.hasNext()) {
            top.next();
            topNext = top.currPair();
        }
        long topNextTime = topNext == null ? Long.MAX_VALUE : topNext.getTimestamp();
        this.updateHeap(ret.getTimestamp(), topNextTime);
        if (topNext != null) {
            top.timeValuePair = topNext;
            this.heap.add(top);
        }
        return ret;
    }

    public TimeValuePair currentTimeValuePair() throws IOException {
        return this.heap.peek().timeValuePair;
    }

    private void updateHeap(long topTime, long topNextTime) throws IOException {
        while (!this.heap.isEmpty() && this.heap.peek().currTime() == topTime) {
            Element e = this.heap.poll();
            if (!e.hasNext()) {
                e.reader.close();
                continue;
            }
            e.next();
            if (e.currTime() == topNextTime) {
                if (e.hasNext()) {
                    e.next();
                    this.heap.add(e);
                    continue;
                }
                e.close();
                continue;
            }
            this.heap.add(e);
        }
    }

    public void close() throws IOException {
        while (!this.heap.isEmpty()) {
            Element e = this.heap.poll();
            e.close();
        }
    }

    static class Element {
        IPointReader reader;
        TimeValuePair timeValuePair;
        long priority;

        Element(IPointReader reader, TimeValuePair timeValuePair, long priority) {
            this.reader = reader;
            this.timeValuePair = timeValuePair;
            this.priority = priority;
        }

        long currTime() {
            return this.timeValuePair.getTimestamp();
        }

        TimeValuePair currPair() {
            return this.timeValuePair;
        }

        boolean hasNext() throws IOException {
            return this.reader.hasNextTimeValuePair();
        }

        void next() throws IOException {
            this.timeValuePair = this.reader.nextTimeValuePair();
        }

        void close() throws IOException {
            this.reader.close();
        }
    }
}

