/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.tsfile.common.cache.Cache;
import org.apache.iotdb.tsfile.exception.cache.CacheException;

public abstract class RandomDeleteCache<K, V>
implements Cache<K, V> {
    private int cacheSize;
    private Map<K, V> cache;

    public RandomDeleteCache(int cacheSize) {
        this.cacheSize = cacheSize;
        this.cache = new ConcurrentHashMap();
    }

    public V get(K key) throws CacheException {
        V v = this.cache.get(key);
        if (v == null) {
            this.randomRemoveObjectIfCacheIsFull();
            this.cache.put(key, this.loadObjectByKey(key));
            v = this.cache.get(key);
        }
        return v;
    }

    private void randomRemoveObjectIfCacheIsFull() {
        if (this.cache.size() == this.cacheSize) {
            this.removeFirstObject();
        }
    }

    private void removeFirstObject() {
        if (this.cache.size() == 0) {
            return;
        }
        K key = this.cache.keySet().iterator().next();
        this.cache.remove(key);
    }

    public abstract V loadObjectByKey(K var1) throws CacheException;

    public void removeObject(K key) {
        this.cache.remove(key);
    }

    public void clear() {
        this.cache.clear();
    }

    public int size() {
        return this.cache.size();
    }
}

