/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.auth.authorizer;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.Jwts;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.Key;
import java.security.interfaces.RSAPublicKey;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.UUID;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import org.apache.iotdb.db.auth.AuthException;
import org.apache.iotdb.db.auth.authorizer.BasicAuthorizer;
import org.apache.iotdb.db.auth.entity.Role;
import org.apache.iotdb.db.auth.entity.User;
import org.apache.iotdb.db.auth.role.LocalFileRoleManager;
import org.apache.iotdb.db.auth.user.LocalFileUserManager;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenIdAuthorizer
extends BasicAuthorizer {
    private static final Logger logger = LoggerFactory.getLogger(OpenIdAuthorizer.class);
    public static final String IOTDB_ADMIN_ROLE_NAME = "iotdb_admin";
    public static final String OPENID_USER_PREFIX = "openid-";
    private static IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private RSAPublicKey providerKey;
    private Map<String, Claims> loggedClaims = new HashMap<String, Claims>();

    public OpenIdAuthorizer() throws AuthException, ParseException, IOException, URISyntaxException {
        this(config.getOpenIdProviderUrl());
    }

    OpenIdAuthorizer(JSONObject jwk) throws AuthException {
        super(new LocalFileUserManager(config.getSystemDir() + File.separator + "users"), new LocalFileRoleManager(config.getSystemDir() + File.separator + "roles"));
        try {
            this.providerKey = RSAKey.parse((JSONObject)jwk).toRSAPublicKey();
        }
        catch (JOSEException | java.text.ParseException e) {
            throw new AuthException("Unable to get OIDC Provider Key from JWK " + jwk.toString(), e);
        }
        logger.info("Initialized with providerKey: {}", (Object)this.providerKey);
    }

    OpenIdAuthorizer(String providerUrl) throws AuthException, URISyntaxException, ParseException, IOException {
        this(OpenIdAuthorizer.getJWKfromProvider(providerUrl));
    }

    private static JSONObject getJWKfromProvider(String providerUrl) throws URISyntaxException, IOException, ParseException, AuthException {
        if (providerUrl == null) {
            throw new IllegalArgumentException("OpenID Connect Provider URI must be given!");
        }
        OIDCProviderMetadata providerMetadata = OpenIdAuthorizer.fetchMetadata(providerUrl);
        logger.debug("Using Provider Metadata: {}", (Object)providerMetadata);
        try {
            URL url = new URI(providerMetadata.getJWKSetURI().toString().replace("http", "https")).toURL();
            logger.debug("Using url {}", (Object)url);
            return OpenIdAuthorizer.getProviderRSAJWK(url.openStream());
        }
        catch (IOException e) {
            throw new AuthException("Unable to start the Auth", e);
        }
    }

    private static JSONObject getProviderRSAJWK(InputStream is) throws ParseException {
        StringBuilder sb = new StringBuilder();
        try (Scanner scanner = new Scanner(is);){
            while (scanner.hasNext()) {
                sb.append(scanner.next());
            }
        }
        String jsonString = sb.toString();
        JSONObject json = JSONObjectUtils.parse((String)jsonString);
        JSONArray keyList = (JSONArray)json.get((Object)"keys");
        for (Object key : keyList) {
            JSONObject k = (JSONObject)key;
            if (!k.get((Object)"use").equals("sig") || !k.get((Object)"kty").equals("RSA")) continue;
            return k;
        }
        return null;
    }

    static OIDCProviderMetadata fetchMetadata(String providerUrl) throws URISyntaxException, IOException, ParseException {
        URI issuerURI = new URI(providerUrl);
        URL providerConfigurationURL = issuerURI.resolve(".well-known/openid-configuration").toURL();
        InputStream stream = providerConfigurationURL.openStream();
        String providerInfo = null;
        try (Scanner s = new Scanner(stream);){
            providerInfo = s.useDelimiter("\\A").hasNext() ? s.next() : "";
        }
        return OIDCProviderMetadata.parse((String)providerInfo);
    }

    @Override
    public boolean login(String token, String password) throws AuthException {
        Claims claims;
        if (password != null && !password.isEmpty()) {
            logger.error("JWT Login failed as a non-empty Password was given username (token): {}, password: {}", (Object)token, (Object)password);
            return false;
        }
        if (token == null || token.isEmpty()) {
            logger.error("JWT Login failed as a Username (token) was empty!");
            return false;
        }
        try {
            claims = this.validateToken(token);
        }
        catch (JwtException e) {
            logger.error("Unable to login the user wit jwt {}", (Object)password, (Object)e);
            return false;
        }
        logger.debug("JWT was validated successfully!");
        logger.debug("ID: {}", (Object)claims.getId());
        logger.debug("Subject: {}", (Object)claims.getSubject());
        logger.debug("Issuer: {}", (Object)claims.getIssuer());
        logger.debug("Expiration: {}", (Object)claims.getExpiration());
        String iotdbUsername = this.getUsername(claims);
        if (!super.listAllUsers().contains(iotdbUsername)) {
            logger.info("User {} logs in for first time, storing it locally!", (Object)iotdbUsername);
            super.createUser(iotdbUsername, UUID.randomUUID().toString());
        }
        this.loggedClaims.put(this.getUsername(claims), claims);
        return true;
    }

    private Claims validateToken(String token) {
        return (Claims)Jwts.parser().setAllowedClockSkewSeconds(9223372036854775L).setSigningKey((Key)this.providerKey).parseClaimsJws(token).getBody();
    }

    private String getUsername(Claims claims) {
        return OPENID_USER_PREFIX + claims.getSubject();
    }

    private String getUsername(String token) {
        return this.getUsername(this.validateToken(token));
    }

    @Override
    public void createUser(String username, String password) throws AuthException {
        this.throwUnsupportedOperationException();
    }

    private void throwUnsupportedOperationException() {
        throw new UnsupportedOperationException("This operation is not supported for JWT Auth Provider!");
    }

    @Override
    public void deleteUser(String username) throws AuthException {
        this.throwUnsupportedOperationException();
    }

    @Override
    boolean isAdmin(String token) {
        Claims claims;
        if (this.loggedClaims.containsKey(token)) {
            claims = this.loggedClaims.get(token);
        } else {
            try {
                claims = this.validateToken(token);
            }
            catch (JwtException e) {
                logger.warn("Unable to validate token {}!", (Object)token, (Object)e);
                return false;
            }
        }
        List availableRoles = (List)((Map)claims.get((Object)"realm_access")).get("roles");
        if (!availableRoles.contains(IOTDB_ADMIN_ROLE_NAME)) {
            logger.warn("Given Token has no admin rights, is there a ROLE with name {} in 'realm_access' role set?", (Object)IOTDB_ADMIN_ROLE_NAME);
            return false;
        }
        return true;
    }

    @Override
    public boolean checkUserPrivileges(String username, String path, int privilegeId) throws AuthException {
        if (this.isAdmin(username)) {
            return true;
        }
        User user = this.userManager.getUser(this.getUsername(username));
        if (user == null) {
            throw new AuthException(String.format("No such user : %s", this.getUsername(username)));
        }
        if (user.checkPrivilege(path, privilegeId)) {
            return true;
        }
        for (String roleName : user.getRoleList()) {
            Role role = this.roleManager.getRole(roleName);
            if (!role.checkPrivilege(path, privilegeId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void updateUserPassword(String username, String newPassword) throws AuthException {
        this.throwUnsupportedOperationException();
    }
}

