/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metrics.ui;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.MetricRegistry;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.iotdb.db.conf.IoTDBConstant;
import org.apache.iotdb.db.metrics.server.SqlArgument;
import org.apache.iotdb.db.service.TSServiceImpl;
import org.apache.iotdb.service.rpc.thrift.TSExecuteStatementResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsPage {
    private static final Logger logger = LoggerFactory.getLogger(MetricsPage.class);
    private MetricRegistry mr;
    private final List<SqlArgument> sqlArguments = TSServiceImpl.getSqlArgumentList();

    public MetricsPage(MetricRegistry metricRegistry) {
        this.mr = metricRegistry;
    }

    public String render() {
        String html = "";
        String tmpStr = "";
        try {
            URL resource = MetricsPage.class.getClassLoader().getResource("iotdb/ui/static/index.html");
            try (InputStream is = resource.openStream();
                 BufferedReader br = new BufferedReader(new InputStreamReader(is));){
                while ((tmpStr = br.readLine()) != null) {
                    html = html + tmpStr;
                }
            }
        }
        catch (IOException e) {
            logger.error("Response page failed", (Throwable)e);
        }
        html = html.replace("{version}", IoTDBConstant.VERSION);
        html = html.replace("{server}", ((Gauge)this.mr.getGauges().get("iot-metrics.host")).getValue() + ":" + ((Gauge)this.mr.getGauges().get("iot-metrics.port")).getValue());
        int cpuRatio = (Integer)((Gauge)this.mr.getGauges().get("iot-metrics.cpu_ratio")).getValue();
        String os = System.getProperty("os.name");
        html = cpuRatio != 500 ? html.replace("{cpu}", ((Gauge)this.mr.getGauges().get("iot-metrics.cores")).getValue() + " Total, " + cpuRatio + "% CPU Ratio") : html.replace("{cpu}", ((Gauge)this.mr.getGauges().get("iot-metrics.cores")).getValue() + " Total  <font color=\"red\">can't get the cpu ratio,because this OS:[" + os + "] is not support</font>");
        html = html.replace("{jvm_mem}", ((Gauge)this.mr.getGauges().get("iot-metrics.max_memory")).getValue() + "  " + ((Gauge)this.mr.getGauges().get("iot-metrics.total_memory")).getValue() + "  " + ((Gauge)this.mr.getGauges().get("iot-metrics.free_memory")).getValue() + " (Max/Total/Free)MB");
        html = html.replace("{host_mem}", String.format("%.0f", (double)((Integer)((Gauge)this.mr.getGauges().get("iot-metrics.totalPhysical_memory")).getValue()).intValue() / 1024.0) + " GB Total,  " + String.format("%.1f", (double)((Integer)((Gauge)this.mr.getGauges().get("iot-metrics.usedPhysical_memory")).getValue()).intValue() / 1024.0) + " GB Used");
        html = html.replace("{sql_table}", this.sqlRow());
        return html;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBuilder sqlRow() {
        StringBuilder table = new StringBuilder();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss:SSS");
        List<SqlArgument> list = this.sqlArguments;
        synchronized (list) {
            for (int i = this.sqlArguments.size() - 1; i >= 0; --i) {
                SqlArgument sqlArgument = this.sqlArguments.get(i);
                TSExecuteStatementResp resp = sqlArgument.getTSExecuteStatementResp();
                String errMsg = resp.getStatus().message;
                int statusCode = resp.getStatus().code;
                String status = statusCode == 200 ? "FINISHED" : (statusCode == 201 ? "EXECUTING" : (statusCode == 202 ? "INVALID_HANDLE" : "FAILED"));
                table.append("<tr><td>" + resp.getOperationType() + "</td><td>" + sdf.format(new Date(sqlArgument.getStartTime())) + "</td><td>" + sdf.format(new Date(sqlArgument.getEndTime())) + "</td><td>" + (int)(sqlArgument.getEndTime() - sqlArgument.getStartTime()) + " ms</td><td class=\"sql\">" + sqlArgument.getStatement() + "</td><td>" + status + "</td><td>" + (errMsg.equals("") ? "== Parsed Physical Plan ==" : errMsg) + "<span class=\"expand-details\" onclick=\"this.parentNode.querySelector('.stacktrace-details').classList.toggle('collapsed')\">+ details</span><div class=\"stacktrace-details collapsed\"><pre>Physical Plan: " + sqlArgument.getPlan().getClass().getSimpleName() + "</br>===========================</br>OperatorType: " + (Object)((Object)sqlArgument.getPlan().getOperatorType()) + "</br>===========================</br>Path: " + sqlArgument.getPlan().getPaths().toString() + "</pre></div></td></tr>");
            }
        }
        return table;
    }
}

