/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.executor;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.activation.UnsupportedDataTypeException;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.engine.storagegroup.StorageGroupProcessor;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.qp.physical.crud.FillQueryPlan;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.dataset.SingleDataSet;
import org.apache.iotdb.db.query.executor.fill.IFill;
import org.apache.iotdb.db.query.executor.fill.PreviousFill;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;

public class FillQueryExecutor {
    private List<PartialPath> selectedSeries;
    private List<TSDataType> dataTypes;
    private long queryTime;
    private Map<TSDataType, IFill> typeIFillMap;

    public FillQueryExecutor(List<PartialPath> selectedSeries, List<TSDataType> dataTypes, long queryTime, Map<TSDataType, IFill> typeIFillMap) {
        this.selectedSeries = selectedSeries;
        this.queryTime = queryTime;
        this.typeIFillMap = typeIFillMap;
        this.dataTypes = dataTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryDataSet execute(QueryContext context, FillQueryPlan fillQueryPlan) throws StorageEngineException, QueryProcessException, IOException {
        RowRecord record = new RowRecord(this.queryTime);
        List<StorageGroupProcessor> list = StorageEngine.getInstance().mergeLock(this.selectedSeries);
        try {
            for (int i = 0; i < this.selectedSeries.size(); ++i) {
                IFill fill;
                TSDataType dataType;
                PartialPath path;
                block10: {
                    block9: {
                        path = this.selectedSeries.get(i);
                        dataType = this.dataTypes.get(i);
                        long defaultFillInterval = IoTDBDescriptor.getInstance().getConfig().getDefaultFillInterval();
                        if (this.typeIFillMap.containsKey(dataType)) break block9;
                        switch (dataType) {
                            case INT32: 
                            case INT64: 
                            case FLOAT: 
                            case DOUBLE: 
                            case BOOLEAN: 
                            case TEXT: {
                                fill = new PreviousFill(dataType, this.queryTime, defaultFillInterval);
                                break block10;
                            }
                            default: {
                                throw new UnsupportedDataTypeException("do not support datatype " + dataType);
                            }
                        }
                    }
                    fill = this.typeIFillMap.get(dataType).copy();
                }
                fill = this.configureFill(fill, path, dataType, this.queryTime, fillQueryPlan.getAllMeasurementsInDevice(path.getDevice()), context);
                TimeValuePair timeValuePair = fill.getFillResult();
                if (timeValuePair == null || timeValuePair.getValue() == null) {
                    record.addField(null);
                    continue;
                }
                record.addField(timeValuePair.getValue().getValue(), dataType);
            }
        }
        finally {
            StorageEngine.getInstance().mergeUnLock(list);
        }
        SingleDataSet dataSet = new SingleDataSet(this.selectedSeries, this.dataTypes);
        dataSet.setRecord(record);
        return dataSet;
    }

    protected IFill configureFill(IFill fill, PartialPath path, TSDataType dataType, long queryTime, Set<String> deviceMeasurements, QueryContext context) {
        fill.configureFill(path, dataType, queryTime, deviceMeasurements, context);
        return fill;
    }
}

