/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.executor.fill;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Set;
import org.apache.iotdb.db.engine.querycontext.QueryDataSource;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.utils.FileLoaderUtils;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.reader.IPageReader;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;

public class LastPointReader {
    private PartialPath seriesPath;
    long queryTime;
    TSDataType dataType;
    private QueryContext context;
    private Set<String> deviceMeasurements;
    private Filter timeFilter;
    private QueryDataSource dataSource;
    private List<TimeseriesMetadata> unseqTimeseriesMetadataList = new ArrayList<TimeseriesMetadata>();

    public LastPointReader() {
    }

    public LastPointReader(PartialPath seriesPath, TSDataType dataType, Set<String> deviceMeasurements, QueryContext context, QueryDataSource dataSource, long queryTime, Filter timeFilter) {
        this.seriesPath = seriesPath;
        this.dataType = dataType;
        this.dataSource = dataSource;
        this.context = context;
        this.queryTime = queryTime;
        this.deviceMeasurements = deviceMeasurements;
        this.timeFilter = timeFilter;
    }

    public TimeValuePair readLastPoint() throws IOException {
        TimeValuePair lastPointResult = this.retrieveValidLastPointFromSeqFiles();
        this.UnpackOverlappedUnseqFiles(lastPointResult.getTimestamp());
        long lastVersion = 0L;
        PriorityQueue<ChunkMetadata> sortedChunkMetatdataList = this.sortUnseqChunkMetadatasByEndtime();
        while (!sortedChunkMetatdataList.isEmpty() && lastPointResult.getTimestamp() <= sortedChunkMetatdataList.peek().getEndTime()) {
            ChunkMetadata chunkMetadata = sortedChunkMetatdataList.poll();
            TimeValuePair lastChunkPoint = this.getChunkLastPoint(chunkMetadata);
            if (!this.shouldUpdate(lastPointResult.getTimestamp(), lastVersion, lastChunkPoint.getTimestamp(), chunkMetadata.getVersion())) continue;
            lastPointResult = lastChunkPoint;
            lastVersion = chunkMetadata.getVersion();
        }
        return lastPointResult;
    }

    private TimeValuePair retrieveValidLastPointFromSeqFiles() throws IOException {
        List<TsFileResource> seqFileResource = this.dataSource.getSeqResources();
        TimeValuePair lastPoint = new TimeValuePair(Long.MIN_VALUE, null);
        for (int index = seqFileResource.size() - 1; index >= 0; --index) {
            TsFileResource resource = seqFileResource.get(index);
            TimeseriesMetadata timeseriesMetadata = FileLoaderUtils.loadTimeSeriesMetadata(resource, this.seriesPath, this.context, this.timeFilter, this.deviceMeasurements);
            if (timeseriesMetadata == null) continue;
            if (!timeseriesMetadata.isModified() && this.endtimeContainedByTimeFilter(timeseriesMetadata.getStatistics())) {
                return this.constructLastPair(timeseriesMetadata.getStatistics().getEndTime(), timeseriesMetadata.getStatistics().getLastValue(), this.dataType);
            }
            List seqChunkMetadataList = timeseriesMetadata.loadChunkMetadataList();
            for (int i = seqChunkMetadataList.size() - 1; i >= 0; --i) {
                lastPoint = this.getChunkLastPoint((ChunkMetadata)seqChunkMetadataList.get(i));
                if (lastPoint.getValue() == null) continue;
                return lastPoint;
            }
        }
        return lastPoint;
    }

    private void UnpackOverlappedUnseqFiles(long lBoundTime) throws IOException {
        PriorityQueue<TsFileResource> unseqFileResource = this.sortUnSeqFileResourcesInDecendingOrder(this.dataSource.getUnseqResources());
        while (!unseqFileResource.isEmpty() && lBoundTime <= unseqFileResource.peek().getEndTime(this.seriesPath.getDevice())) {
            TimeseriesMetadata timeseriesMetadata = FileLoaderUtils.loadTimeSeriesMetadata(unseqFileResource.poll(), this.seriesPath, this.context, this.timeFilter, this.deviceMeasurements);
            if (timeseriesMetadata == null || !timeseriesMetadata.isModified() && timeseriesMetadata.getStatistics().getEndTime() < lBoundTime) continue;
            this.unseqTimeseriesMetadataList.add(timeseriesMetadata);
            if (timeseriesMetadata.isModified()) continue;
            if (this.endtimeContainedByTimeFilter(timeseriesMetadata.getStatistics())) {
                lBoundTime = Math.max(lBoundTime, timeseriesMetadata.getStatistics().getEndTime());
                continue;
            }
            lBoundTime = Math.max(lBoundTime, timeseriesMetadata.getStatistics().getStartTime());
        }
    }

    private TimeValuePair getChunkLastPoint(ChunkMetadata chunkMetaData) throws IOException {
        TimeValuePair lastPoint = new TimeValuePair(Long.MIN_VALUE, null);
        if (chunkMetaData == null) {
            return lastPoint;
        }
        Statistics chunkStatistics = chunkMetaData.getStatistics();
        if (!chunkMetaData.isModified() && this.endtimeContainedByTimeFilter(chunkStatistics)) {
            return this.constructLastPair(chunkStatistics.getEndTime(), chunkStatistics.getLastValue(), this.dataType);
        }
        List<IPageReader> pageReaders = FileLoaderUtils.loadPageReaderList(chunkMetaData, this.timeFilter);
        for (int i = pageReaders.size() - 1; i >= 0; --i) {
            IPageReader pageReader = pageReaders.get(i);
            Statistics pageStatistics = pageReader.getStatistics();
            if (!pageReader.isModified() && this.endtimeContainedByTimeFilter(pageStatistics)) {
                lastPoint = this.constructLastPair(pageStatistics.getEndTime(), pageStatistics.getLastValue(), this.dataType);
            } else {
                BatchData batchData = pageReader.getAllSatisfiedPageData();
                lastPoint = batchData.getLastPairBeforeOrEqualTimestamp(this.queryTime);
            }
            if (lastPoint.getValue() == null) continue;
            return lastPoint;
        }
        return lastPoint;
    }

    private boolean shouldUpdate(long time, long version, long newTime, long newVersion) {
        return time < newTime || time == newTime && version < newVersion;
    }

    private PriorityQueue<TsFileResource> sortUnSeqFileResourcesInDecendingOrder(List<TsFileResource> tsFileResources) {
        PriorityQueue<TsFileResource> unseqTsFilesSet = new PriorityQueue<TsFileResource>((o1, o2) -> {
            Long maxTimeOfO1 = o1.getEndTime(this.seriesPath.getDevice());
            Long maxTimeOfO2 = o2.getEndTime(this.seriesPath.getDevice());
            return Long.compare(maxTimeOfO2, maxTimeOfO1);
        });
        unseqTsFilesSet.addAll(tsFileResources);
        return unseqTsFilesSet;
    }

    private PriorityQueue<ChunkMetadata> sortUnseqChunkMetadatasByEndtime() throws IOException {
        PriorityQueue<ChunkMetadata> chunkMetadataList = new PriorityQueue<ChunkMetadata>((o1, o2) -> {
            long endTime2;
            long endTime1 = o1.getEndTime();
            if (endTime1 < (endTime2 = o2.getEndTime())) {
                return 1;
            }
            if (endTime1 > endTime2) {
                return -1;
            }
            return Long.compare(o2.getVersion(), o1.getVersion());
        });
        for (TimeseriesMetadata timeseriesMetadata : this.unseqTimeseriesMetadataList) {
            if (timeseriesMetadata == null) continue;
            chunkMetadataList.addAll(timeseriesMetadata.loadChunkMetadataList());
        }
        return chunkMetadataList;
    }

    private boolean endtimeContainedByTimeFilter(Statistics statistics) {
        if (this.timeFilter == null) {
            return true;
        }
        return this.timeFilter.containStartEndTime(statistics.getEndTime(), statistics.getEndTime());
    }

    private TimeValuePair constructLastPair(long timestamp, Object value, TSDataType dataType) {
        return new TimeValuePair(timestamp, TsPrimitiveType.getByType((TSDataType)dataType, (Object)value));
    }
}

